/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.LocalShapeInfo;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;

public class LocalConvexResult
extends BulletBase {
    private long swigCPtr;

    protected LocalConvexResult(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public LocalConvexResult(long cPtr, boolean cMemoryOwn) {
        this("LocalConvexResult", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(LocalConvexResult obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_LocalConvexResult(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public LocalConvexResult(btCollisionObject hitCollisionObject, LocalShapeInfo localShapeInfo, Vector3 hitNormalLocal, Vector3 hitPointLocal, float hitFraction) {
        this(CollisionJNI.new_LocalConvexResult(btCollisionObject.getCPtr(hitCollisionObject), hitCollisionObject, LocalShapeInfo.getCPtr(localShapeInfo), localShapeInfo, hitNormalLocal, hitPointLocal, hitFraction), true);
    }

    public void setHitCollisionObject(btCollisionObject value) {
        CollisionJNI.LocalConvexResult_hitCollisionObject_set(this.swigCPtr, this, btCollisionObject.getCPtr(value), value);
    }

    public btCollisionObject getHitCollisionObject() {
        return btCollisionObject.getInstance(CollisionJNI.LocalConvexResult_hitCollisionObject_get(this.swigCPtr, this), false);
    }

    public void setLocalShapeInfo(LocalShapeInfo value) {
        CollisionJNI.LocalConvexResult_localShapeInfo_set(this.swigCPtr, this, LocalShapeInfo.getCPtr(value), value);
    }

    public LocalShapeInfo getLocalShapeInfo() {
        long cPtr = CollisionJNI.LocalConvexResult_localShapeInfo_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new LocalShapeInfo(cPtr, false);
    }

    public void setHitFraction(float value) {
        CollisionJNI.LocalConvexResult_hitFraction_set(this.swigCPtr, this, value);
    }

    public float getHitFraction() {
        return CollisionJNI.LocalConvexResult_hitFraction_get(this.swigCPtr, this);
    }

    public void getHitNormalLocal(Vector3 out) {
        CollisionJNI.LocalConvexResult_getHitNormalLocal(this.swigCPtr, this, out);
    }

    public void setHitNormalLocal(Vector3 value) {
        CollisionJNI.LocalConvexResult_setHitNormalLocal(this.swigCPtr, this, value);
    }

    public void getHitPointLocal(Vector3 out) {
        CollisionJNI.LocalConvexResult_getHitPointLocal(this.swigCPtr, this, out);
    }

    public void setHitPointLocal(Vector3 value) {
        CollisionJNI.LocalConvexResult_setHitPointLocal(this.swigCPtr, this, value);
    }
}

