/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.SWIGTYPE_p_PHY_ScalarType;
import com.badlogic.gdx.physics.bullet.collision.SWIGTYPE_p_btAlignedObjectArrayT_btIndexedMesh_t;
import com.badlogic.gdx.physics.bullet.collision.SWIGTYPE_p_int;
import com.badlogic.gdx.physics.bullet.collision.SWIGTYPE_p_p_unsigned_char;
import com.badlogic.gdx.physics.bullet.collision.btIndexedMesh;
import com.badlogic.gdx.physics.bullet.collision.btStridingMeshInterface;
import com.badlogic.gdx.utils.Array;

public class btTriangleIndexVertexArray
extends btStridingMeshInterface {
    private long swigCPtr;
    protected static final Array<btTriangleIndexVertexArray> instances = new Array();
    protected final Array<btIndexedMesh> meshes = new Array(1);

    protected btTriangleIndexVertexArray(String className, long cPtr, boolean cMemoryOwn) {
        super(className, CollisionJNI.btTriangleIndexVertexArray_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btTriangleIndexVertexArray(long cPtr, boolean cMemoryOwn) {
        this("btTriangleIndexVertexArray", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(CollisionJNI.btTriangleIndexVertexArray_SWIGUpcast(this.swigCPtr), cMemoryOwn);
    }

    public static long getCPtr(btTriangleIndexVertexArray obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btTriangleIndexVertexArray(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static <T> boolean compare(btTriangleIndexVertexArray array, Array<T> tags) {
        if (array.meshes.size != tags.size) {
            return false;
        }
        for (btIndexedMesh mesh : array.meshes) {
            boolean found = false;
            Object tag = mesh.tag;
            if (tag == null) {
                return false;
            }
            for (Object t : tags) {
                if (!t.equals(tag)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    protected static <T> btTriangleIndexVertexArray getInstance(Array<T> tags) {
        for (btTriangleIndexVertexArray instance : instances) {
            if (!btTriangleIndexVertexArray.compare(instance, tags)) continue;
            return instance;
        }
        return null;
    }

    public static <T extends MeshPart> btTriangleIndexVertexArray obtain(Array<T> meshParts) {
        btTriangleIndexVertexArray result = btTriangleIndexVertexArray.getInstance(meshParts);
        if (result == null) {
            result = new btTriangleIndexVertexArray(meshParts);
            instances.add(result);
        }
        result.obtain();
        return result;
    }

    public btTriangleIndexVertexArray(MeshPart meshPart) {
        this();
        this.addMeshPart(meshPart);
    }

    public <T extends MeshPart> btTriangleIndexVertexArray(Iterable<T> meshParts) {
        this();
        this.addMeshParts(meshParts);
    }

    public int getIndexedMeshCount() {
        return this.meshes.size;
    }

    public btIndexedMesh getIndexedMesh(int index) {
        return this.meshes.get(index);
    }

    public btTriangleIndexVertexArray addMeshPart(MeshPart meshPart) {
        btIndexedMesh mesh = btIndexedMesh.obtain(meshPart);
        this.addIndexedMesh(mesh, 3);
        mesh.release();
        return this;
    }

    public btTriangleIndexVertexArray addMeshParts(MeshPart ... meshParts) {
        for (int i = 0; i < meshParts.length; ++i) {
            this.addMeshPart(meshParts[i]);
        }
        return this;
    }

    public <T extends MeshPart> btTriangleIndexVertexArray addMeshParts(Iterable<T> meshParts) {
        for (MeshPart meshPart : meshParts) {
            this.addMeshPart(meshPart);
        }
        return this;
    }

    public <T extends NodePart> btTriangleIndexVertexArray addNodeParts(Iterable<T> nodeParts) {
        for (NodePart nodePart : nodeParts) {
            this.addMeshPart(nodePart.meshPart);
        }
        return this;
    }

    public btTriangleIndexVertexArray addIndexedMesh(btIndexedMesh mesh, int indexType) {
        mesh.obtain();
        this.internalAddIndexedMesh(mesh, indexType);
        this.meshes.add(mesh);
        return this;
    }

    public btTriangleIndexVertexArray addIndexedMesh(btIndexedMesh mesh) {
        return this.addIndexedMesh(mesh, 3);
    }

    @Override
    public void dispose() {
        for (btIndexedMesh mesh : this.meshes) {
            mesh.release();
        }
        this.meshes.clear();
        super.dispose();
    }

    @Override
    public long operatorNew(long sizeInBytes) {
        return CollisionJNI.btTriangleIndexVertexArray_operatorNew__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    @Override
    public void operatorDelete(long ptr) {
        CollisionJNI.btTriangleIndexVertexArray_operatorDelete__SWIG_0(this.swigCPtr, this, ptr);
    }

    @Override
    public long operatorNew(long arg0, long ptr) {
        return CollisionJNI.btTriangleIndexVertexArray_operatorNew__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    @Override
    public void operatorDelete(long arg0, long arg1) {
        CollisionJNI.btTriangleIndexVertexArray_operatorDelete__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    @Override
    public long operatorNewArray(long sizeInBytes) {
        return CollisionJNI.btTriangleIndexVertexArray_operatorNewArray__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    @Override
    public void operatorDeleteArray(long ptr) {
        CollisionJNI.btTriangleIndexVertexArray_operatorDeleteArray__SWIG_0(this.swigCPtr, this, ptr);
    }

    @Override
    public long operatorNewArray(long arg0, long ptr) {
        return CollisionJNI.btTriangleIndexVertexArray_operatorNewArray__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    @Override
    public void operatorDeleteArray(long arg0, long arg1) {
        CollisionJNI.btTriangleIndexVertexArray_operatorDeleteArray__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public btTriangleIndexVertexArray() {
        this(CollisionJNI.new_btTriangleIndexVertexArray(), true);
    }

    private void internalAddIndexedMesh(btIndexedMesh mesh, int indexType) {
        CollisionJNI.btTriangleIndexVertexArray_internalAddIndexedMesh__SWIG_0(this.swigCPtr, this, btIndexedMesh.getCPtr(mesh), mesh, indexType);
    }

    private void internalAddIndexedMesh(btIndexedMesh mesh) {
        CollisionJNI.btTriangleIndexVertexArray_internalAddIndexedMesh__SWIG_1(this.swigCPtr, this, btIndexedMesh.getCPtr(mesh), mesh);
    }

    @Override
    public void getLockedVertexIndexBase(SWIGTYPE_p_p_unsigned_char vertexbase, SWIGTYPE_p_int numverts, SWIGTYPE_p_PHY_ScalarType type, SWIGTYPE_p_int vertexStride, SWIGTYPE_p_p_unsigned_char indexbase, SWIGTYPE_p_int indexstride, SWIGTYPE_p_int numfaces, SWIGTYPE_p_PHY_ScalarType indicestype, int subpart) {
        CollisionJNI.btTriangleIndexVertexArray_getLockedVertexIndexBase__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_p_unsigned_char.getCPtr(vertexbase), SWIGTYPE_p_int.getCPtr(numverts), SWIGTYPE_p_PHY_ScalarType.getCPtr(type), SWIGTYPE_p_int.getCPtr(vertexStride), SWIGTYPE_p_p_unsigned_char.getCPtr(indexbase), SWIGTYPE_p_int.getCPtr(indexstride), SWIGTYPE_p_int.getCPtr(numfaces), SWIGTYPE_p_PHY_ScalarType.getCPtr(indicestype), subpart);
    }

    @Override
    public void getLockedVertexIndexBase(SWIGTYPE_p_p_unsigned_char vertexbase, SWIGTYPE_p_int numverts, SWIGTYPE_p_PHY_ScalarType type, SWIGTYPE_p_int vertexStride, SWIGTYPE_p_p_unsigned_char indexbase, SWIGTYPE_p_int indexstride, SWIGTYPE_p_int numfaces, SWIGTYPE_p_PHY_ScalarType indicestype) {
        CollisionJNI.btTriangleIndexVertexArray_getLockedVertexIndexBase__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_p_unsigned_char.getCPtr(vertexbase), SWIGTYPE_p_int.getCPtr(numverts), SWIGTYPE_p_PHY_ScalarType.getCPtr(type), SWIGTYPE_p_int.getCPtr(vertexStride), SWIGTYPE_p_p_unsigned_char.getCPtr(indexbase), SWIGTYPE_p_int.getCPtr(indexstride), SWIGTYPE_p_int.getCPtr(numfaces), SWIGTYPE_p_PHY_ScalarType.getCPtr(indicestype));
    }

    @Override
    public void getLockedReadOnlyVertexIndexBase(SWIGTYPE_p_p_unsigned_char vertexbase, SWIGTYPE_p_int numverts, SWIGTYPE_p_PHY_ScalarType type, SWIGTYPE_p_int vertexStride, SWIGTYPE_p_p_unsigned_char indexbase, SWIGTYPE_p_int indexstride, SWIGTYPE_p_int numfaces, SWIGTYPE_p_PHY_ScalarType indicestype, int subpart) {
        CollisionJNI.btTriangleIndexVertexArray_getLockedReadOnlyVertexIndexBase__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_p_unsigned_char.getCPtr(vertexbase), SWIGTYPE_p_int.getCPtr(numverts), SWIGTYPE_p_PHY_ScalarType.getCPtr(type), SWIGTYPE_p_int.getCPtr(vertexStride), SWIGTYPE_p_p_unsigned_char.getCPtr(indexbase), SWIGTYPE_p_int.getCPtr(indexstride), SWIGTYPE_p_int.getCPtr(numfaces), SWIGTYPE_p_PHY_ScalarType.getCPtr(indicestype), subpart);
    }

    @Override
    public void getLockedReadOnlyVertexIndexBase(SWIGTYPE_p_p_unsigned_char vertexbase, SWIGTYPE_p_int numverts, SWIGTYPE_p_PHY_ScalarType type, SWIGTYPE_p_int vertexStride, SWIGTYPE_p_p_unsigned_char indexbase, SWIGTYPE_p_int indexstride, SWIGTYPE_p_int numfaces, SWIGTYPE_p_PHY_ScalarType indicestype) {
        CollisionJNI.btTriangleIndexVertexArray_getLockedReadOnlyVertexIndexBase__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_p_unsigned_char.getCPtr(vertexbase), SWIGTYPE_p_int.getCPtr(numverts), SWIGTYPE_p_PHY_ScalarType.getCPtr(type), SWIGTYPE_p_int.getCPtr(vertexStride), SWIGTYPE_p_p_unsigned_char.getCPtr(indexbase), SWIGTYPE_p_int.getCPtr(indexstride), SWIGTYPE_p_int.getCPtr(numfaces), SWIGTYPE_p_PHY_ScalarType.getCPtr(indicestype));
    }

    public SWIGTYPE_p_btAlignedObjectArrayT_btIndexedMesh_t getIndexedMeshArray() {
        return new SWIGTYPE_p_btAlignedObjectArrayT_btIndexedMesh_t(CollisionJNI.btTriangleIndexVertexArray_getIndexedMeshArray(this.swigCPtr, this), false);
    }
}

