/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.ent.group;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.global.chance.RarityUtils;
import com.tann.dice.util.ChanceHaver;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Rectactor;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum PartyLayoutType implements ChanceHaver
{
    Basic(RarityUtils.IGNORED_RARITY, HeroCol.orange, HeroCol.yellow, HeroCol.grey, HeroCol.red, HeroCol.blue),
    Greens(1.0f, HeroCol.green, HeroCol.green, HeroCol.grey, HeroCol.orange, HeroCol.yellow),
    Force(1.0f, HeroCol.yellow, HeroCol.yellow, HeroCol.orange, HeroCol.grey, HeroCol.grey),
    Magical(0.8f, HeroCol.red, HeroCol.red, HeroCol.blue, HeroCol.green, HeroCol.orange),
    Flex(0.7f, HeroCol.green, HeroCol.yellow, null, HeroCol.blue, HeroCol.red),
    Mountain(0.3f, HeroCol.blue, HeroCol.blue, HeroCol.grey, HeroCol.grey, HeroCol.green),
    Defensive(0.2f, HeroCol.red, HeroCol.red, HeroCol.grey, HeroCol.grey, HeroCol.yellow),
    RNG(0.2f, null, null, null, null, null),
    Strays(0.1f, HeroCol.grey, HeroCol.orange, HeroCol.orange, null, null),
    Cisab(0.1f, HeroCol.blue, HeroCol.red, HeroCol.grey, HeroCol.yellow, HeroCol.orange),
    Rush(0.05f, HeroCol.blue, HeroCol.blue, HeroCol.orange, HeroCol.grey, HeroCol.yellow),
    Surrounded(PartyLayoutType.GAR(), null, null, HeroCol.red, null, null),
    DMLS(PartyLayoutType.GAR(), HeroCol.red, HeroCol.red, HeroCol.grey, HeroCol.red, HeroCol.red),
    Sunset(PartyLayoutType.GAR(), HeroCol.blue, HeroCol.orange, HeroCol.yellow, null, HeroCol.green),
    CornCob(PartyLayoutType.GAR(), HeroCol.yellow, HeroCol.yellow, HeroCol.yellow, HeroCol.yellow, HeroCol.yellow),
    Beach(PartyLayoutType.GAR(), HeroCol.blue, HeroCol.blue, HeroCol.yellow, HeroCol.yellow, HeroCol.yellow),
    Sword(PartyLayoutType.GAR(), HeroCol.orange, HeroCol.orange, HeroCol.grey, HeroCol.grey, HeroCol.grey),
    LampPost(PartyLayoutType.GAR(), null, HeroCol.yellow, HeroCol.grey, HeroCol.grey, HeroCol.grey);

    private final float chance;
    private final HeroCol[] cols;

    private PartyLayoutType(float chance, HeroCol ... cols) {
        this.chance = chance;
        this.cols = cols;
    }

    public static float GAR() {
        return 0.001f;
    }

    public static PartyLayoutType guessLayout(List<HeroType> types) {
        for (PartyLayoutType value : PartyLayoutType.values()) {
            if (types.size() != value.cols.length) continue;
            boolean good = true;
            for (int i = 0; i < value.cols.length; ++i) {
                if (types.get((int)i).heroCol == value.cols[i]) continue;
                good = false;
                break;
            }
            if (!good) continue;
            return value;
        }
        return RNG;
    }

    private static List<PartyLayoutType> makeAllUnlocked() {
        PartyLayoutType[] vals = PartyLayoutType.values();
        ArrayList<PartyLayoutType> result = new ArrayList<PartyLayoutType>();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i].isLockedMeta()) continue;
            result.add(vals[i]);
        }
        return result;
    }

    public static PartyLayoutType[] exceptBasic() {
        List<PartyLayoutType> rs = PartyLayoutType.makeAllUnlocked();
        rs.remove(Basic);
        return rs.toArray(new PartyLayoutType[0]);
    }

    public static PartyLayoutType[] includingBasic() {
        throw new RuntimeException();
    }

    public HeroCol[] getColsInstance() {
        HeroCol[] result = new HeroCol[this.cols.length];
        for (int i = 0; i < this.cols.length; ++i) {
            result[i] = this.cols[i];
            if (result[i] != null) continue;
            result[i] = HeroCol.randomUnlockedBasic();
        }
        return result;
    }

    public Actor visualise() {
        return this.visualiseVertical2();
    }

    public Actor visualiseVertical2() {
        int ww = Math.min(54, Main.width / 4);
        return this.addRarityIfNecessary(new Pixl(3, 4).forceWidth(ww).border(Colours.grey).text(this.name())).row().rowedActors(PartyLayoutType.makeRectactors(this.cols)).pix();
    }

    public Pixl addRarityIfNecessary(Pixl p) {
        if (OptionLib.SHOW_RARITY.c()) {
            if (this.getChance() == RarityUtils.IGNORED_RARITY) {
                p.row().text("[grey]-------");
            } else {
                p.row().text("[grey]r: " + this.getChance());
            }
        }
        return p;
    }

    public static List<? extends Actor> makeRectactors(HeroCol[] cols) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        for (HeroCol col : cols) {
            Rectactor r = PartyLayoutType.makeRectactor(col);
            if (col == null) {
                result.add(Tann.actorWithText(r, "[light]?", Colours.dark));
                continue;
            }
            result.add(r);
        }
        return result;
    }

    private static Color getColSafe(HeroCol hc) {
        if (hc == null) {
            return Colours.light;
        }
        return hc.col;
    }

    private static Rectactor makeRectactor(HeroCol heroCol) {
        Color col = PartyLayoutType.getColSafe(heroCol);
        int rectSize = 10;
        return new Rectactor(10, 10, col, col);
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    public int length() {
        return this.cols.length;
    }

    public static PartyLayoutType random() {
        return (PartyLayoutType)Tann.randomChanced((ChanceHaver[])PartyLayoutType.values());
    }

    public long getBannedCollisionBits(boolean spellRequiresTwo) {
        return Party.getBannedCollisionBits(Arrays.asList(this.cols), spellRequiresTwo);
    }

    public boolean isLockedMeta() {
        for (int i = 0; i < this.cols.length; ++i) {
            if (!UnUtil.isLocked(this.cols[i])) continue;
            return true;
        }
        return false;
    }

    public Actor visualiseTiny() {
        boolean s = true;
        ArrayList<Rectactor> actors = new ArrayList<Rectactor>();
        for (HeroCol col : this.cols) {
            actors.add(new Rectactor(1, 1, PartyLayoutType.getColSafe(col)));
        }
        return new Pixl().rowedActors(actors).pix();
    }
}

