/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.entity.hero;

import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.bill.HTBill;
import com.tann.dice.gameplay.content.gen.pipe.MissingnoPipe;
import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.content.gen.pipe.PipeMaster;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHeroAbility;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHeroCol;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHeroHP;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHeroItem;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHeroSides;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHeroTw1n;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate.PipeHeroAdjust;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate.PipeHeroGenerated;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeCache;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaBracketed;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaDocument;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaIndexed;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaRandomTier;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaRename;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaSetTier;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaX;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSourceHero;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.texture.PipeMetaTexture;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.heroLevelupAffect.HeroGenType;
import com.tann.dice.gameplay.trigger.personal.RenameHero;
import java.util.ArrayList;
import java.util.List;

public abstract class PipeHero {
    private static HeroType missingno;
    private static PipeCache<HeroType> pmc;
    public static List<Pipe<HeroType>> pipes;

    public static void init(List<HeroType> designed) {
        DataSourceHero ds = new DataSourceHero();
        pipes = new ArrayList<Pipe<HeroType>>();
        pipes.add(new PipeMaster<HeroType>(designed));
        pmc = new PipeCache();
        pipes.add(pmc);
        pipes.add(new PipeHeroTw1n());
        pipes.add(new PipeHeroGenerated());
        pipes.add(new PipeHeroHP());
        pipes.add(new PipeHeroCol());
        pipes.add(new PipeHeroAbility());
        pipes.addAll(PipeMetaSetTier.makeAll(ds));
        pipes.add(new PipeHeroAdjust());
        pipes.addAll(PipeMetaRename.makeAll(ds));
        pipes.add(new PipeHeroSides());
        pipes.addAll(PipeMetaX.makeAll(ds));
        pipes.add(new PipeMetaRandomTier<HeroType>(ds));
        pipes.addAll(PipeMetaTexture.makeAll(ds));
        pipes.addAll(PipeMetaIndexed.makeAll(ds));
        pipes.addAll(PipeMetaDocument.makeAll(ds));
        pipes.addAll(PipeMetaBracketed.makeAll(ds));
        pipes.add(new PipeHeroItem());
        missingno = PipeHero.makeMissingno();
        pipes.add(new MissingnoPipe<HeroType>(missingno));
    }

    private static HeroType makeMissingno() {
        return ((HTBill)((HTBill)((HTBill)((HTBill)new HTBill(HeroCol.violet, -1).name("Glitch")).hp(6)).texture("special/glitch")).sides(ESB.wandFightBonus.val(1), ESB.blank, ESB.wandStun, ESB.shieldCrescent.val(1), ESB.heal.val(666).withKeyword(Keyword.rampage), ESB.blank)).bEntType();
    }

    public static HeroType fetch(String name) {
        if (!Pipe.DANGEROUS_NONMODIFIER_PIPE_CHARS.matcher(name).matches()) {
            return PipeHero.getMissingno();
        }
        return Pipe.checkPipes(pipes, name, pmc);
    }

    public static HeroType getMissingno() {
        return missingno;
    }

    public static HeroGenType getGenType(List<Global> globals) {
        for (int i = 0; i < globals.size(); ++i) {
            HeroGenType hgt = globals.get(i).generateHeroes();
            if (hgt == null) continue;
            return hgt;
        }
        return HeroGenType.Normal;
    }

    public static boolean hasRename(EntType result) {
        for (Trait trait : result.traits) {
            if (!(trait.personal instanceof RenameHero)) continue;
            return true;
        }
        return false;
    }
}

