/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.entity.hero;

import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNMid;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.trigger.personal.item.AsIfHasItem;

public class PipeHeroItem
extends PipeRegexNamed<HeroType> {
    public static final PRNPart SEP = new PRNMid("i");

    public PipeHeroItem() {
        super(HERO, SEP, ITEM);
    }

    @Override
    protected HeroType internalMake(String[] groups) {
        String heroName = groups[0];
        String itemName = groups[1];
        return this.make(heroName, itemName);
    }

    private HeroType make(String heroName, String itemName) {
        if (heroName == null || itemName == null || heroName.isEmpty() || itemName.isEmpty()) {
            return null;
        }
        HeroType ht = HeroTypeLib.byName(heroName);
        Item i = ItemLib.byName(itemName);
        if (ht.isMissingno() || i.isMissingno()) {
            return null;
        }
        AsIfHasItem aiha = new AsIfHasItem(i);
        String realHeroName = heroName + SEP + itemName;
        HeroType result = HeroTypeUtils.withPassive(ht, realHeroName, aiha, "[grey]innate item: " + i.getName(true));
        return result;
    }

    @Override
    public HeroType example() {
        return this.make(HeroTypeUtils.random().getName(), ItemLib.random().getName());
    }

    @Override
    public boolean showHigher() {
        return true;
    }
}

