/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.entity.monster;

import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.bill.MTBill;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.modifier.generation.GenUtils;
import com.tann.dice.util.Tann;
import com.tann.dice.util.WhiskerRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;

public class PipeMonsterGenerated
extends PipeRegexNamed<MonsterType> {
    private static final String PREF = "rmon.";

    public PipeMonsterGenerated() {
        super(PipeMonsterGenerated.prnS(PREF), UP_TO_FIFTEEN_HEX);
    }

    @Override
    protected MonsterType internalMake(String[] groups) {
        long seed = GenUtils.hex(groups[0]);
        if (seed < 0L) {
            return null;
        }
        return PipeMonsterGenerated.makeMonst(seed);
    }

    public static MonsterType makeMonstExt() {
        return PipeMonsterGenerated.makeMonstExt((long)(Math.random() * 10000.0));
    }

    public static MonsterType makeMonstExt(long seed) {
        return PipeMonsterGenerated.makeMonst(seed);
    }

    private static MonsterType makeMonst(long seed) {
        WhiskerRandom r = new WhiskerRandom(seed);
        EntSize size = Tann.random(EntSize.values(), (Random)r);
        if (size == EntSize.huge) {
            size = Tann.random(EntSize.values(), (Random)r);
        }
        float variance = 0.2f;
        int hp = (int)((float)(size.getPixels() - 6) * (r.nextFloat() * variance * 2.0f + (1.0f - variance)));
        ArrayList<EntSide> sides = new ArrayList<EntSide>();
        for (int i = 0; i < 3; ++i) {
            EntSide side = PipeMonsterGenerated.getRandomSide(r, size);
            sides.add(side);
            sides.add(side);
        }
        Collections.sort(sides, new Comparator<EntSide>(){

            @Override
            public int compare(EntSide o1, EntSide o2) {
                return o2.getBaseEffect().getValue() - o1.getBaseEffect().getValue();
            }
        });
        MTBill mtb = (MTBill)((MTBill)new MTBill(size).hp(hp)).name(PREF + GenUtils.hex(seed));
        mtb.texture("special/rm");
        mtb.sides(sides.toArray(new EntSide[0]));
        Trait t = PipeMonsterGenerated.randomTrait(r);
        if (t != null && !t.personal.metaOnly()) {
            mtb.trait(t);
        }
        return mtb.bEntType();
    }

    private static Trait randomTrait(Random r) {
        MonsterType mt = PipeMonsterGenerated.randomMonster(r, null);
        for (Trait t : mt.traits) {
            if (!t.visible) continue;
            return t;
        }
        return null;
    }

    private static EntSide getRandomSide(Random r, EntSize size) {
        MonsterType mt = PipeMonsterGenerated.randomMonster(r, size);
        return Tann.random(mt.sides, r).copy();
    }

    private static MonsterType randomMonster(Random r, EntSize size) {
        if (size == null) {
            return Tann.random(MonsterTypeLib.getMasterCopy(), r);
        }
        return Tann.random(MonsterTypeLib.getWithSize(size), r);
    }

    @Override
    public MonsterType example() {
        return PipeMonsterGenerated.makeMonst((long)(Math.random() * Math.pow(16.0, 3.0)));
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return true;
    }

    @Override
    protected MonsterType generateInternal(boolean wild) {
        return this.example();
    }
}

