/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.item;

import com.tann.dice.gameplay.content.gen.pipe.MissingnoPipe;
import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.content.gen.pipe.PipeMaster;
import com.tann.dice.gameplay.content.gen.pipe.PipeUtils;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemAbility;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemCombined;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemGenerated;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemGeneratedTiered;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemHat;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemKeyword;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemMultiplyValues;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemPart;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemPerTier;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemPosition;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemSelf;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemTrait;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemUnpack;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeCache;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaBracketed;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaDocument;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaIndexed;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaRandomTier;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaRename;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaSetTier;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaX;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSourceItem;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.texture.PipeMetaTexture;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableUtils;
import com.tann.dice.gameplay.trigger.personal.OnOverheal;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;

public abstract class PipeItem {
    private static Item MISSINGNO_REAL;
    private static final String MISSINGNO_NAME = "err";
    public static final int QUALITY_MISSINGNO = -50;
    private static PipeCache<Item> pmc;
    public static List<Pipe<Item>> pipes;
    private static final int FALLBACK_ATTEMPTS = 50;

    public static void init(List<Item> all) {
        DataSourceItem ds = new DataSourceItem();
        pipes = new ArrayList<Pipe<Item>>();
        pipes.add(new PipeMaster<Item>(all));
        pmc = new PipeCache();
        pipes.add(pmc);
        pipes.add(new PipeItemKeyword());
        pipes.add(new PipeItemPosition());
        pipes.add(new PipeItemMultiplyValues());
        pipes.addAll(PipeMetaX.makeAll(ds));
        pipes.addAll(PipeMetaSetTier.makeAll(ds));
        pipes.addAll(PipeMetaRename.makeAll(ds));
        pipes.addAll(PipeMetaDocument.makeAll(ds));
        pipes.add(new PipeItemPerTier());
        pipes.add(new PipeItemPart());
        pipes.add(new PipeMetaRandomTier<Item>(ds));
        pipes.addAll(PipeMetaTexture.makeAll(ds));
        pipes.addAll(PipeMetaIndexed.makeAll(ds));
        pipes.addAll(PipeMetaBracketed.makeAll(ds));
        pipes.add(new PipeItemUnpack());
        pipes.add(new PipeItemGeneratedTiered());
        pipes.add(new PipeItemGenerated());
        pipes.add(new PipeItemSelf());
        pipes.add(new PipeItemAbility());
        pipes.add(new PipeItemHat());
        pipes.add(new PipeItemTrait());
        pipes.add(new PipeItemCombined());
        MISSINGNO_REAL = new ItBill(-50, MISSINGNO_NAME, "special/bug").hidden().trigger(new OnOverheal(new EffBill().summon("error", 1))).bItem();
        pipes.add(new MissingnoPipe<Item>(MISSINGNO_REAL));
    }

    public static Item fetch(String name) {
        if (!Pipe.DANGEROUS_NONMODIFIER_PIPE_CHARS.matcher(name).matches()) {
            return PipeItem.getMissingno();
        }
        return Pipe.checkPipes(pipes, name, pmc);
    }

    public static Item getMissingno() {
        return MISSINGNO_REAL;
    }

    public static Item makeGen() {
        boolean wild = true;
        int attempts = 20;
        List<Pipe<Item>> gennablePipes = PipeItem.getGenPipes(wild);
        for (int i = 0; i < 20; ++i) {
            Pipe<Item> pm = PipeItem.randomPipeForGen(gennablePipes, wild);
            Item item = pm.generate(wild);
            if (item == null || item.isMissingno() || item.getTier() == 0) continue;
            return item;
        }
        return PipeItem.getMissingno();
    }

    private static boolean roundtrip(Item item) {
        Item rounded = ItemLib.byName(item.getName());
        return rounded.getName().equalsIgnoreCase(item.getName()) && rounded.getTier() == item.getTier() && rounded.getDescription().equalsIgnoreCase(item.getDescription());
    }

    private static Pipe<Item> randomPipeForGen(List<Pipe<Item>> gennablePipes, boolean wild) {
        return PipeUtils.randomPipeForGen(gennablePipes, wild);
    }

    private static List<Pipe<Item>> getGenPipes(boolean wild) {
        return PipeUtils.getGenPipes(pipes, wild);
    }

    public static Item makeTieredMaybeNull(int tier, int attempts, long bannedBits) {
        for (int i = 0; i < attempts; ++i) {
            Item maybe = PipeItem.makeGen();
            if (maybe.isMissingno() || maybe.getTier() != tier || (bannedBits & maybe.getCollisionBits()) != 0L) continue;
            return maybe;
        }
        return null;
    }

    public static Item makeTieredMaybeNull(int tier, long bannedBits) {
        return PipeItem.makeTieredMaybeNull(tier, 100, bannedBits);
    }

    public static Item makeFallback(int itemTier) {
        return PipeItem.makeFallback(itemTier, 0L);
    }

    public static Item makeFallback(int itemTier, long bannedCollisionBits) {
        Item pregen = PipeItem.makeTieredMaybeNull(itemTier, 30, bannedCollisionBits);
        if (pregen != null && !pregen.isMissingno()) {
            return PipeItem.cacheReturn(pregen);
        }
        if (itemTier > 30) {
            return PipeItem.getMissingno();
        }
        int minTier = itemTier > 0 ? 1 : itemTier + 1;
        int maxTier = itemTier > 0 ? itemTier - 1 : -1;
        for (int i = 0; i < 50; ++i) {
            Item comb;
            if (itemTier % 2 == 0) {
                int attempts = 5;
                for (int i1 = 0; i1 < 5; ++i1) {
                    Item multid;
                    Item half = ItemLib.randomWithExactQuality(1, itemTier / 2, 0L).get(0);
                    if (half.isMissingno() || ChoosableUtils.collides((Choosable)half, bannedCollisionBits) || (multid = DataSourceItem.multiMake(half, 2)) == null) continue;
                    return PipeItem.cacheReturn(multid);
                }
            }
            int tierA = Tann.randomInt(minTier, maxTier);
            int tierB = itemTier - tierA;
            Item a = ItemLib.randomWithExactQuality(1, tierA, 0L).get(0);
            Item b = ItemLib.randomWithExactQuality(1, tierB, 0L).get(0);
            if (a.isMissingno() || b.isMissingno() || ChoosableUtils.collides((Choosable)a, bannedCollisionBits) || ChoosableUtils.collides((Choosable)b, bannedCollisionBits) || (a.getCollisionBitsIncludingGenericTransformed() & b.getCollisionBitsIncludingGenericTransformed()) != 0L || (comb = PipeItemCombined.makeChecked(a, b)) == null) continue;
            return PipeItem.cacheReturn(comb);
        }
        return PipeItem.getMissingno();
    }

    public static Item cacheReturn(Item i) {
        return ItemLib.byName(i.getName());
    }
}

