/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.item;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.modifier.generation.GenUtils;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.linked.MultiDifferentPersonal;
import com.tann.dice.gameplay.trigger.personal.util.PersonalGeneration;
import com.tann.dice.util.Tann;
import com.tann.dice.util.WhiskerRandom;
import java.util.Random;

public class PipeItemGenerated
extends PipeRegexNamed<Item> {
    public static final PRNPart PREF = new PRNPref("ritemx");

    public PipeItemGenerated() {
        super(PREF, UP_TO_FIFTEEN_HEX);
    }

    @Override
    protected Item internalMake(String[] groups) {
        String seed = groups[0];
        long hx = GenUtils.hex(seed);
        if (hx < 0L) {
            return null;
        }
        WhiskerRandom r = new WhiskerRandom(hx);
        return PipeItemGenerated.make(PREF + seed, r);
    }

    private static Item make(String name, Random r) {
        ItBill ib = new ItBill(0, name, "special/full");
        int amt = (int)(r.nextFloat() * r.nextFloat() * 3.0f + 1.0f);
        for (int i = 0; i < amt; ++i) {
            Personal p = PersonalGeneration.random(r);
            if (p instanceof MultiDifferentPersonal) {
                MultiDifferentPersonal mdp = (MultiDifferentPersonal)p;
                ib.trigger(mdp.personals);
                continue;
            }
            ib.trigger(PersonalGeneration.random(r));
        }
        return ib.bItem();
    }

    @Override
    public Item example() {
        int seed = Tann.randomInt(100000);
        return PipeItemGenerated.make(PREF + GenUtils.hex(seed), new WhiskerRandom(seed));
    }
}

