/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.item;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.eff.GlobalEndTurnEff;
import com.tann.dice.gameplay.trigger.global.eff.GlobalStartTurnEff;
import com.tann.dice.gameplay.trigger.global.linked.GlobalPositional;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalAllEntities;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.GlobalTurnRequirement;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.eff.EndOfTurnEff;
import com.tann.dice.gameplay.trigger.personal.eff.StartOfTurnSelf;
import com.tann.dice.gameplay.trigger.personal.linked.PersonalTurnRequirement;

public class PipeItemSelf
extends PipeRegexNamed<Item> {
    static final PRNPart PREF = new PRNPref("self");

    public PipeItemSelf() {
        super(PREF, MOD);
    }

    @Override
    protected Item internalMake(String[] groups) {
        String modName = groups[0];
        return this.make(ModifierLib.byName(modName));
    }

    private Item make(Modifier src) {
        if (src.isMissingno()) {
            return null;
        }
        Global g = src.getSingleGlobalOrNull();
        if (g == null) {
            return null;
        }
        Personal p = PipeItemSelf.transformToPersonal(g);
        if (p == null) {
            return null;
        }
        return new ItBill(0, PREF + src.getName(), "special/self").trigger(p).bItem();
    }

    public static Personal transformToPersonal(Global g) {
        if (g instanceof GlobalAllEntities) {
            return ((GlobalAllEntities)g).personal;
        }
        if (g instanceof GlobalPositional) {
            return ((GlobalPositional)g).trigger;
        }
        if (g instanceof GlobalTurnRequirement) {
            Personal p;
            GlobalTurnRequirement gtr = (GlobalTurnRequirement)g;
            Global gl = gtr.debugLinked();
            if (gl != null && (p = PipeItemSelf.transformToPersonal(gl)) != null) {
                return new PersonalTurnRequirement(gtr.getRequirement(), p);
            }
        } else if (g instanceof GlobalStartTurnEff) {
            GlobalStartTurnEff gste = (GlobalStartTurnEff)g;
            Eff e = gste.getSingleEffOrNull();
            if (e == null) {
                return null;
            }
            if (e.getTargetingType() == TargetingType.Group) {
                return new StartOfTurnSelf(new Eff[]{new EffBill(e).targetType(TargetingType.Self).bEff()});
            }
        } else if (g instanceof GlobalEndTurnEff) {
            GlobalEndTurnEff gste = (GlobalEndTurnEff)g;
            Eff e = gste.getSingleEffOrNull();
            if (e == null) {
                return null;
            }
            if (e.getTargetingType() == TargetingType.Group) {
                return new EndOfTurnEff(new EffBill(e).targetType(TargetingType.Self).bEff());
            }
        }
        return null;
    }

    @Override
    public Item example() {
        return this.make(ModifierLib.random());
    }

    @Override
    public boolean showHigher() {
        return true;
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

