/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod.keyword;

import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.modBal.ModTierUtils;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalHeroes;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.util.Tann;

public class PipeModKeywordSide
extends PipeRegexNamed<Modifier> {
    private Keyword[] goodKeywords = new Keyword[]{Keyword.pain, Keyword.death};

    public PipeModKeywordSide() {
        super(SIDE_POSITION, PipeModKeywordSide.prnS("\\."), KEYWORD);
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String pos = groups[0];
        String kw = groups[1];
        if (PipeModKeywordSide.bad(pos, kw)) {
            return null;
        }
        SpecificSidesType sst = SpecificSidesType.byName(pos);
        Keyword k = Keyword.byName(kw);
        return this.make(sst, k);
    }

    private Modifier make(SpecificSidesType sst, Keyword k) {
        if (k == null || sst == null || !this.validSSt(sst) || k.spellOnly()) {
            return null;
        }
        float kv = this.getBaseVal(k);
        float tier = this.getTier(sst, kv);
        return new Modifier(tier, sst.getShortName() + "." + k.getName(), new GlobalHeroes(new AffectSides(sst, new AddKeyword(k))));
    }

    private float getTier(SpecificSidesType sst, float kv) {
        return ModTierUtils.keywordToSides(sst, kv);
    }

    private float getBaseVal(Keyword k) {
        float baseMult = 5.0f;
        switch (k) {
            case pain: {
                return ModTierUtils.painKeyword(5.0f);
            }
            case death: {
                return ModTierUtils.deathKeyword(5.0f);
            }
        }
        float dmgPw = ESB.dmg.val(1).withKeyword(k).getApproxTotalEffectTier(HeroTypeUtils.defaultHero(1));
        float shieldPw = ESB.shield.val(1).withKeyword(k).getApproxTotalEffectTier(HeroTypeUtils.defaultHero(1));
        return (Math.max(dmgPw, shieldPw) - 1.0f) * 19.0f;
    }

    private boolean validSSt(SpecificSidesType sst) {
        return !sst.isWeird();
    }

    @Override
    public Modifier example() {
        return this.make(Tann.random(SpecificSidesType.values()), Tann.random(Keyword.values()));
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return true;
    }

    @Override
    public float getRarity(boolean wild) {
        return wild ? 1.0f : 0.1f;
    }

    @Override
    protected Modifier generateInternal(boolean wild) {
        SpecificSidesType sst = Tann.random(SpecificSidesType.values());
        return this.make(sst, this.randomKeyword(wild));
    }

    private Keyword randomKeyword(boolean wild) {
        Keyword k;
        if (!wild) {
            return Tann.random(this.goodKeywords);
        }
        while (Tann.contains(this.goodKeywords, k = Tann.random(Keyword.values()))) {
        }
        return k;
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

