/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod.level;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.generation.CurseDistribution;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.GlobalLevelRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementMod;
import com.tann.dice.util.Tann;

public class PipeModNthFightShifted
extends PipeRegexNamed<Modifier> {
    public PipeModNthFightShifted() {
        super(PipeModNthFightShifted.prnS("e"), DIGIT_2_9, PipeModNthFightShifted.prnS("\\."), DIGIT, PipeModNthFightShifted.prnS("\\."), MOD);
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String n = groups[0];
        String o = groups[1];
        String m = groups[2];
        if (!Tann.isInt(n) || !Tann.isInt(o)) {
            return null;
        }
        int nInt = Integer.parseInt(n);
        int oInt = Integer.parseInt(o);
        return this.make(nInt, oInt, ModifierLib.byName(m));
    }

    private Modifier make(int per, int offset, Modifier mod) {
        if (mod.isMissingno()) {
            return null;
        }
        if (offset == 0) {
            return ModifierLib.byName("e" + per + "-" + mod.getName());
        }
        if (per <= 0 || per >= 10) {
            return null;
        }
        if (offset >= per) {
            return null;
        }
        if (per == 1) {
            return mod;
        }
        Global g = mod.getSingleGlobalOrNull();
        if (g == null || g.allLevelsOnly()) {
            return null;
        }
        float tier = (float)mod.getTier() * CurseDistribution.getMultLevelRange(20 - 20 / per, 20);
        String realName = "e" + per + "." + offset + "." + mod.getName();
        return new Modifier(tier, realName, new GlobalLevelRequirement(new LevelRequirementMod(per, per - offset), g));
    }

    @Override
    public Modifier example() {
        return this.make(Tann.randomInt(2, 8), 1, ModifierLib.random());
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

