/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod.phase;

import com.badlogic.gdx.utils.SerializationException;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.MissingnoPhase;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.GlobalAddPhase;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorHardcoded;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;

public class PipeModPhaseHardcoded
extends PipeRegexNamed<Modifier> {
    private static final PRNPart pref = new PRNPref("ph");

    public PipeModPhaseHardcoded() {
        super(pref, PHASE_STRING);
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String phs = groups[0];
        return this.create(phs);
    }

    private Modifier create(String phs) {
        try {
            Phase p = Phase.deserialise(phs, true);
            if (p instanceof MissingnoPhase || p.isInvalid()) {
                return null;
            }
            return new Modifier(pref + phs, new GlobalAddPhase(new PhaseGeneratorHardcoded(p)));
        }
        catch (SerializationException se) {
            TannLog.error("SerEx creating phase from " + phs);
            se.printStackTrace();
            return null;
        }
    }

    @Override
    public Modifier example() {
        return this.create("4" + Tann.randomString(20));
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

