/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.regex.meta;

import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMeta;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSource;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSourceHero;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSourceItem;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSourceModifier;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSourceMonster;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.generation.GenUtils;
import java.util.Arrays;
import java.util.List;

public class PipeMetaIndexed<T>
extends PipeMeta<T> {
    final DataSource sa;
    static final String HR = "z";
    static final String MN = "q";
    static final String IT = "u";
    static final String MOD = "j";

    protected PipeMetaIndexed(DataSource<T> sourceAlgorithm) {
        super(sourceAlgorithm, PipeMetaIndexed.getStart(sourceAlgorithm), UP_TO_THREE_B64);
        this.sa = sourceAlgorithm;
    }

    private static PRNPart getStart(DataSource ds) {
        if (ds instanceof DataSourceItem) {
            return PipeMetaIndexed.prnS(IT);
        }
        if (ds instanceof DataSourceModifier) {
            return PipeMetaIndexed.prnS(MOD);
        }
        if (ds instanceof DataSourceHero) {
            return PipeMetaIndexed.prnS(HR);
        }
        if (ds instanceof DataSourceMonster) {
            return PipeMetaIndexed.prnS(MN);
        }
        throw new RuntimeException("PRNPart error: " + ds.getClass().getSimpleName());
    }

    public static <T> List<PipeMetaIndexed<T>> makeAll(DataSource<T> sa) {
        return Arrays.asList(new PipeMetaIndexed<T>(sa));
    }

    public static String tinyName(EntType et) {
        if (et instanceof HeroType) {
            return PipeMetaIndexed.tinyName((HeroType)et);
        }
        if (et instanceof MonsterType) {
            return PipeMetaIndexed.tinyName((MonsterType)et);
        }
        return "??DFS?SD??";
    }

    public static String tinyName(HeroType ht) {
        int index = DataSourceHero.reverseIndex(ht);
        return PipeMetaIndexed.makeTiny(HR, index);
    }

    public static String tinyName(MonsterType mt) {
        int index = DataSourceMonster.reverseIndex(mt);
        return PipeMetaIndexed.makeTiny(MN, index);
    }

    private static String makeTiny(String start, int index) {
        if (index == -1) {
            return null;
        }
        return start + GenUtils.b64(index);
    }

    public static String tinyName(Item it) {
        return PipeMetaIndexed.makeTiny(IT, ItemLib.getMasterCopy().indexOf(it));
    }

    public static String tinyName(Modifier m) {
        return PipeMetaIndexed.makeTiny(MOD, ModifierLib.getAll().indexOf(m));
    }

    @Override
    public T example() {
        return this.sa.exampleBase();
    }

    @Override
    protected T internalMake(String[] groups) {
        String index = groups[0];
        long val = GenUtils.b64(index);
        return this.sourceAlgorithm.makeIndexed(val);
    }

    @Override
    public boolean skipAPI() {
        return true;
    }

    @Override
    public boolean isTransformative() {
        return true;
    }
}

