/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.regex.meta;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.RenameHero;
import com.tann.dice.gameplay.trigger.personal.item.PersonalItemRename;
import java.util.List;

public class RenameUtils {
    public static HeroType make(HeroType ht, String heroName, String displayName) {
        if (ht.isMissingno()) {
            return null;
        }
        RenameHero rh = new RenameHero(displayName);
        return HeroTypeUtils.withPassive(ht, heroName, (Personal)rh, null);
    }

    public static MonsterType make(MonsterType mt, String monsterName, String displayName) {
        if (mt.isMissingno()) {
            return null;
        }
        RenameHero rh = new RenameHero(displayName);
        return HeroTypeUtils.withPassive(mt, monsterName, rh, null);
    }

    private static ItBill copy(Item src, String name, TextureRegion img) {
        ItBill ib = new ItBill(src.getTier(), name, img);
        ib.trigger(src.getPersonalTriggers());
        return ib;
    }

    public static ItBill copy(Item src, String name) {
        return RenameUtils.copy(src, name, src.getImage());
    }

    public static boolean hasRename(ItBill ib) {
        List<Personal> trigs = ib.getTriggers();
        for (int i = 0; i < trigs.size(); ++i) {
            Personal p = trigs.get(i);
            if (!(p instanceof PersonalItemRename)) continue;
            return true;
        }
        return false;
    }

    public static void rename(ItBill ib, String name, boolean force) {
        if (!force && RenameUtils.hasRename(ib)) {
            return;
        }
        ib.trigger(new PersonalItemRename(name));
    }
}

