/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.eff.keyword;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.EntSidesLib;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.ConditionalBonus;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.ConditionalBonusType;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.CombinedRequirement;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.ConditionalRequirement;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.GSCConditionalRequirement;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.ParamCondition;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.TargetingRestriction;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.XORRequirement;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.eff.keyword.KeywordAllowType;
import com.tann.dice.gameplay.effect.eff.keyword.KeywordCombineType;
import com.tann.dice.gameplay.modifier.modBal.ModTierUtils;
import com.tann.dice.gameplay.trigger.global.chance.Rarity;
import com.tann.dice.screens.dungeon.panels.DieSidePanel;
import com.tann.dice.screens.dungeon.panels.Explanel.Explanel;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KUtils {
    public static final String NSQ_PLACEHOLDER = "!N2!";
    public static final String TWON_PLACEHOLDER = "!2N!";
    public static final String NP1_PLACEHOLDER = "!NP1!";
    public static final String N_PLACEHOLDER = "!N!";
    private static List<Keyword> ke;
    private static List<Keyword> kh;
    private static List<Keyword> ks;
    private static List<Keyword> kd;
    private static List<Keyword> km;
    static final List<Keyword> META;

    public static String describeAdding(Keyword other) {
        return "add " + other.getColourTaggedString() + " to target's sides for a turn";
    }

    public static String describeGroupActivate(Keyword act, boolean side) {
        return "The keyword '" + act.getColourTaggedString() + "' activates for all allies" + (side ? " (on this side)" : "");
    }

    public static String describeHavingSameValueAsLastNDice(int N) {
        String part = N == 1 ? "" : (N < 1 ? N + "? " : N + " ");
        return "this has the same pips as the " + part + KUtils.describePreviousDice();
    }

    public static String describePreviousDice() {
        return KUtils.describePreviousDice(false);
    }

    public static String describeStraightDice() {
        return "dice used before it this turn";
    }

    public static String describePreviousDice(boolean allowSpell) {
        String name = allowSpell ? "dice/spell" : "dice";
        return "previous " + name + " this turn";
    }

    public static String describeN() {
        return KUtils.describeN(null);
    }

    public static String describe2N() {
        return KUtils.describeN().replace(N_PLACEHOLDER, TWON_PLACEHOLDER);
    }

    public static String describeNP1() {
        return KUtils.describeN().replace(N_PLACEHOLDER, NP1_PLACEHOLDER);
    }

    public static String describeNSQ() {
        return KUtils.describeN().replace(N_PLACEHOLDER, NSQ_PLACEHOLDER);
    }

    public static String describeThree() {
        return KUtils.describeN().replace(N_PLACEHOLDER, "3");
    }

    public static String describeOne() {
        return KUtils.describeN().replace(N_PLACEHOLDER, "1");
    }

    public static String describeN(Boolean plus) {
        if (plus == null) {
            return N_PLACEHOLDER;
        }
        return (plus != false ? "+" : "-") + "[nbp]" + N_PLACEHOLDER;
    }

    public static String describeOneTurn() {
        return KUtils.describeThisTurn();
    }

    public static String describeThisTurn() {
        return "this turn";
    }

    public static String describeThisFight() {
        return "this fight";
    }

    public static String describeKeywords(List<Keyword> keywords) {
        String keywordResult = "";
        for (Keyword k : keywords) {
            if (keywordResult.length() > 0) {
                keywordResult = keywordResult + " ";
            }
            keywordResult = keywordResult + k.getColourTaggedString();
        }
        if (keywordResult.length() > 0) {
            return keywordResult;
        }
        return "";
    }

    public static Actor makeActor(Keyword keyword, Eff source) {
        int width = 110;
        int padding = 2;
        Pixl p = new Pixl(2, padding).border(Colours.grey);
        p.actor(new TextWriter(keyword.getColourTaggedString() + "[p][text]: " + keyword.getRules(source), width - padding * 2));
        return p.pix(10);
    }

    public static List<Actor> makeExampleSides(Keyword k) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        if (k.spellOnly()) {
            return result;
        }
        ArrayList<EntSide> realValid = new ArrayList<EntSide>();
        List<EntSide> validTmp = EntSidesLib.exampleKeywordSides(k);
        int setVal = 0;
        for (int i = 0; i < validTmp.size(); ++i) {
            EntSide check = validTmp.get(i).copy();
            if (check.getBaseEffect().getType() != EffType.Blank) {
                ++setVal;
            }
            check.getBaseEffect().setValue(setVal);
            realValid.add(check);
        }
        for (EntSide es : realValid) {
            final EntSide wk = es.withKeyword(k);
            DieSidePanel dsp = new DieSidePanel(wk, null);
            dsp.addListener(new TannListener(){

                @Override
                public boolean info(int button, float x, float y) {
                    Explanel a = new Explanel(wk, null);
                    Main.getCurrentScreen().push(a, true, true, true, 0.0f);
                    Tann.center(a);
                    return true;
                }
            });
            result.add(dsp);
        }
        return result;
    }

    public static Actor makeExplanationActor(Keyword k, int maxWidth) {
        Pixl textStuff = new Pixl(2);
        textStuff.text(k.getColourTaggedString(), maxWidth);
        textStuff.row().text("[text]" + k.getRules(), maxWidth);
        if (k.getExtraRules() != null) {
            textStuff.row().text("[purple]" + k.getExtraRules(), maxWidth);
        }
        return textStuff.pix(8);
    }

    public static float affectBaseValue(Keyword k, Eff e, int tier, float pips, boolean player) {
        float tstr = HeroTypeUtils.getEffectTierFor(tier);
        switch (k) {
            case critical: {
                return pips + 0.5f;
            }
            case bloodlust: {
                return pips + 1.9f;
            }
            case steel: {
                float extraExpected = (float)tier * 0.5f;
                if (e.getType() == EffType.Shield || e.getType() == EffType.Heal) {
                    extraExpected *= 0.5f;
                }
                if (e.getType() == EffType.Mana) {
                    extraExpected *= 1.52f;
                }
                return pips + extraExpected;
            }
            case growth: {
                return pips + 0.5f;
            }
            case era: {
                return pips + 1.0f;
            }
            case lucky: {
                return pips * 0.5f;
            }
            case charged: {
                float bonus;
                switch (e.getType()) {
                    case Shield: 
                    case Heal: {
                        bonus = (float)tier * 0.6f + 1.1f;
                        break;
                    }
                    default: {
                        bonus = (float)tier * 0.5f + 1.2f;
                        break;
                    }
                    case Damage: {
                        bonus = e.hasKeyword(Keyword.singleUse) ? (float)tier * 0.4f + 1.2f : (float)tier * 0.8f + 1.4f;
                    }
                }
                return pips + bonus;
            }
            case hoard: {
                float bonus = (float)Math.pow(1.4, tier);
                return pips * bonus;
            }
            case decay: {
                return pips - 0.3f;
            }
            case vigil: {
                return pips + 1.0f;
            }
            case plague: {
                float doseBonus = 0.5f + (float)tier / 4.0f;
                return pips + doseBonus;
            }
            case duel: {
                return pips * 1.43f;
            }
            case underdog: {
                return pips * 1.35f;
            }
            case focus: {
                return e.isFriendly() ? pips * 1.5f : pips * 1.7f;
            }
            case ego: {
                switch (e.getType()) {
                    case Shield: {
                        return pips * 1.15f;
                    }
                }
                return Float.NaN;
            }
            case chain: {
                int numKeywords = e.getKeywords().size();
                float chance = Math.min(1.0f, (float)numKeywords / 7.0f);
                return pips * (1.0f + chance);
            }
            case patient: {
                return pips * 1.1f;
            }
            case pristine: {
                return pips * 1.7f;
            }
            case engage: {
                return pips * 1.5f;
            }
            case uppercut: {
                return pips * 1.25f;
            }
            case fierce: {
                return pips * 1.7f;
            }
            case serrated: {
                return pips * 1.25f;
            }
            case cruel: {
                if (e.needsTarget()) {
                    return pips * 1.25f;
                }
                return pips * 1.15f;
            }
            case deathwish: {
                return pips * 1.33f;
            }
            case step: {
                return 1.85f;
            }
            case inspired: {
                float TIER_VAL_MULT = 0.75f;
                float RATIO_PW = 2.0f;
                int thisVal = e.getValue();
                float avgTierValue = HeroTypeUtils.getEffectTierFor(tier) * 0.75f;
                float ratio = avgTierValue / (float)thisVal;
                float chance = (float)Math.min((double)0.8f, Math.pow(ratio, 2.0));
                return pips * (1.0f + chance);
            }
            case pair: {
                return pips * 1.5f;
            }
            case trio: {
                int originalValue = e.getValue();
                float tierStrength = HeroTypeUtils.getEffectTierFor(tier);
                if ((float)originalValue < tierStrength) {
                    return pips + pips * 2.0f * 0.25f;
                }
                return pips + pips * 2.0f * 0.1f;
            }
            case quin: {
                return pips * 1.01f;
            }
            case inflictPain: {
                if (e.isFriendly()) {
                    return pips;
                }
                if (player) {
                    return pips + HeroTypeUtils.getEffectTierFor(tier) * 1.0f;
                }
                return pips + 1.5f;
            }
            case evil: 
            case guilt: {
                float str4T = HeroTypeUtils.getEffectTierFor(tier);
                float ratio = pips / str4T;
                float reduction = 0.05f * ratio;
                return pips * (1.0f - reduction);
            }
            case boned: {
                return pips - 1.8f;
            }
            case hyperBoned: {
                return pips - (float)e.getValue() * 1.8f;
            }
            case echo: {
                return tstr * 1.3f + 1.0f;
            }
            case paxin: {
                return pips * 1.8f;
            }
            case fizz: {
                return pips + 1.1f;
            }
            case flurry: 
            case sprint: {
                return pips * 1.01f;
            }
            case hyperGrowth: {
                return pips * 3.0f;
            }
            case defy: {
                return pips + 2.0f;
            }
            case dejavu: {
                return pips * 1.1f;
            }
        }
        return pips;
    }

    public static float getValueMultiplier(Keyword k, Eff e, boolean player, int tier) {
        if (k.getInflict() != null) {
            return 1.0f;
        }
        switch (k) {
            case ranged: {
                if (e.hasKeyword(Keyword.poison) || e.hasKeyword(Keyword.cleave)) {
                    return 1.05f;
                }
                return 1.14f;
            }
            case poison: {
                return player ? 2.1f : 3.2f;
            }
            case copycat: {
                return KUtils.getValueMultiplier(Keyword.cleave, e, player, tier);
            }
            case spy: {
                return 2.0f;
            }
            case cleave: {
                if (!player) {
                    return 2.85f;
                }
                float bonus = 0.0f;
                if (e.getType() == EffType.Damage) {
                    bonus = 0.1f;
                }
                return 2.1f + bonus;
            }
            case descend: {
                return 1.0f + (KUtils.getValueMultiplier(Keyword.cleave, e, player, tier) - 1.0f) * 0.53f;
            }
            case cantrip: {
                if (KUtils.cantripTreatAsSingle(e, tier)) {
                    return 1.0f + e.getType().getCantripMultiplier() + 0.2f;
                }
                return 1.0f;
            }
            case heavy: {
                if (player) {
                    return 0.73f;
                }
                return 0.93f;
            }
            case vulnerable: {
                if (tier == 1) {
                    return 1.9f;
                }
                return 1.9f + (float)tier * 0.2f;
            }
            case singleUse: {
                if (e.hasKeyword(Keyword.poison)) {
                    return 0.88f;
                }
                return 0.75f;
            }
            case rampage: {
                if (e.getType() == EffType.Heal) {
                    return 1.0f;
                }
                return 1.78f;
            }
            case vitality: {
                if (e.getType() == EffType.Heal) {
                    return 1.0f;
                }
                return 1.1f;
            }
            case rescue: {
                float flatAdd = (float)(tier - 1) * 0.2f;
                switch (e.getType()) {
                    case Shield: {
                        return 1.95f + flatAdd;
                    }
                    case Heal: {
                        return 2.0f + flatAdd;
                    }
                }
                return 1.7f + flatAdd;
            }
            case weaken: {
                if (!player) {
                    return 2.35f;
                }
                return (float)tier * 0.3f + 2.5f;
            }
            case eliminate: {
                return 1.25f;
            }
            case exert: {
                return 0.65f;
            }
            case shifter: {
                return 1.25f;
            }
            case critical: 
            case bloodlust: 
            case steel: 
            case growth: 
            case era: 
            case lucky: 
            case charged: 
            case hoard: 
            case decay: 
            case vigil: 
            case plague: 
            case duel: 
            case underdog: 
            case focus: 
            case ego: 
            case chain: 
            case patient: 
            case pristine: 
            case engage: 
            case uppercut: 
            case fierce: 
            case serrated: 
            case cruel: 
            case deathwish: 
            case step: 
            case inspired: 
            case pair: 
            case trio: 
            case quin: 
            case evil: 
            case guilt: 
            case boned: 
            case hyperBoned: 
            case echo: 
            case paxin: 
            case fizz: 
            case flurry: 
            case sprint: 
            case hyperGrowth: 
            case defy: 
            case dejavu: 
            case repel: 
            case cleanse: 
            case pain: 
            case boost: 
            case permaBoost: 
            case smith: 
            case selfHeal: 
            case selfShield: 
            case manaGain: 
            case duplicate: 
            case death: 
            case sept: 
            case manacost: 
            case regen: 
            case sticky: 
            case mandatory: 
            case doubleUse: 
            case quadUse: 
            case petrify: 
            case hypnotise: 
            case wither: 
            case groooooowth: 
            case resilient: 
            case dispel: 
            case enduring: 
            case damage: 
            case shield: 
            case heal: 
            case selfCleanse: 
            case fluctuate: {
                return 1.0f;
            }
        }
        return Float.NaN;
    }

    public static boolean cantripTreatAsSingle(Eff e, int tier) {
        float baseValue = e.getType().getEffectTier(tier, e.getValue(), true, null);
        boolean treatAsSingle = baseValue * 1.2f > HeroTypeUtils.getEffectTierFor(tier);
        return treatAsSingle;
    }

    public static float getFinalEffectTierAdjustment(Keyword k, Eff e, float val, int tier, EntType type) {
        boolean hero = type instanceof HeroType;
        switch (k) {
            case damage: {
                return val + EffType.Damage.getEffectTier(tier, e.getValue(), true, e);
            }
            case shield: {
                return val + EffType.Shield.getEffectTier(tier, e.getValue(), true, e);
            }
            case heal: {
                return val + EffType.Heal.getEffectTier(tier, e.getValue(), true, e);
            }
            case manaGain: {
                float extra = EffType.Mana.getEffectTier(tier, e.getValue(), true, e);
                if (e.getType() == EffType.Resurrect) {
                    extra *= 0.25f;
                }
                return val + extra;
            }
            case selfHeal: {
                if (type instanceof MonsterType && type.hp > 12) {
                    return val + 0.6f * (float)e.getValue();
                }
                return val + 0.3f * (float)e.getValue();
            }
            case selfShield: {
                return val + 0.3f * (float)e.getValue();
            }
            case inflictPain: {
                if (e.isFriendly()) {
                    return val - HeroTypeUtils.getEffectTierFor(tier) * 0.2f;
                }
                return val;
            }
            case inflictDeath: {
                if (hero) {
                    return val + HeroTypeUtils.getEffectTierFor(((HeroType)type).getTier()) * 3.0f;
                }
                if (e.isFriendly()) {
                    return Float.NaN;
                }
                return val + 3.2f;
            }
            case inflictExert: {
                if (e.isFriendly()) {
                    return Float.NaN;
                }
                return type instanceof HeroType ? val + 0.9f * (e.hasKeyword(Keyword.cleave) ? 2.5f : 1.0f) : val + 1.9f * (e.hasKeyword(Keyword.cleave) ? 2.8f : 1.0f);
            }
            case inflictSingleUse: {
                if (e.isFriendly()) {
                    return Float.NaN;
                }
                return val + 0.3f;
            }
            case pain: {
                float painReduction = e.getValue();
                float max = hero ? (float)type.hp * 1.2f : (float)type.hp;
                painReduction = Math.min(painReduction, max);
                if (e.hasKeyword(Keyword.rampage)) {
                    painReduction *= 2.5f;
                }
                painReduction *= 0.6f;
                if (!hero) {
                    painReduction *= 0.43f;
                }
                return val - painReduction;
            }
            case death: {
                if (e.hasKeyword(Keyword.mandatory) && e.hasKeyword(Keyword.sticky)) {
                    return val - HeroTypeUtils.getHpFor(tier) * 1.0f;
                }
                return Math.max(val * 0.26f, val * 0.9f + KUtils.getFinalEffectTierAdjustment(Keyword.pain, new EffBill().damage(type.hp).bEff(), 0.0f, tier, type));
            }
            case selfCleanse: {
                return val + (KUtils.getFinalEffectTierAdjustment(Keyword.cleanse, e, val, tier, type) - val) * 0.24f;
            }
            case cleanse: {
                if (!e.isFriendly()) {
                    return Float.NaN;
                }
                float maxPips = 2.0f + (float)(tier - 1) * 1.25f;
                float valAtOne = 0.7f + (float)(tier - 1) * 0.15f;
                float maxVal = 1.1f + (float)(tier - 1) * 0.4f;
                return val + Tann.effectTierOnlySinTote(e.getValue(), maxPips, valAtOne, maxVal, 0.8f);
            }
            case boost: {
                if (!e.isFriendly()) {
                    return Float.NaN;
                }
                return val + ((float)tier * 0.1f + 1.7f) * (float)e.getValue();
            }
            case permaBoost: {
                if (!e.isFriendly()) {
                    return Float.NaN;
                }
                return val + (KUtils.getFinalEffectTierAdjustment(Keyword.boost, e, val, tier, type) - val) * 2.1f;
            }
            case smith: {
                if (!e.isFriendly()) {
                    return Float.NaN;
                }
                return val + (KUtils.getFinalEffectTierAdjustment(Keyword.boost, e, val, tier, type) - val) * 0.8f;
            }
            case weaken: {
                if (!e.hasKeyword(Keyword.poison)) break;
                val /= KUtils.getValueMultiplier(Keyword.poison, null, false, 0);
                float preVal = val /= KUtils.getValueMultiplier(Keyword.weaken, null, false, 0);
                val += preVal * KUtils.getValueMultiplier(Keyword.poison, null, false, 0) - preVal;
                val += preVal * KUtils.getValueMultiplier(Keyword.weaken, null, false, 0) - preVal;
                break;
            }
            case repel: {
                return val + (float)e.getValue() * 1.5f;
            }
            case duplicate: {
                float extraMult;
                float base = HeroTypeUtils.getEffectTierFor(tier) * 0.9f;
                float extra = (float)Math.pow(val / base, 3.0);
                switch (e.getType()) {
                    case Shield: 
                    case Heal: {
                        extraMult = 0.2f;
                        break;
                    }
                    case Mana: {
                        extraMult = 1.1f;
                        break;
                    }
                    case Damage: {
                        extraMult = 1.0f;
                        break;
                    }
                    default: {
                        extraMult = 500.0f;
                    }
                }
                return val * 1.3f + extra * extraMult;
            }
            case manacost: {
                return val - EffType.Mana.getEffectTier(tier, e.getValue(), true, e);
            }
            case regen: {
                if (!e.isFriendly()) {
                    return Float.NaN;
                }
                return val + (float)e.getValue() * 1.3f;
            }
            case doubleUse: {
                return val * 2.05f;
            }
            case quadUse: {
                return val * 4.2f;
            }
            case hypnotise: {
                return val + 2.0f;
            }
            case petrify: {
                return val + Tann.effectTierOnlySinTote(e.getValue(), 6.0f, 1.3f, 14.0f, 1.0f);
            }
            case groooooowth: {
                return val + 1.2f;
            }
            case resilient: {
                return val;
            }
            case dispel: {
                if (!hero || e.isFriendly()) {
                    return Float.NaN;
                }
                return val + (float)tier * 0.8f;
            }
            case fluctuate: {
                return (float)e.getValue() * 1.6f;
            }
        }
        return val;
    }

    public static boolean allowAddingKeyword(Keyword k, Eff e) {
        EffType et = e.getType();
        if (et == EffType.Event) {
            return false;
        }
        if (e.getKeywords().contains((Object)k)) {
            return false;
        }
        if (e.hasKeyword(Keyword.permissive)) {
            return true;
        }
        if (k.getAllowType() == null) {
            TannLog.error("Unimplemented: " + (Object)((Object)k) + "/" + (Object)((Object)k.getAllowType()));
            return false;
        }
        return k.getAllowType().check(e);
    }

    public static int getValue(Eff e) {
        return KUtils.getValue(e, e.getValue());
    }

    public static int getValue(Eff e, int value) {
        int v = value;
        block9: for (int i = 0; i < e.getKeywords().size(); ++i) {
            Keyword k = e.getKeywords().get(i);
            switch (k) {
                case fault: {
                    v = -1;
                    continue block9;
                }
                case zeroed: {
                    v = 0;
                    continue block9;
                }
                case onesie: {
                    v = 1;
                    continue block9;
                }
                case threesy: {
                    v = 3;
                    continue block9;
                }
                case plus: {
                    ++v;
                    continue block9;
                }
                case doubled: {
                    v *= 2;
                    continue block9;
                }
                case squared: {
                    v *= v;
                }
            }
        }
        return v;
    }

    public static String describePipBonus(String bonusDescription) {
        if (bonusDescription.startsWith("equal to")) {
            return "bonus pips " + bonusDescription;
        }
        return KUtils.describeBeingIncreased() + " for each " + bonusDescription;
    }

    public static List<Keyword> getColourKeywords(Color col) {
        ArrayList<Keyword> result = new ArrayList<Keyword>();
        Keyword[] vals = Keyword.values();
        for (int i = 0; i < vals.length; ++i) {
            Keyword k = vals[i];
            if (k.getColour() != col) continue;
            result.add(k);
        }
        return result;
    }

    public static boolean allowAutoskip(Keyword k) {
        switch (k) {
            case boned: 
            case hyperBoned: 
            case exert: 
            case pain: 
            case death: 
            case manacost: 
            case potion: {
                return true;
            }
        }
        return false;
    }

    public static float getModTierAll(Keyword k, boolean hero) {
        return hero ? KUtils.getModTierAllHero(k) : KUtils.getModTierAllMonster(k);
    }

    public static float getModTierAllMonster(Keyword k) {
        switch (k) {
            case era: {
                return -13.0f;
            }
            case vigil: {
                return -11.0f;
            }
            case inflictBoned: {
                return -10.0f;
            }
            case inflictDeath: {
                return -10.0f;
            }
            case selfHeal: {
                return -8.0f;
            }
            case pristine: {
                return -4.0f;
            }
            case growth: {
                return -2.0f;
            }
            case decay: {
                return 2.0f;
            }
            case singleUse: {
                return 9.0f;
            }
            case exert: {
                return 15.0f;
            }
            case poison: {
                return ModTierUtils.monsterPlus(2);
            }
        }
        return 0.0f;
    }

    public static float getModTierAllHero(Keyword k) {
        switch (k) {
            case fluctuate: {
                return 20.0f;
            }
            case fumble: {
                return -12.0f;
            }
            case critical: {
                return ModTierUtils.heroBonusAllSides(0.5f) * 5.0f;
            }
            case unusable: {
                return -20.0f;
            }
            case halveEngage: {
                return -6.0f;
            }
            case halveDuel: {
                return -2.0f;
            }
            case hyperBoned: {
                return -30.0f;
            }
            case boned: {
                return -14.0f;
            }
            case groupExert: {
                return -13.0f;
            }
            case exert: {
                return -12.0f;
            }
            case singleUse: {
                return -9.0f;
            }
            case heavy: {
                return -8.0f;
            }
            case inflictBoned: {
                return -6.0f;
            }
            case decay: {
                return -4.0f;
            }
            case guilt: {
                return -4.0f;
            }
            case mandatory: {
                return -1.0f;
            }
            case generous: {
                return -1.0f;
            }
            case rite: {
                return 1.0f;
            }
            case ranged: {
                return 3.0f;
            }
            case sixth: {
                return 3.0f;
            }
            case enduring: {
                return 4.0f;
            }
            case dispel: {
                return 4.0f;
            }
            case undergrowth: {
                return 5.0f;
            }
            case fierce: {
                return 7.0f;
            }
            case selfHeal: {
                return 7.0f;
            }
            case growth: {
                return 8.0f;
            }
            case rescue: {
                return 9.0f;
            }
            case vigil: {
                return 10.0f;
            }
            case duplicate: {
                return 10.0f;
            }
            case selfShield: {
                return 10.0f;
            }
            case steel: {
                return 12.0f;
            }
            case repel: {
                return 14.0f;
            }
            case copycat: {
                return 17.0f;
            }
            case bloodlust: {
                return 20.0f;
            }
            case groupGrowth: {
                return 22.0f;
            }
            case echo: {
                return 22.0f;
            }
            case groooooowth: {
                return 26.0f;
            }
            case cantrip: {
                return 30.0f;
            }
            case manaGain: {
                return 30.0f;
            }
            case charged: {
                return 35.0f;
            }
            case era: {
                return ModTierUtils.heroBonusAllSides(5.5f);
            }
            case flesh: {
                return ModTierUtils.heroBonusAllSides(20.0f);
            }
            case pain: {
                return ModTierUtils.painKeyword(5.0f);
            }
            case death: {
                return ModTierUtils.deathKeyword(5.0f);
            }
            case reborn: {
                return KUtils.das(0.02f);
            }
            case terminal: {
                return KUtils.das(0.07f);
            }
            case duel: {
                return KUtils.das(0.15f);
            }
            case focus: {
                return KUtils.das(0.15f);
            }
            case cruel: {
                return KUtils.das(0.21f);
            }
            case pair: 
            case trio: {
                return KUtils.das(0.26f);
            }
            case deathwish: {
                return KUtils.das(0.38f);
            }
            case engage: {
                return KUtils.das(0.42f);
            }
            case pristine: {
                return KUtils.das(0.6f);
            }
            case ego: {
                return KUtils.das(0.06f);
            }
            case patient: {
                return KUtils.das(0.06f);
            }
            case overdog: {
                return KUtils.das(0.32f);
            }
            case underdog: {
                return KUtils.das(0.32f);
            }
            case inspired: {
                return KUtils.das(0.6f);
            }
        }
        return 0.0f;
    }

    public static Rarity getRarity(Keyword k) {
        if (k.name().startsWith("group")) {
            return Rarity.HUNDREDTH;
        }
        switch (k) {
            case exert: 
            case generous: {
                return Rarity.THIRD;
            }
            case ego: 
            case patient: 
            case inspired: {
                return Rarity.FIFTH;
            }
            case underdog: 
            case evil: 
            case guilt: 
            case mandatory: 
            case overdog: {
                return Rarity.TENTH;
            }
            case inflictDeath: 
            case inflictBoned: 
            case unusable: {
                return Rarity.HUNDREDTH;
            }
        }
        return null;
    }

    private static float das(float m) {
        return ModTierUtils.doubleSidesAllHeroes(m);
    }

    public static String describeBeingIncreased() {
        return "+1 pip";
    }

    public static String describeBeingDecreased() {
        return "-1 pip";
    }

    public static String describeOthersSeeingNPips(String newAs) {
        return "Other keywords see coloured " + KUtils.describeN() + " as " + newAs;
    }

    public static String describedRemainingWhenReplaced(String keywords) {
        return keywords + " remain when the side is replaced (if possible)";
    }

    public static StandardButton makeKeywordButton(Keyword k) {
        return new StandardButton(k.getColourTaggedString());
    }

    public static String makeName(String name, Keyword condition, Keyword bonus) {
        int split = (int)Math.ceil((float)name.length() / 2.0f);
        String a = name.substring(0, split);
        String b = name.substring(split);
        return TextWriter.getTag(condition.getColour()) + a + "[cu][p]" + TextWriter.getTag(bonus.getColour()) + b + "[cu]";
    }

    public static TextureRegion makePlaceholderCorner(Keyword keyword) {
        TextureRegion tr;
        String name;
        Color col = keyword.getColour();
        if (col != null && (name = TextWriter.getNameForColour(col)) != null && (tr = ImageUtils.loadExt3d("keyword/special/" + name)) != null) {
            return tr;
        }
        return ImageUtils.loadExt3d("keyword/special/placeholder");
    }

    public static String describeCombination(Keyword a, Keyword b, KeywordCombineType kct) {
        if (kct == KeywordCombineType.TC4X) {
            return "x4 if the conditions of both " + a.getColourTaggedString() + " and " + b.getColourTaggedString() + " are met";
        }
        if (kct == KeywordCombineType.ConditionBonus) {
            return "If " + a.getColourTaggedString() + "[p]'s condition is met, gain the effects of " + b.getColourTaggedString();
        }
        if (kct == KeywordCombineType.XOR) {
            return "x3 if the conditions of " + a.getColourTaggedString() + " xor " + b.getColourTaggedString() + " is met";
        }
        return "unk: " + (Object)((Object)kct);
    }

    public static ConditionalBonus getConditionalBonus(Keyword a, Keyword b, KeywordCombineType kct) {
        if (kct == KeywordCombineType.TC4X) {
            return new ConditionalBonus(new CombinedRequirement(a.getConditionalBonus().requirement, b.getConditionalBonus().requirement), ConditionalBonusType.Multiply, 4);
        }
        if (kct == KeywordCombineType.ConditionBonus) {
            return new ConditionalBonus(a.getConditionalBonus().requirement, b.getConditionalBonus().bonusType, b.getConditionalBonus().bonusAmount);
        }
        if (kct == KeywordCombineType.XOR) {
            return new ConditionalBonus(new XORRequirement(a.getConditionalBonus().requirement, b.getConditionalBonus().requirement), ConditionalBonusType.Multiply, 3);
        }
        throw new RuntimeException("ep: " + (Object)((Object)kct));
    }

    public static KeywordAllowType getSwapRequirement(Keyword toSwap) {
        KeywordAllowType kat = toSwap.getAllowType();
        if (kat == KeywordAllowType.TARG_PIPS) {
            return KeywordAllowType.PIPS_ONLY;
        }
        if (kat == KeywordAllowType.PIPS_ONLY) {
            return KeywordAllowType.TARG_PIPS;
        }
        return kat;
    }

    public static String swapRules(Keyword toSwap) {
        return toSwap.getRules().replaceAll("I am", "target is").replaceAll("vs targets on", "if I have").replaceAll("vs targets with", "if I have");
    }

    public static ConditionalBonus getSwapBonus(Keyword toSwap) {
        String er = "Failed to swap " + (Object)((Object)toSwap);
        ConditionalBonus cb = toSwap.getConditionalBonus();
        if (cb == null) {
            return KUtils.errorNull(er);
        }
        ConditionalRequirement req = cb.requirement;
        if (req == null) {
            return KUtils.errorNull(er);
        }
        if (req instanceof ParamCondition) {
            ParamCondition pc = (ParamCondition)req;
            return new ConditionalBonus(pc.getSwapped(), cb.bonusType, cb.bonusAmount);
        }
        if (req instanceof GSCConditionalRequirement) {
            GSCConditionalRequirement gcgsccr = (GSCConditionalRequirement)req;
            return new ConditionalBonus(gcgsccr.getSwapped(), cb.bonusType, cb.bonusAmount);
        }
        return KUtils.errorNull(er);
    }

    private static ConditionalBonus errorNull(String msg) {
        throw new RuntimeException(msg);
    }

    public static KeywordAllowType getKATFromTargetingRequirement(ConditionalRequirement targetingRequirement) {
        if (targetingRequirement == TargetingRestriction.ExactlyValue || targetingRequirement == TargetingRestriction.ExactlyValuePicky) {
            return KeywordAllowType.TARG_PIPS;
        }
        return targetingRequirement == TargetingRestriction.NotMe ? KeywordAllowType.ALLY_TARG : KeywordAllowType.SINGLE_TARGET;
    }

    public static List<Color> getKeywordColours() {
        return Arrays.asList(Colours.red, Colours.blue, Colours.green, Colours.light, Colours.pink, Colours.yellow, Colours.orange, Colours.grey, Colours.purple);
    }

    public static boolean hasEquivalentKeyword(EffType t, Eff eff) {
        return Tann.anySharedItems(KUtils.getKeywordsFor(t), eff.getKeywords());
    }

    public static void init() {
        ke = new ArrayList<Keyword>();
        kh = Arrays.asList(Keyword.heal, Keyword.selfHeal);
        ks = Arrays.asList(Keyword.shield, Keyword.selfShield);
        kd = Arrays.asList(Keyword.damage);
        km = Arrays.asList(Keyword.manaGain);
    }

    public static List<Keyword> getKeywordsFor(EffType t) {
        switch (t) {
            case Heal: {
                return kh;
            }
            case Shield: {
                return ks;
            }
            case Damage: {
                return kd;
            }
            case Mana: {
                return km;
            }
        }
        return ke;
    }

    public static Keyword getKeywordsForSimple(EffType t) {
        switch (t) {
            case Heal: {
                return Keyword.selfHeal;
            }
            case Shield: {
                return Keyword.selfShield;
            }
            case Mana: {
                return Keyword.manaGain;
            }
        }
        return null;
    }

    public static String descStraight(int i) {
        return "this forms a straight of length " + i + "+ with the " + KUtils.describeStraightDice();
    }

    public static boolean isMeta(Keyword k) {
        return META.contains((Object)k);
    }

    public static boolean hasMetaKeyword(Eff e) {
        return Tann.anySharedItems(e.getKeywords(), META);
    }

    static {
        META = Arrays.asList(Keyword.copycat, Keyword.echo, Keyword.resonate, Keyword.fluctuate, Keyword.fumble, Keyword.shifter, Keyword.spy, Keyword.dejavu);
    }
}

