/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.targetable.ability.generation;

import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.ability.generation.SpellGeneration;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellUtils;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.Tactic;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.TacticCost;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.TacticCostType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class TacticGeneration {
    public static final String GENTAC_PREF = "t";

    public static Eff getEffectWithStrengthForTactic(Random r, int tier, float strength) {
        float closeness = 0.15f;
        int attempts = 50;
        Keyword[] vals = Keyword.values();
        HeroType ex = HeroTypeUtils.defaultHero(tier);
        for (int i = 0; i < 50; ++i) {
            Eff e = EffUtils.random(r);
            if (!SpellGeneration.okForAbilityMaybe(e)) continue;
            int NUM_KATT = 5;
            for (int kAtt = 0; kAtt < 5; ++kAtt) {
                Keyword k = vals[r.nextInt(vals.length)];
                if (!SpellUtils.allowAddingKeyword(k) || k.reallySpellOnly()) continue;
                Eff with = e.copy();
                with.addKeyword(k);
                float withStr = EntSide.getValueFromEffect(with, tier, ex, true);
                boolean bad = Float.isNaN(withStr);
                if (bad |= EntSide.getValueFromEffect(e, tier, ex, true) == withStr) continue;
                e = with;
                if (r.nextFloat() > 0.1f) break;
            }
            boolean valid = false;
            for (int j = 0; j < 2; ++j) {
                float pw = EntSide.getValueFromEffect(e, tier, ex, true);
                boolean bl = valid = Math.abs(1.0f - pw / strength) < closeness;
                if (valid || !e.hasValue()) break;
                float ratio = strength / pw;
                e.setValue(Math.max(1, Math.round((float)e.getValue() * ratio * (r.nextFloat() + 0.5f))));
            }
            if (!valid) continue;
            return e;
        }
        return null;
    }

    public static Tactic makeTacticSafeMaybeNull(String heroName, int tier, Random r, EntSide[] sides) {
        int attempts = 50;
        for (int i = 0; i < 50; ++i) {
            try {
                Tactic t = TacticGeneration.makeTacticForGreenGenerate(heroName, tier, r, sides);
                if (t == null) continue;
                return t;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Tactic makeTacticForGreenGenerate(String heroName, int tier, Random r, EntSide[] sides) {
        TacticCost tc = TacticGeneration.getRandomCost(r, sides, tier);
        if (tc == null) {
            return null;
        }
        float pw = TacticGeneration.getPowerOfCostInOnePipSides(tc, tier) * HeroTypeUtils.getEffectTierFor(tier) * 0.8f;
        if (pw < 0.0f) {
            return null;
        }
        Eff e = TacticGeneration.getEffectWithStrengthForTactic(r, tier, pw);
        if (e == null) {
            return null;
        }
        return new Tactic(GENTAC_PREF + heroName, tc, e);
    }

    public static float getPowerOfCostInOnePipSides(TacticCost cost, int tier) {
        float total = 0.0f;
        Map<TacticCostType, Integer> costAmts = cost.getCostAmtsUnwise();
        for (TacticCostType costType : costAmts.keySet()) {
            total += TacticGeneration.getPowerOfMiniCost(costType, costAmts.get((Object)costType), tier);
        }
        return total;
    }

    private static float getPowerOfMiniCost(TacticCostType costType, int amt, int tier) {
        switch (costType) {
            case basicSword: {
                return TacticGeneration.multi(amt, 1.0f, tier);
            }
            case basicShield: {
                return TacticGeneration.multi(amt, 0.7f, tier);
            }
            case basicHeal: {
                return TacticGeneration.multi(amt, 0.7f, tier);
            }
            case basicMana: {
                return TacticGeneration.multi(amt, 1.3f, tier);
            }
            case wild: {
                return TacticGeneration.multi(amt, 0.5f, tier);
            }
            case blank: {
                return 0.8f * (float)amt;
            }
            case pips1: {
                return 1.0f * (float)amt;
            }
            case pips2: {
                return 1.15f * (float)amt;
            }
            case pips3: {
                return 1.3f * (float)amt;
            }
            case pips4: {
                return 1.5f * (float)amt;
            }
            case keyword: {
                return 1.1f * (float)amt;
            }
            case twoKeywords: {
                return 1.35f * (float)amt;
            }
            case fourKeywords: {
                return 2.7f * (float)amt;
            }
        }
        return Float.NaN;
    }

    private static float multi(int amt, float factor, int tier) {
        float extraFactor = 2.7f / HeroTypeUtils.getEffectTierFor(tier);
        return 0.6f + (float)amt * factor * 0.2f * extraFactor;
    }

    private static TacticCost getRandomCost(Random r, EntSide[] sides, int tier) {
        ArrayList<TacticCostType> chosen = new ArrayList<TacticCostType>();
        float tpw = 0.0f;
        float eft = HeroTypeUtils.getEffectTierFor(tier);
        int typesAdded = 0;
        boolean hasPippy = false;
        boolean hasSpecificPipsOrKeyword = false;
        boolean hasWild = false;
        for (EntSide side : sides) {
            boolean nk;
            TacticCostType test;
            Eff be;
            List<TacticCostType> valids;
            if (side == ESB.blank && r.nextFloat() > 0.1f || (valids = TacticCostType.getValidTypes(be = side.getBaseEffect())).isEmpty() || chosen.contains((Object)(test = valids.get(r.nextInt(valids.size()))))) continue;
            int amt = test.pippy ? Math.round(r.nextInt((int)(eft * r.nextFloat() * 2.0f) + 1)) : 1;
            float pw = TacticGeneration.getPowerOfMiniCost(test, amt = Math.max(1, amt), tier);
            if (tpw + pw > HeroTypeUtils.getEffectTierFor(tier) * 2.5f) continue;
            boolean bl = nk = test.name().contains("ips") || test.name().contains("eyword");
            if (hasPippy && nk || test.pippy && hasSpecificPipsOrKeyword || hasWild && test.pippy || hasPippy && test == TacticCostType.wild) continue;
            hasWild |= test == TacticCostType.wild;
            hasPippy |= test.pippy;
            hasSpecificPipsOrKeyword |= nk;
            tpw += pw;
            for (int i = 0; i < amt; ++i) {
                chosen.add(test);
            }
            if (r.nextFloat() * (float)(++typesAdded) > 0.6f) break;
        }
        if (chosen.size() == 0) {
            return null;
        }
        return new TacticCost(chosen);
    }
}

