/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.leaderboard;

import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.leaderboard.CursedLeaderboard;
import com.tann.dice.gameplay.leaderboard.Leaderboard;
import com.tann.dice.gameplay.leaderboard.SpeedrunLeaderboard;
import com.tann.dice.gameplay.leaderboard.StreakLeaderboard;
import com.tann.dice.gameplay.mode.Mode;
import java.util.ArrayList;
import java.util.List;

public class LeaderboardBlob {
    public static List<Leaderboard> all = new ArrayList<Leaderboard>();

    public static void setupLeaderboards() {
        all.clear();
        for (Mode m : new Mode[]{Mode.DEMO, Mode.CLASSIC, Mode.SHORTCUT, Mode.GENERATE_HEROES, Mode.LOOT, Mode.RAID, Mode.CHOOSE_PARTY, Mode.DREAM}) {
            for (Difficulty d : new Difficulty[]{Difficulty.Hard, Difficulty.Unfair, Difficulty.Brutal, Difficulty.Hell}) {
                all.add(new StreakLeaderboard(m, d, m.getName().toLowerCase() + "_" + d.name().toLowerCase() + "_streak"));
            }
            all.add(new SpeedrunLeaderboard(m));
        }
        for (Mode m : new Mode[]{Mode.CURSE, Mode.BLURSED, Mode.CURSE_HYPER, Mode.CURSED_ULTRA, Mode.BLURTRA}) {
            all.add(new CursedLeaderboard(m));
        }
    }

    public static Leaderboard byName(String name) {
        if (all.size() == 0) {
            throw new RuntimeException("leaderboards not setup yet");
        }
        for (Leaderboard l : all) {
            if (!l.getName().equalsIgnoreCase(name)) continue;
            return l;
        }
        throw new RuntimeException("Could not find leaderboard with name :" + name);
    }
}

