/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier;

import com.badlogic.gdx.graphics.Color;
import com.tann.dice.util.Colours;

public enum ModifierType {
    Blessing(Colours.green),
    Curse(Colours.purple),
    Tweak(Colours.yellow),
    Unrated(Colours.orange);

    final Color c;

    private ModifierType(Color c) {
        this.c = c;
    }

    public static ModifierType fromTier(int tier) {
        if (tier == 0) {
            return Tweak;
        }
        return tier > 0 ? Blessing : Curse;
    }

    public static ModifierType fromTier(Integer min, Integer max) {
        if (min == null) {
            return Curse;
        }
        if (max == null) {
            return Blessing;
        }
        if (Math.signum(min.intValue()) != Math.signum(max.intValue())) {
            return null;
        }
        if (min == 0 && max == 0) {
            return Tweak;
        }
        return min > 0 ? Blessing : Curse;
    }
}

