/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable;

import com.badlogic.gdx.graphics.Color;
import com.tann.dice.util.Colours;
import com.tann.dice.util.TannLog;

public enum ChoosableType {
    Levelup(0.0f, 10.0f),
    Item(-8.0f, 20.0f),
    Hero(0.0f, 9.0f),
    Modifier,
    Random(true),
    RandomRange(true),
    Or(true),
    And(true),
    MISSINGNO,
    Skip,
    Enu,
    Replace,
    Value;

    final float lower;
    final float upper;
    boolean meta;

    private ChoosableType() {
        this.lower = -50.0f;
        this.upper = 50.0f;
    }

    private ChoosableType(boolean meta) {
        this();
        this.meta = meta;
    }

    private ChoosableType(float lower, float upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public float getUpper() {
        return this.upper;
    }

    public float getLower() {
        return this.lower;
    }

    public boolean isMeta() {
        return this.meta;
    }

    public String niceName(int t) {
        switch (this) {
            default: {
                return this.name().toLowerCase();
            }
            case Modifier: {
                if (t < 0) {
                    return "curse";
                }
                if (t > 0) {
                    return "blessing";
                }
                return "tweak";
            }
            case Item: 
        }
        if (t < 0) {
            return "cursed item";
        }
        if (t > 0) {
            return "item";
        }
        return "junk item";
    }

    public Color getColour() {
        return this.getColour(0);
    }

    public Color getColour(int tier) {
        switch (this) {
            case Levelup: {
                return Colours.yellow;
            }
            case Item: {
                return Colours.grey;
            }
            case Hero: {
                return Colours.yellow;
            }
            case Modifier: {
                return tier == 0 ? Colours.yellow : (tier > 0 ? Colours.green : Colours.purple);
            }
        }
        return Colours.grey;
    }

    public char getTag() {
        switch (this) {
            case Levelup: {
                return 'l';
            }
            case Item: {
                return 'i';
            }
            case Hero: {
                return 'g';
            }
            case Modifier: {
                return 'm';
            }
            case Random: {
                return 'r';
            }
            case Or: {
                return 'o';
            }
            case And: {
                return 'a';
            }
            case MISSINGNO: {
                return '?';
            }
            case RandomRange: {
                return 'q';
            }
            case Skip: {
                return 's';
            }
            case Enu: {
                return 'e';
            }
            case Value: {
                return 'v';
            }
            case Replace: {
                return 'p';
            }
        }
        throw new RuntimeException("ach: " + (Object)((Object)this));
    }

    public static ChoosableType fromTag(char tag) {
        for (ChoosableType value : ChoosableType.values()) {
            if (value.getTag() != tag) continue;
            return value;
        }
        TannLog.error("error with tag: " + tag);
        return MISSINGNO;
    }
}

