/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.progress.stats.stat.endOfRun;

import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.StatMergeType;
import com.tann.dice.gameplay.progress.stats.stat.endOfRun.GameEndStat;
import java.util.ArrayList;
import java.util.Collection;

public class SpeedrunStat
extends GameEndStat {
    public SpeedrunStat(ContextConfig cc) {
        super(SpeedrunStat.getName(cc));
    }

    @Override
    protected StatMergeType getMergeType() {
        return StatMergeType.Lowest;
    }

    @Override
    public void endOfRun(DungeonContext context, boolean victory) {
        if (!this.validForSpeedrun(context)) {
            return;
        }
        if (victory && this.getName().equals(SpeedrunStat.getName(context.getContextConfig()))) {
            this.setValue((int)context.getFinalTimeSeconds());
        }
    }

    private boolean validForSpeedrun(DungeonContext context) {
        return true;
    }

    public static Collection<? extends Stat> makeAll() {
        ArrayList<SpeedrunStat> stats = new ArrayList<SpeedrunStat>();
        for (ContextConfig cc : Mode.getAllSaveBearingConfigs()) {
            if (cc.skipStats()) continue;
            stats.add(new SpeedrunStat(cc));
        }
        return stats;
    }

    public static String getName(ContextConfig cc) {
        return cc.getSpecificKey() + "-fastest-time-bs";
    }

    @Override
    public boolean validFor(ContextConfig contextConfig) {
        return this.getName().equalsIgnoreCase(SpeedrunStat.getName(contextConfig));
    }

    @Override
    public boolean isBoring() {
        return true;
    }
}

