/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.save.settings.option;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.save.settings.option.Option;
import com.tann.dice.gameplay.trigger.global.linked.DipPanel;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.Checkbox;
import com.tann.dice.util.ui.RadioCheckbox;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;

public class ChOption
extends Option {
    final String[] options;
    int selectedIndex;

    protected ChOption(String name, String desc, String ... options) {
        super(name, desc);
        this.options = options;
        this.selectedIndex = 0;
    }

    public void setValue(int index, boolean manual) {
        this.selectedIndex = index;
        if (manual) {
            Main.getSettings().saveOptions();
            this.manualSelectAction();
        }
    }

    public void setValue(String val, boolean manual) {
        int index = Tann.indexOf(this.options, val);
        if (index == -1) {
            TannLog.error(val);
            return;
        }
        this.setValue(index, manual);
    }

    public int c() {
        if (!this.isValid()) {
            return 0;
        }
        return this.selectedIndex;
    }

    public String cString() {
        return this.options[this.c()];
    }

    @Override
    public Actor makeCogActor() {
        int maxWidth = 100;
        Pixl p = new Pixl(2, 2);
        final ArrayList<RadioCheckbox> boxes = new ArrayList<RadioCheckbox>();
        Pixl boxesPix = new Pixl(0);
        int i = 0;
        while (i < this.options.length) {
            String op = this.options[i];
            final RadioCheckbox cb = new RadioCheckbox(this.selectedIndex == i);
            Actor a = cb.makeLabelledCheckbox(op, null);
            boxes.add(cb);
            if (!boxesPix.canHandle(a, 100)) {
                boxesPix.row(2);
            }
            boxesPix.actor(a);
            if (i < this.options.length - 1) {
                boxesPix.gap(3);
            }
            final int finalI = i++;
            cb.addToggleRunnable(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < boxes.size(); ++j) {
                        Checkbox other;
                        other.force((other = (Checkbox)boxes.get(j)) == cb);
                    }
                    Sounds.playSound(Sounds.pip);
                    ChOption.this.setValue(finalI, true);
                }
            });
        }
        p.actor(boxesPix.pix(8));
        Group a = p.pix();
        a = DipPanel.makeTopPanelGroup(new TextWriter(this.name), a, Colours.grey, 2);
        a.addListener(new TannListener(){

            @Override
            public boolean info(int button, float x, float y) {
                return ChOption.this.showExtraInfo();
            }
        });
        return a;
    }

    @Override
    public void reset() {
        this.selectedIndex = 0;
    }
}

