/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen;

import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHero;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.MessagePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.SimpleChoicePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.LevelupHeroChoosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.RandomTieredChoosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.SkipChoosable;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.heroLevelupAffect.HeroGenType;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGenerator;
import com.tann.dice.util.Tann;
import com.tann.dice.util.tp.TP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PhaseGeneratorLevelup
extends PhaseGenerator {
    public static final int MAX_LEVEL = 999;
    static final int BASE_CHOICES = 2;

    @Override
    public List<Phase> generate(DungeonContext dc) {
        int choices = dc.getLevelupOptions(2);
        List<TP<Hero, HeroType>> types = PhaseGeneratorLevelup.getLevelupOptions(dc, choices);
        if (types == null) {
            return Arrays.asList(new MessagePhase("[purple]Error finding a hero to levelup..."));
        }
        ArrayList<Choosable> options = new ArrayList<Choosable>();
        for (int i = 0; i < types.size(); ++i) {
            options.add(new LevelupHeroChoosable((HeroType)types.get((int)i).b));
        }
        if (Main.getSettings().hasAttemptedLevel() || options.isEmpty()) {
            options.add(new RandomTieredChoosable(PhaseGeneratorLevelup.getPartyLevelupToTier(dc.getParty().getHeroes()), 1, ChoosableType.Levelup));
            options.add(new SkipChoosable());
        }
        return Arrays.asList(new SimpleChoicePhase(options));
    }

    public static LevelupHeroChoosable getRandom(DungeonContext dc) {
        return new LevelupHeroChoosable((HeroType)PhaseGeneratorLevelup.getLevelupOptions((DungeonContext)dc, (int)1).get((int)0).b);
    }

    private static int getPartyLevelupToTier(List<Hero> heroes) {
        int minLevel = 999;
        for (Hero h : heroes) {
            if (!h.canLevelUp()) continue;
            minLevel = Math.min(minLevel, h.getLevel());
        }
        return minLevel + 1;
    }

    public static List<TP<Hero, HeroType>> getLevelupOptions(DungeonContext dungeonContext, int amt) {
        boolean allowDuplicates = false;
        List<Global> globals = dungeonContext.getModifierGlobals();
        for (Global gt : globals) {
            allowDuplicates |= gt.allowDuplicateHeroLevelups();
        }
        ArrayList<Hero> toLevelUp = new ArrayList<Hero>();
        Party party = dungeonContext.getParty();
        ArrayList<Hero> heroes = new ArrayList<Hero>(party.getHeroes());
        for (int i = heroes.size() - 1; i >= 0; --i) {
            if (((Hero)heroes.get(i)).canLevelUp()) continue;
            heroes.remove(i);
        }
        ArrayList<Hero> potentials = new ArrayList<Hero>();
        int minLevel = PhaseGeneratorLevelup.getPartyLevelupToTier(heroes) - 1;
        for (Hero h : heroes) {
            if (h.getLevel() != minLevel) continue;
            potentials.add(h);
        }
        Collections.shuffle(potentials);
        if (potentials.size() == 0) {
            return null;
        }
        if (potentials.size() < amt) {
            for (int i = 0; i < amt; ++i) {
                toLevelUp.add((Hero)Tann.random(potentials));
            }
        } else {
            toLevelUp.addAll(potentials.subList(0, amt));
        }
        final Party p = dungeonContext.getParty();
        Collections.sort(toLevelUp, new Comparator<Hero>(){

            @Override
            public int compare(Hero o1, Hero o2) {
                return p.colIndex(o1.getHeroType().heroCol) - p.colIndex(o2.getHeroType().heroCol);
            }
        });
        ArrayList<HeroType> currentHeroTypes = new ArrayList<HeroType>();
        for (Hero h : heroes) {
            currentHeroTypes.add(h.getHeroType());
        }
        ArrayList<HeroType> tmpSeen = new ArrayList<HeroType>(dungeonContext.makeSeenHeroTypes());
        ArrayList<TP<Hero, HeroType>> result = new ArrayList<TP<Hero, HeroType>>();
        ArrayList<HeroType> currentPlusOffered = new ArrayList<HeroType>(currentHeroTypes);
        if (allowDuplicates) {
            currentPlusOffered.clear();
            tmpSeen.clear();
        }
        HeroGenType hgt = PipeHero.getGenType(globals);
        for (Hero h : toLevelUp) {
            HeroType option = HeroTypeUtils.getOption(h, hgt, dungeonContext, currentPlusOffered, tmpSeen);
            if (option.isMissingno() && !Tann.contains(HeroCol.basics(), option.heroCol) && h.getLevel() >= 0 && h.getLevel() < 9) {
                option = HeroTypeLib.byName(h.getName(false) + ".hp." + (h.entType.hp + 4) + ".tier." + (h.getHeroType().getTier() + 1) + ".n." + PhaseGeneratorLevelup.cleanName(h.getName(true, false)) + "");
            }
            currentPlusOffered.add(option);
            TP<Hero, HeroType> tt = new TP<Hero, HeroType>(h, option);
            result.add(tt);
        }
        return result;
    }

    private static String cleanName(String name) {
        return name.replace(".", "");
    }

    @Override
    public long getCollisionBits(Boolean player) {
        return Collision.LEVELUP_REWARD;
    }
}

