/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon;

import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.die.Die;
import com.tann.dice.gameplay.content.ent.die.EntDie;
import com.tann.dice.gameplay.effect.targetable.ability.ui.AbilityHolder;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.statics.bullet.BulletStuff;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RollManager {
    FightLog fightLog;
    public static Boolean predictionSavePlayer;

    public RollManager(FightLog fightLog) {
        this.fightLog = fightLog;
    }

    public boolean allDiceStopped() {
        return this.allDiceNotState(Die.DieState.Rolling) && this.allDiceNotState(Die.DieState.Unlocking);
    }

    public boolean allDiceStoppedEnoughToSave() {
        return this.allDiceNotState(Die.DieState.Rolling);
    }

    public boolean allDiceNotState(Die.DieState ds) {
        for (Ent de : this.fightLog.getSnapshot(FightLog.Temporality.Present).getAliveEntities()) {
            Die.DieState state = de.getDie().getState();
            if (state != ds) continue;
            return false;
        }
        return true;
    }

    public boolean requestPlayerRoll() {
        List<EntDie> diceToRoll;
        if (BulletStuff.isLined()) {
            BulletStuff.toggleDiceScatter();
            return false;
        }
        BulletStuff.resetAlignment();
        Snapshot present = this.fightLog.getSnapshot(FightLog.Temporality.Present);
        if (present.getRolls() <= 0) {
            return false;
        }
        if (!PhaseManager.get().getPhase().canRoll()) {
            return false;
        }
        if (present.isEnd()) {
            return false;
        }
        if (!Main.getSettings().isHasRolled()) {
            Main.getSettings().setHasRolled(true);
        }
        if ((diceToRoll = this.getHeroDiceAvailableToRoll()).isEmpty()) {
            Sounds.playSound(Sounds.error);
        }
        ArrayList<Ent> entitiesToRoll = new ArrayList<Ent>();
        for (EntDie entDie : diceToRoll) {
            entitiesToRoll.add(entDie.ent);
        }
        if (entitiesToRoll.size() == 0) {
            Sounds.playSound(Sounds.error);
            return false;
        }
        List<Hero> alives = present.getAliveHeroEntities();
        for (Global gt : present.getGlobals()) {
            String error = gt.getRollError(entitiesToRoll, alives.size());
            if (error == null) continue;
            this.showRollError(error);
            return false;
        }
        DungeonScreen dungeonScreen = DungeonScreen.get();
        present.spendRoll();
        this.roll(false, true);
        dungeonScreen.tutorialManager.onRoll(present.getEntities(true, false));
        return true;
    }

    public List<EntDie> getHeroDiceAvailableToRoll() {
        Phase p = PhaseManager.get().getPhase();
        if (p == null || !p.canRoll()) {
            return new ArrayList<EntDie>();
        }
        Snapshot present = this.fightLog.getSnapshot(FightLog.Temporality.Present);
        List<Hero> alives = present.getAliveHeroEntities();
        ArrayList<EntDie> dice = new ArrayList<EntDie>();
        if (this.anyDiceDangerousState()) {
            return new ArrayList<EntDie>();
        }
        for (Ent ent : alives) {
            Die.DieState state = ent.getDie().getState();
            if (state != Die.DieState.Stopped) continue;
            dice.add(ent.getDie());
        }
        return dice;
    }

    public boolean anyDiceDangerousState() {
        Snapshot present = this.fightLog.getSnapshot(FightLog.Temporality.Present);
        if (present == null) {
            return false;
        }
        for (Ent ent : present.getAliveHeroEntities()) {
            Die.DieState state = ent.getDie().getState();
            if (state != Die.DieState.Rolling && state != Die.DieState.Unlocking) continue;
            return true;
        }
        return false;
    }

    private void showRollError(String error) {
        Sounds.playSound(Sounds.error);
        AbilityHolder.showInfo(error, Colours.red);
    }

    public void firstRoll(boolean player) {
        Snapshot present = this.fightLog.getSnapshot(FightLog.Temporality.Present);
        for (Ent ent : present.getAliveEntities(player)) {
            if (ent.getDie().getState() == Die.DieState.Stopped) continue;
            return;
        }
        this.roll(true, player);
    }

    public void roll(boolean firstRoll, boolean player) {
        List<? extends Ent> entList = this.fightLog.getSnapshot(FightLog.Temporality.Present).getAliveEntities(player);
        ArrayList<EntDie> toRoll = new ArrayList<EntDie>();
        for (Ent ent : entList) {
            if (ent.getDie().getState() != Die.DieState.Stopped) continue;
            toRoll.add(ent.getDie());
        }
        DungeonScreen ds = DungeonScreen.get();
        long l = (long)(Math.random() * 9.99999999E8);
        if (!OptionLib.DISABLE_PREDICT.c()) {
            List<Integer> predictedOutcome = BulletStuff.predictAndReset(toRoll, firstRoll, l, player);
            if (OptionLib.SHOW_PREDICTION.c()) {
                String infoString = "";
                for (int i = 0; i < predictedOutcome.size(); ++i) {
                    infoString = infoString + ((EntDie)toRoll.get(i)).getSide(predictedOutcome.get(i));
                    if (i >= predictedOutcome.size() - 1) continue;
                    infoString = infoString + "[n]";
                }
                if (ds != null) {
                    ds.addPopup(new Pixl(3, 3).border(Colours.grey).text(infoString).pix());
                }
            }
            for (int i = 0; i < toRoll.size(); ++i) {
                EntDie ed = (EntDie)toRoll.get(i);
                if (predictedOutcome.size() == toRoll.size()) {
                    ed.setSideOverride(predictedOutcome.get(i));
                    continue;
                }
                TannLog.error("prediction error");
                ed.setSideOverride(Tann.randomInt(6));
            }
            predictionSavePlayer = player;
            ds.save();
            predictionSavePlayer = null;
        }
        Random r = Tann.makeStdRandom(l);
        for (EntDie entDie : toRoll) {
            entDie.roll(firstRoll, r);
        }
        if (player && !this.fightLog.getContext().skipStats()) {
            this.fightLog.getContext().getStatsManager().updateDiceRolled(toRoll.size());
        }
        if (player && ds != null) {
            ds.heroDiceRolled();
        }
        BulletStuff.resetAlignment();
        if (player || !OptionLib.FAST_ENEMY_TURNS.c()) {
            BulletStuff.addRollSFX(toRoll.size(), firstRoll, false);
        }
    }

    public void resetForRoll(boolean player) {
        this.resetForRoll(player, true, null, null);
    }

    public void resetForRoll(boolean player, boolean autoRoll, Integer lockState, Snapshot present) {
        this.resetForRoll(player, autoRoll, lockState, present, false, false);
    }

    public void resetForRoll(final boolean player, final boolean autoRoll, Integer lockState, Snapshot present, boolean specialFirstTurn, boolean fromSave) {
        List<? extends Ent> entities = this.fightLog.getSnapshot(FightLog.Temporality.Present).getAliveEntities(player);
        for (int i = 0; i < entities.size(); ++i) {
            final Ent de = entities.get(i);
            final EntDie die = de.getDie();
            boolean autolock = false;
            if (player && present != null) {
                EntState ps = present.getState(de);
                autolock = ps != null && ps.isAutoLock();
            }
            die.setupInitialLocation();
            if (autolock && !autoRoll) {
                die.setState(Die.DieState.Locked);
                continue;
            }
            if (autoRoll) {
                de.getDie().reset();
            }
            boolean shouldReturn = lockState == null || (lockState & 1 << i) == 0;
            final boolean applyNewQuaternion = autoRoll;
            if (shouldReturn) {
                final float interpSpeed = this.getInterpSpeedForAutoReturnToPlay(applyNewQuaternion, autoRoll, specialFirstTurn, fromSave);
                float delay = RollManager.getDelayForAutoReturn(specialFirstTurn, i);
                if (delay > 0.0f) {
                    Tann.delay(delay, new Runnable(){

                        @Override
                        public void run() {
                            de.getEntPanel().holdsDie = false;
                            die.returnToPlay(new Runnable(){

                                @Override
                                public void run() {
                                    if (autoRoll) {
                                        RollManager.this.firstRoll(player);
                                    }
                                }
                            }, applyNewQuaternion, interpSpeed);
                        }
                    });
                    continue;
                }
                de.getEntPanel().holdsDie = false;
                die.returnToPlay(new Runnable(){

                    @Override
                    public void run() {
                        if (autoRoll) {
                            RollManager.this.firstRoll(player);
                        }
                    }
                }, applyNewQuaternion, interpSpeed);
                continue;
            }
            die.setState(Die.DieState.Locked);
        }
    }

    private static float getDelayForAutoReturn(boolean specialFirstTurn, int index) {
        return specialFirstTurn ? (float)index * 0.3f : 0.0f;
    }

    private float getInterpSpeedForAutoReturnToPlay(boolean applyNewQuaternion, boolean autoRoll, boolean specialFirstTurn, boolean fromSave) {
        float base = Die.getBaseInterpSpeed();
        if (specialFirstTurn) {
            return base * 1.8f * (Main.isPortrait() ? 1.4f : 1.0f);
        }
        if (fromSave) {
            return 0.0f;
        }
        if (applyNewQuaternion) {
            return base * 1.4f;
        }
        if (autoRoll) {
            return base * 2.0f;
        }
        return base;
    }
}

