/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book.page.ledgerPage;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.Monster;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.content.gen.pipe.entity.monster.PipeMonster;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItem;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeMod;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.mode.creative.pastey.PasteMode;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.SmallModifierPanel;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.progress.chievo.AchLib;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.endOfFight.monsters.KillsStat;
import com.tann.dice.gameplay.progress.stats.stat.endOfFight.monsters.tracker.MonsterTrackerStat;
import com.tann.dice.gameplay.progress.stats.stat.pickRate.PickStat;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.DieSidePanel;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.screens.dungeon.panels.Explanel.Explanel;
import com.tann.dice.screens.dungeon.panels.book.page.BookPage;
import com.tann.dice.screens.dungeon.panels.book.page.ledgerPage.LedgerPage;
import com.tann.dice.screens.dungeon.panels.book.views.EntityLedgerView;
import com.tann.dice.screens.dungeon.panels.book.views.HeroLedgerView;
import com.tann.dice.screens.dungeon.panels.book.views.ItemLedgerView;
import com.tann.dice.screens.dungeon.panels.book.views.MonsterLedgerView;
import com.tann.dice.screens.dungeon.panels.entPanel.AbilityPanel;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ItemPanel;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ModifierPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Rectactor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannStageUtils;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.tp.TP;
import com.tann.dice.util.tp.TTP;
import com.tann.dice.util.ui.ClipboardUtils;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import com.tann.dice.util.ui.resolver.AnyDescResolver;
import com.tann.dice.util.ui.resolver.MetaResolver;
import com.tann.dice.util.ui.resolver.Resolver;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LedgerUtils {
    public static final int BGG_FACTOR = 3;
    private static final int CONTENT_GAP = 10;
    private static final int GAP_AFTER_FOUND = 5;

    public static Group makeHeroGroup(Map<String, Stat> allMergedStats, int contentWidth) {
        Pixl heroesPix = new Pixl(0).forceWidth(contentWidth);
        Map<HeroCol, Map<Integer, List<HeroType>>> map = HeroTypeUtils.getSortedHeroes();
        int total = 0;
        int seen = 0;
        int maxLevel = 3;
        List<Object> seenHeroes = new ArrayList();
        long bannedColl = 0L;
        if (Main.getCurrentScreen() instanceof DungeonScreen) {
            DungeonContext dc = DungeonScreen.get().getDungeonContext();
            seenHeroes = dc.makeSeenHeroTypes(null);
            bannedColl = dc.getParty().getBannedCollisionBits(false);
        }
        for (HeroCol col : HeroCol.basics()) {
            Pixl colPixl = new Pixl();
            for (int level = 1; level <= maxLevel; ++level) {
                ArrayList colHeroes = new ArrayList(map.get(col).get(level));
                Collections.sort(colHeroes, LedgerUtils.makeSorter(allMergedStats));
                for (int heroIndex = 0; heroIndex < colHeroes.size(); ++heroIndex) {
                    ImageActor ia;
                    boolean visible;
                    int rejected;
                    int chosen;
                    final HeroType ht = (HeroType)colHeroes.get(heroIndex);
                    final boolean banned = HeroTypeUtils.bannedHeroTypeByCollision(ht, bannedColl);
                    final boolean seenThisRun = seenHeroes.contains(ht);
                    if (ht.skipStats()) {
                        chosen = 0;
                        rejected = 0;
                    } else {
                        Stat s = allMergedStats.get(PickStat.nameFor(ht));
                        rejected = PickStat.val(s, true);
                        chosen = PickStat.val(s, false);
                    }
                    boolean bl = visible = !UnUtil.isLocked(ht) && (chosen + rejected > 0 || level == 1);
                    if (visible) {
                        ++seen;
                    }
                    ++total;
                    HeroLedgerView hav = new HeroLedgerView(ht, visible);
                    if (!LedgerUtils.addStandardListener(hav, !visible, ht)) {
                        hav.addListener(new TannListener(){

                            @Override
                            public boolean info(int button, float x, float y) {
                                Group tw;
                                Hero h = new Hero(ht);
                                DiePanel dp = new DiePanel(h);
                                if (ht.level > 1) {
                                    TextWriter chosenWriter = new TextWriter(BookPage.getChosenString(chosen, rejected), 999, h.getColour(), 2);
                                    dp.addActor(chosenWriter);
                                    chosenWriter.setPosition((int)(dp.getWidth() / 2.0f - chosenWriter.getWidth() / 2.0f), (int)(dp.getHeight() - 1.0f));
                                }
                                if (seenThisRun) {
                                    tw = new Pixl(0, 3).border(Colours.purple).text("[purple]Seen this run").pix();
                                    dp.addActor(tw);
                                    Tann.center(tw);
                                    tw.setY(-tw.getHeight() - 1.0f);
                                }
                                if (banned) {
                                    tw = new Pixl(0, 3).border(Colours.purple).text("Banned this run [blue](mana)").pix();
                                    dp.addActor(tw);
                                    Tann.center(tw);
                                    tw.setY(-tw.getHeight() - 1.0f);
                                }
                                BookPage.push(dp);
                                return true;
                            }
                        });
                    }
                    colPixl.actor(hav, contentWidth - 10, 1).gap(1);
                    if (hav.getWidth() * (float)colHeroes.size() > (float)contentWidth * 0.9f && heroIndex == colHeroes.size() / 2 - 1) {
                        colPixl.row(1);
                    }
                    if (seenThisRun) {
                        ia = new ImageActor(Images.heroSeen);
                        hav.addActor(ia);
                        ia.setTouchable(Touchable.disabled);
                    }
                    if (!banned || ht.heroCol == HeroCol.red || ht.heroCol == HeroCol.blue) continue;
                    ia = new ImageActor(Images.heroBanned);
                    hav.addActor(ia);
                    ia.setTouchable(Touchable.disabled);
                }
                if (level - 1 >= maxLevel) continue;
                colPixl.row(7);
            }
            heroesPix.row(10).actor(colPixl.pix());
        }
        return new Pixl(0).forceWidth(contentWidth).text(TextWriter.getTag(HeroType.getIdCol()) + seen + "/" + total + " heroes found").row(5).actor(heroesPix.pix()).pix();
    }

    public static Group makeMonsterGroup(Map<String, Stat> allMergedStats, int contentWidth) {
        Pixl monstersPix = new Pixl(2).forceWidth(contentWidth);
        Map<EntSize, List<MonsterType>> map = MonsterTypeLib.getSortedMonsters();
        int total = 0;
        int seen = 0;
        for (EntSize size : EntSize.values()) {
            ArrayList types = new ArrayList(map.get((Object)size));
            Collections.sort(types, LedgerUtils.makeMonsterSorter(allMergedStats));
            for (final MonsterType type : types) {
                MonsterLedgerView mav;
                boolean fullyVisible;
                boolean hidden;
                final int kills = allMergedStats.get(KillsStat.getStatName(type)).getValue();
                final int victories = allMergedStats.get(MonsterTrackerStat.getNameFrom(type, true)).getValue();
                final int defeats = allMergedStats.get(MonsterTrackerStat.getNameFrom(type, false)).getValue();
                boolean bl = hidden = kills == 0 && defeats == 0 && victories == 0;
                if (hidden && type.hideUntilFound()) continue;
                ++total;
                boolean bl2 = fullyVisible = kills + victories + defeats > 0;
                if (fullyVisible) {
                    ++seen;
                }
                if (!LedgerUtils.addStandardListener(mav = new MonsterLedgerView(type, hidden), hidden, type)) {
                    mav.addListener(new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            Monster m = new Monster(type);
                            Pixl p = new Pixl(-1);
                            if (!fullyVisible) {
                                p.actor(new Pixl(0, 2).border(Colours.purple).text("[text]Not encountered yet...")).row();
                            } else {
                                TextWriter killsWriter = new TextWriter("[red]" + kills + " " + Words.plural("kill", kills), 999, Colours.purple, 2);
                                float ratio = (float)victories / (float)(victories + defeats);
                                String col = ratio < 0.5f ? "[red]" : (ratio < 0.9f ? "[orange]" : "[green]");
                                TextWriter vicWriter = new TextWriter(col + victories + "/" + (victories + defeats) + " fights won", 999, Colours.purple, 2);
                                p.actor(killsWriter).gap(3).actor(vicWriter).row();
                            }
                            p.actor(new DiePanel(m));
                            Group g = p.pix();
                            BookPage.push(g);
                            Tann.center(g);
                            super.clicked(event, x, y);
                        }
                    });
                }
                monstersPix.actor(mav, contentWidth - 10);
            }
            monstersPix.row(10);
        }
        return new Pixl(0).forceWidth(contentWidth).text(TextWriter.getTag(MonsterType.getIdCol()) + seen + "/" + total + " monsters found").row(5).actor(monstersPix.pix()).pix();
    }

    public static Group makeItemsGroup(Map<String, Stat> allMergedStats, int contentWidth) {
        int i;
        Pixl itemPixl = new Pixl(2).forceWidth(contentWidth);
        int totalSeen = 0;
        int total = 0;
        ArrayList<Integer> qualities = new ArrayList<Integer>();
        for (i = 1; i <= 20; ++i) {
            qualities.add(i);
        }
        for (i = 0; i >= -7; --i) {
            qualities.add(i);
        }
        Iterator i2 = qualities.iterator();
        while (i2.hasNext()) {
            int quality = (Integer)i2.next();
            List<Item> itemList = ItemLib.getAllItemsWithQuality(quality, true);
            if (itemList.size() == 0) continue;
            total += itemList.size();
            Collections.sort(itemList, LedgerUtils.makeSorter(allMergedStats));
            String colTag = quality >= 0 ? "[grey]" : "[purple]";
            TextWriter tw = new TextWriter(colTag + Math.abs(quality), 999, Colours.grey, 2);
            itemPixl.actor(tw).row(-1);
            for (final Item e : itemList) {
                int rejected;
                boolean seen;
                Stat ps = allMergedStats.get(PickStat.nameFor(e));
                final int chosen = PickStat.val(ps, false);
                boolean bl = seen = chosen + (rejected = PickStat.val(ps, true)) > 0;
                if (seen) {
                    ++totalSeen;
                }
                ItemLedgerView eav = new ItemLedgerView(e, UnUtil.isLocked(e) ? ItemLedgerView.EquipSeenState.Locked : (seen ? ItemLedgerView.EquipSeenState.Seen : ItemLedgerView.EquipSeenState.Missing));
                itemPixl.actor(eav, contentWidth - 10);
                if (LedgerUtils.addStandardListener(eav, !seen, e)) continue;
                eav.addListener(new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        TextWriter chosenWriter = new TextWriter(BookPage.getChosenString(chosen, rejected), 999, Colours.grey, 2);
                        ItemPanel exp = new ItemPanel(e, true);
                        exp.addActor(chosenWriter);
                        chosenWriter.setPosition((int)(exp.getWidth() / 2.0f - chosenWriter.getWidth() / 2.0f), (int)(exp.getHeight() - 1.0f));
                        BookPage.push(exp);
                        super.clicked(event, x, y);
                    }
                });
            }
            itemPixl.row(8);
        }
        Group g = itemPixl.pix();
        return new Pixl(0).forceWidth(contentWidth).text(TextWriter.getTag(Item.getIdCol()) + totalSeen + "/" + total + " items found").row(5).actor(g).pix();
    }

    public static Group makeModifiersGroup(final Map<String, Stat> allMergedStats, final int contentWidth, final LedgerPage ledgerPage, final Boolean bless, final ModGenType genType) {
        StandardButton tb;
        String preTag;
        String text;
        Color c;
        boolean big;
        Color col;
        String name;
        int total = 0;
        if (bless == null) {
            name = "modifiers";
            col = Colours.grey;
        } else {
            name = bless != false ? "blessings" : "curses";
            col = bless != false ? Colours.green : Colours.purple;
        }
        Pixl blessingsPix = new Pixl(2).forceWidth(contentWidth);
        int amt = 5;
        List<Modifier> modifiers = genType.getExamples(5, bless);
        boolean bl = big = modifiers.size() <= 5;
        if (big) {
            Tann.uniquify(modifiers);
        }
        Collections.sort(modifiers, LedgerUtils.makeSorter(allMergedStats, bless != null && bless == false));
        int prevTier = -9999;
        for (final Modifier modifier : modifiers) {
            Group a;
            int tier = modifier.getTier();
            if (tier != prevTier && genType == ModGenType.Designed) {
                if (prevTier != -9999) {
                    blessingsPix.row(10);
                } else {
                    blessingsPix.row();
                }
                TextWriter tw = new TextWriter(modifier.getTierString(), 999, modifier.getBorderColour(), 2);
                blessingsPix.actor(tw).row(-1);
            }
            prevTier = tier;
            ++total;
            if (UnUtil.isLocked(modifier)) {
                a = new TextWriter("[grey]locked", 9999, modifier.getBorderColour(), 2);
                a.addListener(new TannListener(){

                    @Override
                    public boolean info(int button, float x, float y) {
                        AchLib.showUnlockFor(modifier);
                        return true;
                    }
                });
            } else if (big) {
                a = new ModifierPanel(modifier, false);
            } else {
                a = new SmallModifierPanel(modifier);
                a.addListener(new TannListener(){

                    @Override
                    public boolean info(int button, float x, float y) {
                        ModifierPanel mp = new ModifierPanel(modifier, true);
                        BookPage.push(mp);
                        return true;
                    }
                });
            }
            blessingsPix.actor(a, contentWidth - 10);
        }
        Pixl fPix = new Pixl(3);
        fPix.actor(new Rectactor(150, 1, Colours.grey)).row();
        for (final Boolean bl2 : new Boolean[]{false, true, null}) {
            c = null;
            if (bl2 == null) {
                text = "Both";
                c = Colours.grey;
            } else {
                text = bl2 != false ? "Blessings" : "Curses";
                c = bl2 != false ? Colours.green : Colours.purple;
            }
            preTag = c == null ? "" : TextWriter.getTag(c);
            tb = new StandardButton(preTag + text, bl2 == bless ? Colours.light : c);
            tb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    ledgerPage.showThing(LedgerUtils.makeModifiersGroup(allMergedStats, contentWidth, ledgerPage, bl2, genType));
                }
            });
            fPix.actor(tb);
        }
        fPix.row().actor(new Rectactor(150, 1, Colours.grey)).row();
        for (final ModGenType modGenType : ModGenType.values()) {
            text = modGenType.name();
            c = modGenType.getCol();
            preTag = TextWriter.getTag(c);
            tb = new StandardButton(preTag + text, modGenType == genType ? Colours.light : c);
            tb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    ledgerPage.showThing(LedgerUtils.makeModifiersGroup(allMergedStats, contentWidth, ledgerPage, bless, modGenType));
                }
            });
            fPix.actor(tb);
        }
        fPix.row().actor(new Rectactor(150, 1, Colours.grey));
        Group group = fPix.pix();
        Pixl main = new Pixl(0).forceWidth(contentWidth);
        main.actor(group);
        String found = genType == ModGenType.Designed ? "found" : "generated";
        switch (genType) {
            case Designed: {
                found = "found";
                break;
            }
            case Generated: {
                found = "generated";
                break;
            }
            case Wild: {
                found = "generated ([red][p]wild[cu][p])";
            }
        }
        main.row(5).text(TextWriter.getTag(col) + total + " " + name + " " + found);
        main.row(5).actor(blessingsPix.pix());
        return main.pix();
    }

    public static Group makeKeywordsGroup(Map<String, Stat> allMergedStats, int contentWidth) {
        final HashMap keywordActors = new HashMap();
        HashMap usedRegions = new HashMap();
        for (Keyword k : Keyword.values()) {
            keywordActors.put(k, new ArrayList());
            usedRegions.put(k, new ArrayList());
        }
        for (EntType et : EntTypeUtils.getAll()) {
            if (UnUtil.isLocked(et) || LedgerUtils.shouldSkip(et, allMergedStats)) continue;
            for (final EntSide es : et.getNiceSides()) {
                for (final Keyword k : es.getBaseEffect().getKeywords()) {
                    if (((List)usedRegions.get((Object)k)).contains(es.getTexture())) continue;
                    ((List)usedRegions.get((Object)k)).add(es.getTexture());
                    DieSidePanel dsp = new DieSidePanel(es, null);
                    dsp.addListener(new TannListener(){

                        @Override
                        public boolean info(int button, float x, float y) {
                            Sounds.playSound(Sounds.pip);
                            Explanel a = new Explanel(es, null);
                            Main.getCurrentScreen().push(a, 0.5f);
                            Tann.center(a);
                            return true;
                        }
                    });
                    ((List)keywordActors.get((Object)k)).add(dsp);
                }
            }
        }
        for (EntType et : EntTypeUtils.getAll()) {
            if (UnUtil.isLocked(et) || LedgerUtils.shouldSkip(et, allMergedStats)) continue;
            ArrayList<Keyword> etks = new ArrayList<Keyword>();
            for (EntSide es : et.getNiceSides()) {
                etks.addAll(es.getBaseEffect().getKeywords());
            }
            Tann.uniquify(etks);
            for (Keyword etk : etks) {
                ((List)keywordActors.get((Object)etk)).add(EntityLedgerView.getLV(et));
            }
        }
        for (EntType et : EntTypeUtils.getAll()) {
            if (LedgerUtils.shouldSkip(et, allMergedStats)) continue;
            for (Trait t : et.traits) {
                final Ability s = t.personal.getAbility();
                if (s == null) continue;
                for (Keyword k : s.getBaseEffect().getKeywords()) {
                    AbilityPanel a = new AbilityPanel(s);
                    a.addListener(new TannListener(){

                        @Override
                        public boolean info(int button, float x, float y) {
                            Explanel explanel = new Explanel(s, false);
                            BookPage.push(explanel);
                            return true;
                        }
                    });
                    ((List)keywordActors.get((Object)k)).add(a);
                }
            }
        }
        for (Item i : ItemLib.getMasterCopy()) {
            if (LedgerUtils.shouldSkip(i, allMergedStats)) continue;
            for (Keyword k : i.getReferencedKeywords()) {
                ItemLedgerView iav = new ItemLedgerView(i, ItemLedgerView.EquipSeenState.Seen);
                iav.addBasicListener();
                ((List)keywordActors.get((Object)k)).add(iav);
            }
        }
        for (Modifier m : ModifierLib.getAll()) {
            if (LedgerUtils.shouldSkip(m, allMergedStats)) continue;
            for (Keyword k : m.getReferencedKeywords()) {
                SmallModifierPanel smp = new SmallModifierPanel(m);
                smp.addBasicListener();
                ((List)keywordActors.get((Object)k)).add(smp);
            }
        }
        Pixl p = new Pixl(2);
        int maxWidth = contentWidth - 10;
        List<Keyword> keywords = Arrays.asList(Keyword.values());
        Collections.sort(keywords, new Comparator<Keyword>(){

            @Override
            public int compare(Keyword o1, Keyword o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<Keyword> shown = new ArrayList<Keyword>();
        for (final Keyword k : keywords) {
            Object actors;
            if (k.skipStats() || (actors = (List)keywordActors.get((Object)k)).size() == 0) continue;
            shown.add(k);
            ((List)keywordActors.get((Object)k)).addAll(0, KUtils.makeExampleSides(k));
            StandardButton tb = KUtils.makeKeywordButton(k);
            p.actor(tb, maxWidth);
            tb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    LedgerUtils.showKD(k, keywordActors);
                }
            });
        }
        int td = 0;
        Pixl kp = new Pixl(3);
        for (final Keyword k : keywords) {
            if (shown.contains((Object)k)) continue;
            ++td;
            ((List)keywordActors.get((Object)k)).addAll(0, KUtils.makeExampleSides(k));
            StandardButton tb = KUtils.makeKeywordButton(k);
            kp.actor(tb, maxWidth);
            tb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    LedgerUtils.showKD(k, keywordActors);
                }
            });
        }
        Group unusedKeywords = kp.pix();
        Group g = new Pixl(0, 1).actor(unusedKeywords).pix();
        Color cover = Colours.withAlpha(Colours.dark, 0.37f).cpy();
        Rectactor ra = new Rectactor((int)g.getWidth(), (int)g.getHeight(), cover, cover);
        ra.setTouchable(Touchable.disabled);
        g.addActor(ra);
        unusedKeywords = g;
        p.row(5).text("locked/unused").row(2).actor(unusedKeywords);
        g = p.pix();
        return new Pixl(0).forceWidth(contentWidth).text("[orange]" + Keyword.values().length + " total keywords").row(5).actor(g).pix();
    }

    private static void showKD(Keyword k, Map<Keyword, List<Actor>> keywordActors) {
        Actor a = LedgerUtils.makeKeywordDetail(k, keywordActors);
        a = Tann.makeScrollpaneIfNecessary(a);
        BookPage.push(a);
    }

    private static boolean shouldSkip(Unlockable et, Map<String, Stat> allMergedStats) {
        if (et instanceof MonsterType) {
            MonsterType type = (MonsterType)et;
            int kills = allMergedStats.get(KillsStat.getStatName(type)).getValue();
            int victories = allMergedStats.get(MonsterTrackerStat.getNameFrom(type, true)).getValue();
            int defeats = allMergedStats.get(MonsterTrackerStat.getNameFrom(type, false)).getValue();
            return kills == 0 && defeats == 0 && victories == 0;
        }
        return false;
    }

    private static Actor makeKeywordDetail(Keyword k, Map<Keyword, List<Actor>> keywordActors) {
        Item item;
        int maxWidth = (int)Math.min((float)Main.width * 0.8f, 200.0f);
        Pixl p = new Pixl(2, 5).border(k.getColour());
        p.actor(KUtils.makeExplanationActor(k, maxWidth)).row();
        ArrayList<Group> acs = new ArrayList<Group>((Collection)keywordActors.get((Object)k));
        Modifier m = ModifierLib.byName("hero." + k.name());
        if (m.getReferencedKeywords().contains((Object)k)) {
            acs.add(new SmallModifierPanel(m).addBasicListener());
        }
        if ((item = ItemLib.byName("k." + k.name())).getReferencedKeywords().contains((Object)k)) {
            acs.add(new ItemLedgerView(item, ItemLedgerView.EquipSeenState.Seen).addBasicListener());
        }
        for (Actor actor : acs) {
            p.actor(actor, maxWidth);
        }
        return p.pix(8);
    }

    private static Comparator<Unlockable> makeSorter(Map<String, Stat> allMergedStats) {
        return LedgerUtils.makeSorter(allMergedStats, false);
    }

    private static Comparator<Unlockable> makeSorter(final Map<String, Stat> allMergedStats, final boolean abs) {
        return new Comparator<Unlockable>(){

            @Override
            public int compare(Unlockable o1, Unlockable o2) {
                boolean hidden2;
                int tier2;
                int tier1;
                if (LedgerUtils.hasTier(o1) && (tier1 = LedgerUtils.getTier(o1)) != (tier2 = LedgerUtils.getTier(o2))) {
                    int result = tier1 - tier2;
                    if (abs) {
                        return -result;
                    }
                    return result;
                }
                if (UnUtil.isLocked(o1) != UnUtil.isLocked(o2)) {
                    if (UnUtil.isLocked(o1)) {
                        return 1;
                    }
                    return -1;
                }
                if (o1 instanceof Modifier) {
                    return ((Modifier)o1).getName().compareTo(((Modifier)o2).getName());
                }
                Stat ps1 = null;
                Stat ps2 = null;
                if (o1 instanceof Choosable && !(o1 instanceof Modifier)) {
                    ps1 = (Stat)allMergedStats.get(PickStat.nameFor((Choosable)((Object)o1)));
                    ps2 = (Stat)allMergedStats.get(PickStat.nameFor((Choosable)((Object)o2)));
                }
                if (ps1 == null || ps2 == null) {
                    return 0;
                }
                int chosenValue1 = PickStat.val(ps1, false);
                int rejectedValue1 = PickStat.val(ps1, true);
                int chosenValue2 = PickStat.val(ps2, false);
                int rejectedValue2 = PickStat.val(ps2, true);
                boolean hidden1 = chosenValue1 == 0 && rejectedValue1 == 0;
                boolean bl = hidden2 = chosenValue2 == 0 && rejectedValue2 == 0;
                if (hidden1 != hidden2) {
                    return hidden1 ? 1 : -1;
                }
                float ratio1 = (float)(chosenValue1 + 3) / (float)(chosenValue1 + rejectedValue1 + 6);
                float ratio2 = (float)(chosenValue2 + 3) / (float)(chosenValue2 + rejectedValue2 + 6);
                return (int)Math.signum(ratio2 - ratio1);
            }
        };
    }

    private static int getTier(Unlockable u) {
        if (u instanceof Hero) {
            return ((Hero)((Object)u)).getLevel();
        }
        if (u instanceof Modifier) {
            return ((Modifier)u).getTier();
        }
        if (u instanceof Item) {
            return ((Item)u).getTier();
        }
        throw new RuntimeException("invalid tier-haver " + u.getClass().getSimpleName());
    }

    private static boolean hasTier(Unlockable o1) {
        return o1 instanceof Hero || o1 instanceof Modifier || o1 instanceof Item;
    }

    private static Comparator<? super MonsterType> makeMonsterSorter(final Map<String, Stat> allMergedStats) {
        return new Comparator<MonsterType>(){

            @Override
            public int compare(MonsterType o1, MonsterType o2) {
                boolean hidden2;
                boolean locked2;
                boolean locked1 = UnUtil.isLocked(o1);
                if (locked1 != (locked2 = UnUtil.isLocked(o2))) {
                    return locked1 ? 1 : -1;
                }
                int kills1 = ((Stat)allMergedStats.get(KillsStat.getStatName(o1))).getValue();
                int kills2 = ((Stat)allMergedStats.get(KillsStat.getStatName(o2))).getValue();
                int victories1 = ((Stat)allMergedStats.get(MonsterTrackerStat.getNameFrom(o1, true))).getValue();
                int victories2 = ((Stat)allMergedStats.get(MonsterTrackerStat.getNameFrom(o2, true))).getValue();
                int defeats1 = ((Stat)allMergedStats.get(MonsterTrackerStat.getNameFrom(o1, false))).getValue();
                int defeats2 = ((Stat)allMergedStats.get(MonsterTrackerStat.getNameFrom(o2, false))).getValue();
                boolean hidden1 = kills1 == 0 && defeats1 == 0 && victories1 == 0;
                boolean bl = hidden2 = kills2 == 0 && defeats2 == 0 && victories2 == 0;
                if (hidden1 != hidden2) {
                    return hidden1 ? 1 : -1;
                }
                boolean sortByKills = true;
                return kills2 - kills1;
            }
        };
    }

    private static boolean addStandardListener(Actor a, boolean hidden, final Unlockable unlockable) {
        if (UnUtil.isLocked(unlockable)) {
            a.addListener(new TannListener(){

                @Override
                public boolean info(int button, float x, float y) {
                    AchLib.showUnlockFor(unlockable);
                    return true;
                }
            });
            return true;
        }
        return false;
    }

    public static Actor makePinsGroup(Map<String, Stat> allMergedStats, int contentWidth, LedgerPage ledgerPage) {
        return LedgerUtils.makePinsGroup(contentWidth, ledgerPage, null);
    }

    private static Actor makePinsGroup(final int contentWidth, final LedgerPage ledgerPage, List<String> pinArg) {
        List<String> pinnedStrings;
        if (pinArg == null) {
            pinnedStrings = Main.getSettings().getPins();
        } else {
            pinnedStrings = pinArg;
            Main.getSettings().setPins(pinArg);
        }
        Pixl p = new Pixl(3);
        final List<TTP> data = Arrays.asList(new TTP<String, Color, 16>("name", Colours.grey, new MetaResolver(){

            @Override
            public void resolve(Object o) {
                LedgerUtils.attemptToAddPin(o, pinnedStrings, contentWidth, ledgerPage);
            }
        }), new TTP<String, Color, 17>("desc", Colours.grey, new AnyDescResolver(){

            @Override
            public void resolve(Object o) {
                LedgerUtils.attemptToAddPin(o, pinnedStrings, contentWidth, ledgerPage);
            }
        }));
        ArrayList<Actor> butts = new ArrayList<Actor>();
        for (final TTP datum : data) {
            StandardButton sb = new StandardButton(TextWriter.getTag((Color)datum.b) + (String)datum.a, (Color)datum.b);
            sb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    Sounds.playSound(Sounds.pipSmall);
                    ((Resolver)datum.c).activate();
                }
            });
            butts.add(sb);
        }
        StandardButton paste = new StandardButton("[purple]paste");
        paste.setRunnable(new Runnable(){

            @Override
            public void run() {
                Pipe.setupChecks();
                this.doInput();
                Pipe.disableChecks();
            }

            private void doInput() {
                String contents = ClipboardUtils.pasteSafer();
                if (contents == null) {
                    Sounds.playSound(Sounds.pipSmall);
                    Main.getCurrentScreen().showDialog("invalid clipboard text", Colours.red);
                    return;
                }
                if (contents.startsWith("=")) {
                    contents = contents.substring(1);
                    String[] modNames = contents.split(",");
                    int amt = pinnedStrings.size();
                    for (String modName : modNames) {
                        boolean bl = ((Resolver)((TTP)data.get((int)0)).c).debugResolve(modName);
                    }
                    int added = pinnedStrings.size() - amt;
                    Main.getCurrentScreen().showDialog("added " + added, Colours.blue);
                    return;
                }
                String genericError = PasteMode.getPasteErrorGeneric(contents);
                if (genericError != null) {
                    Main.getCurrentScreen().showDialog(genericError, Colours.red);
                    return;
                }
                boolean success = ((Resolver)((TTP)data.get((int)0)).c).debugResolve(contents);
                if (!success) {
                    Sounds.playSound(Sounds.pipSmall);
                    Main.getCurrentScreen().showDialog("failed to find", Colours.red);
                }
            }
        });
        butts.add(2, paste);
        for (Object gen : (StandardButton)Tann.BOTH) {
            StandardButton sb = new StandardButton("[yellow]" + (gen != false ? "+gen" : "+rng"));
            sb.setRunnable(new Runnable((boolean)gen, pinnedStrings, ledgerPage, contentWidth){
                final /* synthetic */ boolean val$gen;
                final /* synthetic */ List val$pinnedStrings;
                final /* synthetic */ LedgerPage val$ledgerPage;
                final /* synthetic */ int val$contentWidth;
                {
                    this.val$gen = bl;
                    this.val$pinnedStrings = list;
                    this.val$ledgerPage = ledgerPage;
                    this.val$contentWidth = n;
                }

                @Override
                public void run() {
                    String pinName;
                    Sounds.playSound(Sounds.pipSmall);
                    int r = (int)(Math.random() * 4.0);
                    switch (r) {
                        case 0: {
                            pinName = (this.val$gen ? PipeItem.makeGen() : ItemLib.random()).getName();
                            break;
                        }
                        case 1: {
                            pinName = (this.val$gen ? PipeMonster.makeGen() : EntTypeUtils.random()).getName();
                            break;
                        }
                        case 2: {
                            pinName = (this.val$gen ? PipeMod.makeGen(Tann.half()) : ModifierLib.random()).getName();
                            break;
                        }
                        default: {
                            pinName = this.val$gen ? PipeMod.makeGen(Tann.half()).getName() : Tann.random(Keyword.values()).name();
                        }
                    }
                    LedgerUtils.addPin(pinName, this.val$pinnedStrings);
                    this.val$ledgerPage.showThing(LedgerUtils.makePinsGroup(this.val$contentWidth, this.val$ledgerPage, this.val$pinnedStrings));
                }
            });
            butts.add(sb);
        }
        if (pinnedStrings.size() > 4) {
            StandardButton clear = new StandardButton("[red]clear");
            clear.setRunnable(new Runnable(){

                @Override
                public void run() {
                    ChoiceDialog cd = new ChoiceDialog("[purple]Clear " + pinnedStrings.size() + " pins?", ChoiceDialog.ChoiceNames.PurpleYes, new Runnable(){

                        @Override
                        public void run() {
                            LedgerUtils.clearPins(pinnedStrings);
                            ledgerPage.showThing(LedgerUtils.makePinsGroup(contentWidth, ledgerPage, pinnedStrings));
                            Sounds.playSound(Sounds.magic);
                            Main.getCurrentScreen().popSingleMedium();
                        }
                    }, new Runnable(){

                        @Override
                        public void run() {
                            Sounds.playSound(Sounds.pop);
                            Main.getCurrentScreen().popSingleMedium();
                        }
                    });
                    Main.getCurrentScreen().push(cd, 0.8f);
                    Tann.center(cd);
                    Sounds.playSound(Sounds.pipSmall);
                }
            });
            butts.add(clear);
        }
        p.listActor((int)((float)contentWidth * 0.9f), butts);
        Pixl extraP = new Pixl(2);
        final ArrayList pinnedElements = new ArrayList();
        MetaResolver mr = new MetaResolver(){

            @Override
            public void resolve(Object o) {
                if (o instanceof EntType) {
                    pinnedElements.add(LedgerUtils.getExtrasActor((EntType)o));
                } else if (o instanceof Unlockable && o instanceof Choosable) {
                    boolean tooBig;
                    Unlockable u = (Unlockable)o;
                    Choosable c = (Choosable)o;
                    Actor tst = u.makeUnlockActor(true);
                    boolean hasScroll = false;
                    if (tst instanceof Group) {
                        Group gtst = (Group)tst;
                        hasScroll = TannStageUtils.hasActor(gtst, ScrollPane.class);
                    }
                    float wThresh = 0.6f;
                    float hThresh = 0.4f;
                    boolean bl = tooBig = tst.getWidth() > (float)Main.width * 0.6f || tst.getHeight() > (float)Main.height * 0.4f;
                    if (tooBig || hasScroll) {
                        tst = u.makeUnlockActor(false);
                    }
                    pinnedElements.add(new TP<String, Actor>(c.getName(), tst));
                } else if (o instanceof Keyword) {
                    Keyword k = (Keyword)((Object)o);
                    pinnedElements.add(new TP<String, Actor>(k.getName(), KUtils.makeActor(k, null)));
                }
            }
        };
        ArrayList<String> failed = new ArrayList<String>();
        for (String pinnedString : pinnedStrings) {
            Pipe.setupChecks();
            boolean success = mr.debugResolve(pinnedString);
            Pipe.disableChecks();
            if (success) continue;
            failed.add(pinnedString);
        }
        pinnedStrings.removeAll(failed);
        for (final TP extra : pinnedElements) {
            Pixl pp = new Pixl();
            ImageActor closeButt = new ImageActor(Images.tut_close);
            closeButt.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    Sounds.playSound(Sounds.pipSmall);
                    pinnedStrings.remove(extra.a);
                    ledgerPage.showThing(LedgerUtils.makePinsGroup(contentWidth, ledgerPage, pinnedStrings));
                    return true;
                }
            });
            pp.actor(closeButt);
            Group a = pp.row(-1).actor((Actor)extra.b).pix();
            extraP.actor(a, (float)contentWidth * 0.85f);
        }
        p.row(3).actor(extraP.pix(2));
        p.row(3).actor(OptionLib.SHOW_COPY.makeFullDescribedUnlockActor());
        return p.pix();
    }

    private static void attemptToAddPin(Object o, List<String> pinnedStrings, int contentWidth, LedgerPage ledgerPage) {
        if (o instanceof EntType) {
            LedgerUtils.addPin(((EntType)o).getName(), pinnedStrings);
        } else if (o instanceof Unlockable && o instanceof Choosable) {
            Choosable c = (Choosable)o;
            LedgerUtils.addPin(c.getName(), pinnedStrings);
        } else if (o instanceof Keyword) {
            LedgerUtils.addPin(((Keyword)((Object)o)).getName(), pinnedStrings);
        } else {
            return;
        }
        Sounds.playSound(Sounds.pipSmall);
        ledgerPage.showThing(LedgerUtils.makePinsGroup(contentWidth, ledgerPage, pinnedStrings));
    }

    private static void clearPins(List<String> pinnedStrings) {
        pinnedStrings.clear();
    }

    private static boolean addPin(String name, List<String> pinnedStrings) {
        pinnedStrings.remove(name);
        pinnedStrings.add(0, name);
        return true;
    }

    private static TP<String, Actor> getExtrasActor(EntType et) {
        return new TP<String, Actor>(et.getName(), new DiePanel(et.makeEnt()).withoutDice().getFullActor());
    }

    public static enum ModGenType {
        Designed(Colours.orange),
        Generated(Colours.blue),
        Wild(Colours.red);

        final Color col;

        private ModGenType(Color col) {
            this.col = col;
        }

        public Color getCol() {
            return this.col;
        }

        public List<Modifier> getExamples(int amt, Boolean blessing) {
            switch (this) {
                case Designed: {
                    return new ArrayList<Modifier>(ModifierLib.getAll(blessing));
                }
                case Generated: {
                    return PipeMod.makeGenerated(amt, blessing, false);
                }
                case Wild: {
                    return PipeMod.makeGenerated(amt, blessing, true);
                }
            }
            return new ArrayList<Modifier>();
        }
    }
}

