/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.bite;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Tann;

public class BiteActor
extends CombatEffectActor {
    TextureRegion[] regions = new TextureRegion[2];
    Ent target;
    EntPanel targetPanel;
    int damage;
    EntSize size;
    boolean shielded;

    public BiteActor(Ent target, int damage, String filename, EntSize size) {
        this.regions[0] = ImageUtils.loadExt("combatEffects/bite/" + filename + "/top");
        this.regions[1] = ImageUtils.loadExt("combatEffects/bite/" + filename + "/bot");
        this.damage = damage;
        this.setSize(this.regions[0].getRegionWidth(), 0.0f);
        this.target = target;
        this.targetPanel = target.getEntPanel();
        this.size = size;
    }

    @Override
    protected void start(FightLog fightLog) {
        this.shielded = BiteActor.isBlocked(this.damage, this.target);
        int height = 10;
        int moveAmount = 9;
        for (int i = 0; i < 2; ++i) {
            int xPosition = (int)(this.targetPanel.dieHolder.getX() + this.targetPanel.dieHolder.getWidth() / 2.0f - (float)(this.regions[i].getRegionWidth() / 2));
            if (this.shielded) {
                xPosition += this.getShieldedBiteOffset();
            }
            int mul = i * 2 - 1;
            ImageActor teethActor = new ImageActor(this.regions[i]);
            DungeonScreen.get().addActor(teethActor);
            Vector2 panelVector = Tann.getAbsoluteCoordinates(this.targetPanel);
            teethActor.setPosition((float)xPosition + panelVector.x, (float)((int)(this.targetPanel.getHeight() / 2.0f + (float)(-mul * height) - teethActor.getHeight() / 2.0f)) + panelVector.y);
            float openRatio = 0.5f;
            float closeRatio = 1.0f - openRatio;
            int openDist = 3;
            teethActor.addAction(Actions.sequence((Action)Actions.moveBy(0.0f, -mul * openDist, this.getImpactDuration() * openRatio, Interpolation.linear), (Action)Actions.moveBy(0.0f, mul * (openDist + moveAmount), this.getImpactDuration() * closeRatio, Interpolation.pow5In), (Action)Actions.run(new Runnable(){

                @Override
                public void run() {
                    BiteActor.this.chomp();
                }
            }), (Action)Actions.parallel((Action)Actions.fadeOut(this.getExtraDuration()), (Action)Actions.moveBy(0.0f, (float)(-mul * moveAmount) * 0.7f, this.getExtraDuration())), (Action)Actions.removeActor()));
        }
    }

    private int getShieldedBiteOffset() {
        return Main.isPortrait() ? 10 : 21;
    }

    private void chomp() {
        if (this.shielded) {
            Sounds.playSound(Sounds.clangs);
            return;
        }
        switch (this.size) {
            case small: {
                Sounds.playSound(Sounds.bitesmall);
                break;
            }
            case reg: {
                Sounds.playSound(Sounds.biteReg);
                break;
            }
            case big: {
                Sounds.playSound(Sounds.biteBig);
                break;
            }
            case huge: {
                Sounds.playSound(Sounds.biteHuge);
            }
        }
    }

    @Override
    protected float getImpactDuration() {
        return 0.35f;
    }

    @Override
    protected float getExtraDuration() {
        return 0.3f;
    }
}

