/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.cross;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;

public class CrossActor
extends CombatEffectActor {
    Ent target;

    public CrossActor(Ent target) {
        this.target = target;
        this.setSize(target.getEntPanel().getWidth(), target.getEntPanel().getHeight());
    }

    @Override
    protected void start(FightLog fightLog) {
        this.target.getEntPanel().addActor(this);
        this.setScale(0.0f, 0.0f);
        this.setColor(Colours.red);
        this.addAction(Actions.sequence(Actions.run(new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.slice);
            }
        }), Actions.scaleTo(1.0f, 0.0f, this.getImpactDuration() / 2.0f, Interpolation.pow2Out), Actions.run(new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.slice);
            }
        }), Actions.scaleTo(1.0f, 1.0f, this.getImpactDuration() / 2.0f, Interpolation.pow2Out), Actions.fadeOut(this.getExtraDuration()), Actions.removeActor()));
    }

    @Override
    protected float getImpactDuration() {
        return 0.5f;
    }

    @Override
    protected float getExtraDuration() {
        return 0.12f;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(this.getColor());
        float line1 = this.getScaleX();
        float line2 = this.getScaleY();
        Draw.drawLine(batch, this.getX(), this.getY() + this.getHeight(), this.getX() + this.getWidth() * line2, this.getY() + this.getHeight() * (1.0f - line2), 1.5f);
        Draw.drawLine(batch, this.getX() + this.getWidth(), this.getY() + this.getHeight(), this.getX() + this.getWidth() * (1.0f - line1), this.getY() + this.getHeight() * (1.0f - line1), 1.5f);
        super.draw(batch, parentAlpha);
    }
}

