/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.endTurn;

import com.badlogic.gdx.math.Interpolation;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectController;
import com.tann.dice.screens.dungeon.panels.entPanel.heartsHolder.HPHolder;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ui.Flasher;
import java.util.List;

public class EndTurnController
extends CombatEffectController {
    FightLog fightLog = DungeonScreen.get().getFightLog();

    @Override
    protected void start() {
        Flasher f;
        HPHolder hh;
        if (this.isPoison()) {
            Sounds.playSound(Sounds.poisonImpact);
        }
        if (this.isRegen()) {
            Sounds.playSound(Sounds.regenActivate);
        }
        for (EntState es : this.fightLog.getSnapshot(FightLog.Temporality.Future).getRegened()) {
            hh = es.getEnt().getEntPanel().HPHolder;
            f = new Flasher(hh, Colours.withAlpha(Colours.red, 0.4f), this.getExtraDuration(), Interpolation.linear);
            hh.addActor(f);
        }
        for (EntState es : this.fightLog.getSnapshot(FightLog.Temporality.Future).getPoisoned()) {
            hh = es.getEnt().getEntPanel().HPHolder;
            f = new Flasher(hh, Colours.withAlpha(Colours.green, 0.4f), this.getExtraDuration(), Interpolation.linear);
            hh.addActor(f);
        }
    }

    @Override
    protected float getImpactDuration() {
        return 0.0f;
    }

    @Override
    protected float getExtraDuration() {
        float base = this.gbed();
        return base * (OptionLib.FAST_ENEMY_TURNS.c() ? 0.3f : 1.0f);
    }

    private float gbed() {
        if (this.hasMonster(MonsterTypeLib.byName("Rotten"))) {
            return 1.1f;
        }
        if (this.hasMonster(MonsterTypeLib.byName("Bell"))) {
            return 0.8f;
        }
        if (this.isRegen() || this.isPoison()) {
            return 0.65f;
        }
        return 0.0f;
    }

    private boolean hasMonster(MonsterType type) {
        List<EntState> states = this.fightLog.getSnapshot(FightLog.Temporality.Present).getStates(false, false);
        for (EntState es : states) {
            if (es.getEnt().getEntType() != type) continue;
            return true;
        }
        return false;
    }

    private boolean isPoison() {
        return this.fightLog.getSnapshot(FightLog.Temporality.Future).getPoisoned().size() > 0;
    }

    private boolean isRegen() {
        return this.fightLog.getSnapshot(FightLog.Temporality.Future).getRegened().size() > 0;
    }
}

