/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.lightning;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectController;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.LightningActor;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;

public class LightningEffectController
extends CombatEffectController {
    Ent source;
    List<Ent> targets;
    final int NUM_LINES;
    static final float SPAWN_TIME = 0.2f;
    static final float FADE_TIME = 0.3f;
    static final float VARIANCE = 6.0f;
    static final float SEG_LENGTH = 20.0f;

    public LightningEffectController(Ent source, List<Ent> targets, int num_lines) {
        this.source = source;
        this.targets = targets;
        this.NUM_LINES = num_lines;
    }

    @Override
    protected void start() {
        Sounds.playSound(Sounds.lightning);
        ArrayList<Ent> chain = new ArrayList<Ent>(this.targets);
        chain.add(0, this.source);
        Vector2 end = null;
        for (int chainIndex = 0; chainIndex < chain.size() - 1; ++chainIndex) {
            Vector2 start;
            Ent zapSource = (Ent)chain.get(chainIndex);
            Ent zapTarget = (Ent)chain.get(chainIndex + 1);
            if (end == null) {
                if (zapSource != null) {
                    EntPanel sourcePan = zapSource.getEntPanel();
                    start = Tann.getAbsoluteCoordinates(sourcePan).add(sourcePan.getWidth() - 15.0f, sourcePan.getHeight() / 2.0f).cpy();
                } else {
                    start = new Vector2(0.0f, Main.height / 2);
                }
            } else {
                start = end;
            }
            EntPanel targetPan = zapTarget.getEntPanel();
            end = Tann.getAbsoluteCoordinates(targetPan).add(15.0f, targetPan.getHeight() / 2.0f).cpy();
            for (int i = 0; i < this.NUM_LINES; ++i) {
                LightningActor la = new LightningActor(start.x, start.y, end.x, end.y, 20.0f, 6.0f);
                DungeonScreen.get().addActor(la);
                la.setColor(Colours.withAlpha(Tann.half() ? Colours.light : Colours.blue, 0.0f));
                float delayAmount = (float)i / (float)this.NUM_LINES * 0.2f;
                la.addAction(Actions.delay(delayAmount, Actions.sequence((Action)Actions.alpha(1.0f), Tann.fadeAndRemove(0.3f))));
            }
        }
    }

    @Override
    protected float getImpactDuration() {
        return 0.1f;
    }

    @Override
    protected float getExtraDuration() {
        return 0.4f;
    }
}

