/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.simpleStrike;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Tann;

public class SimpleStrike
extends CombatEffectActor {
    public final float SWORD_IMPACT_TIME;
    public final float SWORD_STICK_TIME;
    public final float SWORD_RETRACT_TIME;
    boolean flipped;
    TextureRegion image;
    EntPanel targetPanel;
    Ent target;
    int damage;
    boolean blocked;
    String[] sounds;

    public SimpleStrike(Ent target, int damage, TextureRegion image, float impactTime, float stickTime, float retractTime, String[] sounds) {
        this.target = target;
        this.damage = damage;
        this.image = image;
        this.SWORD_IMPACT_TIME = impactTime;
        this.SWORD_STICK_TIME = stickTime;
        this.SWORD_RETRACT_TIME = retractTime;
        this.sounds = sounds;
        this.setSize(image.getRegionWidth(), image.getRegionHeight());
    }

    public SimpleStrike(Ent target, int damage, TextureRegion image, float impactTime, float stickTime, float retractTime) {
        this(target, damage, image, impactTime, stickTime, retractTime, Sounds.punches);
    }

    @Override
    public void start(FightLog fightLog) {
        this.flipped = this.target.isPlayer();
        this.targetPanel = this.target.getEntPanel();
        int flipMult = this.flipped ? -1 : 1;
        Vector2 panelPos = Tann.getAbsoluteCoordinates(this.targetPanel);
        panelPos.y += this.targetPanel.getPreferredY() - this.targetPanel.getY();
        EntState state = this.target.getState(FightLog.Temporality.Visual);
        int shields = state.getShields();
        int startDist = 30;
        int endDist = -2;
        if (shields >= this.damage) {
            this.blocked = true;
            endDist = 10;
        }
        if (this.flipped) {
            this.setPosition(panelPos.x + this.targetPanel.getWidth() + (float)startDist, panelPos.y + this.targetPanel.getHeight() / 2.0f - this.getHeight() / 2.0f);
        } else {
            this.setPosition(panelPos.x - this.getWidth() - (float)startDist, panelPos.y + this.targetPanel.getHeight() / 2.0f - this.getHeight() / 2.0f);
        }
        SequenceAction swordAttackSequence = Actions.sequence((Action)Actions.moveBy((startDist - endDist) * flipMult, 0.0f, this.SWORD_IMPACT_TIME, Interpolation.swingIn), (Action)Actions.run(new Runnable(){

            @Override
            public void run() {
                SimpleStrike.this.impact();
            }
        }), (Action)Actions.delay(this.SWORD_STICK_TIME), (Action)Actions.parallel((Action)Actions.moveBy(this.SWORD_RETRACT_TIME == 0.0f ? 0.0f : (float)(-startDist / 3 * flipMult), 0.0f, this.SWORD_RETRACT_TIME, Interpolation.linear), (Action)Actions.fadeOut(this.SWORD_RETRACT_TIME)), (Action)Actions.removeActor());
        Sounds.playSoundDelayed(Sounds.slash, 1.0f, 1.0f, this.SWORD_IMPACT_TIME * 0.7f);
        this.addAction(swordAttackSequence);
        DungeonScreen.get().addActor(this);
    }

    protected void impact() {
        Sounds.playSound(this.blocked ? Sounds.clangs : this.sounds);
    }

    @Override
    protected float getImpactDuration() {
        return this.SWORD_IMPACT_TIME;
    }

    @Override
    protected float getExtraDuration() {
        return this.SWORD_STICK_TIME + this.SWORD_RETRACT_TIME;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        batch.setColor(1.0f, 1.0f, 1.0f, this.getColor().a);
        Draw.drawScaled(batch, this.image, (float)((int)(this.getX() + (this.flipped ? this.getWidth() : 0.0f))), (float)((int)this.getY()), this.flipped ? -1.0f : 1.0f, 1.0f);
    }
}

