/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.Trigger;
import com.tann.dice.screens.dungeon.panels.book.page.stuffPage.APIUtils;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ItemPanel;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.CopyButtonHolder;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextMarquee;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class ConcisePanel
extends Group
implements CopyButtonHolder {
    protected final Choosable choosable;
    protected final boolean big;
    public static final int MARGIN = 3;
    public static final int MULTI_ACTOR_GAP = 7;
    public static final int MAX_TEXT_WIDTH = 95;
    public static final int TEXT_HEIGHT_CUTOFF = 21;
    Vector2 copyOffset = new Vector2();

    public ConcisePanel(Choosable choosable, boolean big) {
        this.setTransform(false);
        this.choosable = choosable;
        this.big = big;
        this.layout();
        if (this.canBeBigger()) {
            this.addListener(new TannListener(){

                @Override
                public boolean info(int button, float x, float y) {
                    Sounds.playSound(Sounds.pip);
                    ConcisePanel cp = ConcisePanel.this.makeCopy(true);
                    Main.getCurrentScreen().push(cp, 0.7f);
                    Tann.center(cp);
                    return true;
                }

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    return false;
                }
            });
        }
    }

    private boolean canBeBigger() {
        if (this.big) {
            return false;
        }
        boolean showingHalf = this.getFullDescription() != null && this.getFullDescription().length() > 0 && this.getMiddleActors(false).size() > 0;
        boolean hasKeywords = this.hasKeywords();
        return showingHalf || hasKeywords;
    }

    protected abstract boolean hasKeywords();

    protected abstract ConcisePanel makeCopy(boolean var1);

    private Actor makeDescriptionActor(int width) {
        String full = this.getFullDescription();
        if (full == null || full.isEmpty()) {
            return null;
        }
        Pixl p = new Pixl(0);
        TextWriter tw = new TextWriter("[text]" + this.getFullDescription(), this.getDescriptionImage(), width);
        p.actor(tw);
        return p.pix(8);
    }

    protected TextureRegion getDescriptionImage() {
        return null;
    }

    protected abstract String getFullDescription();

    private void layout() {
        Group done;
        Actor extraHackyBottom;
        Actor descActor;
        Actor descActor2;
        int SINGLE_ROW_MIDDLE_MAX_WIDTH = (int)((float)Main.width * 0.8f);
        Actor title = this.makeTitle(80);
        int fakeTitleWidth = (int)(title.getWidth() + 6.0f);
        List<Actor> extraTopActors = this.getExtraTopActors();
        int topWidth = fakeTitleWidth - extraTopActors.size();
        for (Actor a : extraTopActors) {
            topWidth = (int)((float)topWidth + a.getWidth());
        }
        List<Actor> middleActors = this.getMiddleActors(this.big);
        int triggerWidth = 0;
        boolean addedAnyActors = middleActors.size() > 0;
        int totalMiddleWidth = 6;
        for (int i = 0; i < middleActors.size(); ++i) {
            Actor a = middleActors.get(i);
            addedAnyActors = true;
            triggerWidth = (int)Math.max((float)triggerWidth, a.getWidth() + 6.0f);
            totalMiddleWidth = (int)((float)totalMiddleWidth + a.getWidth());
            if (i <= 0) continue;
            totalMiddleWidth += 7;
        }
        if (totalMiddleWidth < SINGLE_ROW_MIDDLE_MAX_WIDTH) {
            triggerWidth = Math.max(triggerWidth, totalMiddleWidth);
        }
        int combinedWidth = Math.max(topWidth, triggerWidth);
        int texWidth = 0;
        if ((this.big || !addedAnyActors) && (descActor2 = this.makeDescriptionActor(combinedWidth)) != null) {
            float prevHeight = (int)descActor2.getHeight();
            for (int tmpTexWidth = texWidth = (int)Math.max((float)texWidth, descActor2.getWidth()); descActor2.getHeight() > 21.0f && tmpTexWidth < 95; ++tmpTexWidth) {
                descActor2 = this.makeDescriptionActor(tmpTexWidth);
                boolean shorter = descActor2.getHeight() < prevHeight;
                prevHeight = descActor2.getHeight();
                if (!shorter) continue;
                texWidth = tmpTexWidth;
            }
        }
        combinedWidth = Math.max(combinedWidth, texWidth + 6);
        texWidth = combinedWidth - 6;
        int titleWidth = combinedWidth;
        for (Actor a : extraTopActors) {
            titleWidth = (int)((float)titleWidth - a.getWidth());
            ++titleWidth;
        }
        int titleBorder = 1;
        Group title2 = new Pixl(1, 2).forceWidth(titleWidth).border(Colours.dark, this.getBorderColour(), titleBorder).actor(this.makeTitle(titleWidth - titleBorder * 2 - 2)).pix();
        Pixl topPixl = new Pixl(0);
        for (Actor a : extraTopActors) {
            topPixl.actor(a).gap(-1);
        }
        topPixl.actor(title2);
        Group top = topPixl.pix(2);
        Pixl contents = new Pixl(0, 3);
        if (addedAnyActors) {
            Pixl iconographyPix = new Pixl(7);
            for (int i = 0; i < middleActors.size(); ++i) {
                Actor a = middleActors.get(i);
                iconographyPix.actor(a, combinedWidth + 7);
            }
            Group iconography = iconographyPix.pix();
            boolean overridden = false;
            if (this instanceof ItemPanel) {
                int topLeftSize = 16;
                int weirdGap = (int)((top.getWidth() - 16.0f - iconography.getWidth()) / 2.0f);
                if (weirdGap > 1) {
                    contents.row(-7).gap(16 + weirdGap - 3).actor(iconography).gap(weirdGap - 3);
                    overridden = true;
                }
            }
            if (!overridden) {
                contents.actor(iconography);
            }
        }
        if ((this.big || !addedAnyActors) && (descActor = this.makeDescriptionActor(texWidth)) != null) {
            if (addedAnyActors) {
                contents.row(3);
            } else {
                contents.row(-1);
            }
            contents.actor(descActor);
        }
        if ((extraHackyBottom = this.getHackyBottomActor((int)top.getWidth())) != null) {
            contents.row(3).actor(extraHackyBottom);
        }
        Group mainBody = new Pixl(0).border(this.getBorderColour()).actor(top).row().actor(contents).pix();
        if (this.big && this.getReferencedKeywords().size() > 0) {
            Pixl p = new Pixl(0);
            p.actor(mainBody);
            p.row(-1);
            for (Keyword k : this.getReferencedKeywords()) {
                Actor a = KUtils.makeActor(k, this.getSingleEffOrNull(k));
                p.actor(a);
                p.row(-1);
            }
            done = p.pix();
        } else {
            done = mainBody;
        }
        if (done.getHeight() > (float)Main.height) {
            done = Tann.makeScrollpane(done);
        }
        Tann.become(this, done);
        this.copyOffset.set((int)((this.getWidth() - mainBody.getWidth()) / 2.0f), (int)(this.getHeight() - mainBody.getHeight()));
        if (OptionLib.shouldShowCopy()) {
            this.addCopyButton();
        }
    }

    @Override
    public void addCopyButton() {
        APIUtils.addCopyButton(this, this.choosable.getName(), null, this.copyOffset);
    }

    protected abstract Eff getSingleEffOrNull(Keyword var1);

    protected abstract Color getBorderColour();

    protected abstract List<Keyword> getReferencedKeywords();

    protected abstract List<Actor> getMiddleActors(boolean var1);

    protected abstract String getTitle();

    public static Actor makeTitle(String text, Color col, int maxWidth) {
        return TextMarquee.marqueeOrDots(text, col, maxWidth);
    }

    private Actor makeTitle(int maxWidth) {
        return ConcisePanel.makeTitle(this.getTitle(), this.getBorderColour(), maxWidth);
    }

    protected abstract List<Actor> getExtraTopActors();

    public static List<Actor> getMiddleActors(List<Trigger> triggers, boolean big) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        int numSuccess = 0;
        for (Trigger pt : triggers) {
            Actor a;
            if (pt.skipEquipImage() || (a = pt.makePanelActor(big)) == null) continue;
            if (!Trigger.notAlone(a)) {
                ++numSuccess;
            }
            result.add(a);
        }
        if (numSuccess == 0) {
            return new ArrayList<Actor>();
        }
        return result;
    }

    protected Actor getHackyBottomActor(int width) {
        return null;
    }
}

