/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.popup;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.progress.chievo.Achievement;
import com.tann.dice.gameplay.progress.chievo.AchievementCompletionListener;
import com.tann.dice.screens.dungeon.panels.book.page.ledgerPage.AchievementIconView;
import com.tann.dice.screens.dungeon.panels.popup.AchievementPopup;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.action.PixAction;
import java.util.ArrayList;
import java.util.List;

public class PopupHolder
extends Group
implements AchievementCompletionListener {
    private static final float DOWN_TIME = 0.3f;
    private static final float DELAY = 5.0f;
    private static final float UP_TIME = 0.3f;
    private static final Interpolation terp = Interpolation.pow2Out;
    List<Actor> popups = new ArrayList<Actor>();
    public static final String ALWAYS_ON_TOP = "alwaysontop";

    public PopupHolder() {
        this.setName(ALWAYS_ON_TOP);
        this.setTransform(false);
    }

    public void addPopup(Actor popup) {
        this.toFront();
        this.addActor(popup);
        int y = 0;
        for (Actor a : this.popups) {
            y = (int)((float)y + (a.getHeight() - 1.0f));
        }
        popup.setY(y);
        popup.setX(this.getWidth() - popup.getWidth());
        this.popups.add(popup);
        y = (int)((float)y + popup.getHeight());
        this.clearActions();
        this.addAction(Actions.sequence(PixAction.moveTo((int)this.getX(), Main.height - y, 0.3f, terp), (Action)Actions.delay(5.0f), PixAction.moveTo((int)this.getX(), Main.height, 0.3f, terp), (Action)Actions.run(this.makeClearRunnable())));
    }

    public void addText(String text) {
        Pixl p = new Pixl(3, 1).border(Colours.grey);
        TextWriter tw = new TextWriter(text);
        p.actor(tw).pix();
        this.addPopup(p.pix());
    }

    public void addAchievement(final Achievement achievement) {
        Group ap = AchievementPopup.make(achievement);
        ap.addListener(new TannListener(){

            @Override
            public boolean info(int button, float x, float y) {
                Sounds.playSound(Sounds.pip);
                Actor e = AchievementIconView.makeAchievementDetail(achievement);
                Main.getCurrentScreen().center(e);
                Main.getCurrentScreen().push(e, true, true, true, 0.4f);
                return false;
            }
        });
        this.addPopup(ap);
    }

    private Runnable makeClearRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                PopupHolder.this.popups.clear();
                PopupHolder.this.clearChildren();
            }
        };
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @Override
    public void onUnlock(Achievement a) {
        this.addAchievement(a);
    }
}

