/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.statics.sound.music;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.tann.dice.test.TestFiles;
import java.util.ArrayList;
import java.util.List;

public class MusicDebugUtils {
    public static void printMusic() {
        String rootPath = "C:/code/games/Dicegeon/android/assets/music/";
        FileHandle root = Gdx.files.absolute(rootPath);
        List<FileHandle> children = TestFiles.getAll(root);
        System.out.println("private final static List<TP<String, Float>> musicData = Arrays.asList(");
        for (int i = 0; i < children.size(); ++i) {
            FileHandle child = children.get(i);
            if (child.path().contains("debug")) continue;
            String fileName = child.path().split(rootPath)[1];
            Music m = Gdx.audio.newMusic(child);
            float length = MusicDebugUtils.analyseLength(m);
            boolean lastSong = i == children.size() - 1;
            System.out.println("new TP<>(\"" + fileName + "\", " + length + "f)" + (lastSong ? "" : ","));
        }
        System.out.println(");");
    }

    public static List<String> getMusicPaths() {
        String rootPath = "C:/code/games/Dicegeon/android/assets/music/";
        FileHandle root = Gdx.files.absolute(rootPath);
        List<FileHandle> children = TestFiles.getAll(root);
        ArrayList<String> result = new ArrayList<String>();
        System.out.println("private final static List<TP<String, Float>> musicData = Arrays.asList(");
        for (int i = 0; i < children.size(); ++i) {
            FileHandle child = children.get(i);
            if (child.path().contains("debug")) continue;
            String fileName = child.path().split(rootPath)[1];
            result.add(fileName);
        }
        return result;
    }

    private static float analyseLength(Music music) {
        float MAX = 300.0f;
        int iterations = 22;
        float tooHigh = 300.0f;
        float tooLow = 0.0f;
        for (int i = 0; i < 22; ++i) {
            boolean after;
            float check = tooLow + (tooHigh - tooLow) / 2.0f;
            music.setPosition(check);
            boolean bl = after = music.getPosition() == 0.0f;
            if (after) {
                tooHigh = check;
                music.play();
                continue;
            }
            tooLow = check;
        }
        music.stop();
        return tooLow + (tooHigh - tooLow) / 2.0f;
    }
}

