/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.statics.sound.music;

import com.badlogic.gdx.audio.Music;
import com.tann.dice.Main;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.statics.sound.music.MusicData;
import com.tann.dice.util.TannLog;

public class MusicFader {
    private final float FADE_DURATION;
    private final float FADE_SAFETY_BUFFER = 0.05f;
    private final float MIN_VOLUME = 0.0f;
    public final Music m;
    boolean trackNeedsFade;
    float timeElapsed;
    float fadeTimer;
    float startVolume;
    float targetVolume;
    float stopLoopingAt = -1.0f;
    float startFadingOutAt = -1.0f;
    final int actualLoops;
    public final MusicData md;
    boolean stopped;

    public MusicFader(MusicData md, Music m) {
        this.md = md;
        this.trackNeedsFade = md.loop > 1;
        this.actualLoops = OptionLib.affectLoops(MusicFader.trackSpecificLoop(md) ? md.loop : 1);
        this.FADE_DURATION = this.trackNeedsFade ? 1.2f * md.fadeDurationMultiplier : 0.08f;
        this.stopLoopingAt = md.seconds * ((float)this.actualLoops - 0.5f);
        this.startFadingOutAt = md.seconds * (float)this.actualLoops - this.FADE_DURATION - 0.05f - md.extraFade;
        this.startVolume = 0.0f;
        this.targetVolume = 1.0f;
        m.setVolume(0.0f);
        this.m = m;
        m.setLooping(this.actualLoops > 1);
    }

    private static boolean forceLoop() {
        return false;
    }

    private static boolean trackSpecificLoop(MusicData md) {
        return md.loop > 1;
    }

    public void play() {
        if (this.stopped) {
            TannLog.error("trying to play stopped file");
            return;
        }
        this.m.play();
    }

    public boolean act(float delta) {
        if (!this.stopped && !this.m.isPlaying() && this.startFadingOutAt != -1.0f) {
            this.stop();
            TannLog.error("Song stopped early, potential issue with song metadata: " + this.md);
        }
        if (this.stopped) {
            return true;
        }
        this.timeElapsed += delta;
        this.fadeTimer += delta;
        if (this.getValue() == 0.0f && this.targetVolume == 0.0f) {
            this.m.setVolume(0.0f);
            this.stop();
            return true;
        }
        this.m.setLooping(MusicFader.forceLoop() || this.actualLoops > 1 && this.timeElapsed < this.stopLoopingAt);
        if (this.probablySwitchedAwayFromIninite() && this.targetVolume != 0.0f || this.startFadingOutAt != -1.0f && this.timeElapsed > this.startFadingOutAt) {
            this.startFadingOutAt = -1.0f;
            this.fadeOut();
        }
        this.m.setVolume(this.getVolume());
        return false;
    }

    private boolean probablySwitchedAwayFromIninite() {
        return OptionLib.affectLoops(1) < 50 && this.timeElapsed > this.md.seconds * 2.0f;
    }

    private float getVolume() {
        return Math.max(0.0f, this.getValue() * Main.getSettings().getVolumeMusic());
    }

    private float getValue() {
        float ratio = this.fadeTimer / this.FADE_DURATION;
        ratio = Math.max(0.0f, Math.min(1.0f, ratio));
        return this.startVolume + (this.targetVolume - this.startVolume) * ratio;
    }

    public void stop() {
        if (this.stopped) {
            TannLog.error("Trying to stop again");
            return;
        }
        this.m.setVolume(0.0f);
        this.m.setLooping(false);
        this.m.stop();
        this.stopped = true;
    }

    public void fadeOut() {
        System.out.println("fading out");
        if (this.stopped) {
            return;
        }
        this.fadeTo(0.0f);
    }

    public void fadeIn() {
        this.fadeTo(1.0f);
    }

    private void fadeTo(float inTarget) {
        if (this.stopped) {
            TannLog.error("Trying to fade to " + inTarget + " when stopped");
            return;
        }
        this.startVolume = this.getValue();
        this.targetVolume = inTarget;
        this.fadeTimer = 0.0f;
    }

    public boolean isFinished() {
        if (this.stopped || !this.m.isPlaying()) {
            return true;
        }
        if (MusicFader.forceLoop()) {
            return false;
        }
        return false;
    }

    public void skipForwards() {
        float amt = this.md.seconds / 8.0f;
        this.m.setPosition(this.m.getPosition() + amt);
        this.timeElapsed += amt;
        this.fadeTimer += amt;
    }
}

