/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.lang;

import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.progress.chievo.unlock.Feature;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.util.Tann;
import com.tann.dice.util.ui.TextWriter;

public class Words {
    public static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    public static final String DOUBLE_ALPHABET = "abcdefghijklmnopqrstuvwxyz" + "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    public static final String ALL_EFF = "all damage and enemy effects";
    private static final int MAX_MANA_STRING = 3;
    public static String[] numerals = new String[]{"-", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII", "XVIII", "XIX", "XX", "XXI", "XXII", "XXIII", "XXIV", "XXV", "XXVI", "XXVII", "XXVIII", "XXIX", "XXX", "XXXI", "XXXII", "XXXIII", "XXXIV", "XXXV", "XXXVI", "XXXVII", "XXXVIII", "XXXIX", "XL", "XLI", "XLII", "XLIII", "XLIV", "XLV", "XLVI", "XLVII", "XLVIII", "XLIX", "L"};

    public static String entName(Eff eff, Boolean plural) {
        return Words.entName(null, eff.isFriendly(), plural);
    }

    public static String entName(boolean player, Boolean plural) {
        return Words.entName(null, player, plural);
    }

    public static String entName(Boolean playerSource, boolean ally, Boolean plural) {
        if (playerSource != null) {
            // empty if block
        }
        if (ally) {
            if (plural == null) {
                return "ally";
            }
            if (plural.booleanValue()) {
                return "allies";
            }
            return "an ally";
        }
        if (plural == null) {
            return "enemy";
        }
        if (plural.booleanValue()) {
            return "enemies";
        }
        return "an enemy";
    }

    public static String ordinal(int i) {
        if (i == 0) {
            return Words.ordinalLong(i);
        }
        return Words.ordinalShort(i);
    }

    public static String ordinalLong(int i) {
        if (i < 0) {
            return "negative-" + Words.ordinalLong(Math.abs(i));
        }
        switch (i) {
            case 0: {
                return "zeroth";
            }
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
            case 4: {
                return "fourth";
            }
            case 5: {
                return "fifth";
            }
            case 6: {
                return "sixth";
            }
            case 7: {
                return "seventh";
            }
            case 8: {
                return "eighth";
            }
            case 9: {
                return "ninth";
            }
            case 10: {
                return "tenth";
            }
        }
        return i + "th";
    }

    public static String ordinalShort(Integer i) {
        if (i < 0) {
            return "negative-" + Words.ordinalShort(Math.abs(i));
        }
        switch (i) {
            case 0: {
                return "0th";
            }
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
            case 3: {
                return "3rd";
            }
            case 4: {
                return "4th";
            }
            case 5: {
                return "5th";
            }
            case 6: {
                return "6th";
            }
            case 7: {
                return "7th";
            }
            case 8: {
                return "8th";
            }
            case 9: {
                return "9th";
            }
            case 10: {
                return "10th";
            }
        }
        return i + "th";
    }

    public static String nTimes(int n) {
        switch (n) {
            case 0: {
                return "never";
            }
            case 1: {
                return "once";
            }
            case 2: {
                return "twice";
            }
            case 3: {
                return "thrice";
            }
        }
        return n + " times";
    }

    public static String multiple(int value) {
        switch (value) {
            case 2: {
                return "double";
            }
            case 3: {
                return "triple";
            }
            case 4: {
                return "quadruple";
            }
            case 5: {
                return "quintuple";
            }
        }
        return "x" + value;
    }

    public static String singular(String name) {
        if (name == null) {
            return "!!null plural!!";
        }
        if (name.length() == 0) {
            return "!!0-length plural!!";
        }
        return Words.isVowel(TextWriter.stripTags(name).charAt(0)) ? "an " + name : "a " + name;
    }

    public static String fullPlural(String name, int amt) {
        if (amt == 1) {
            return Words.singular(name);
        }
        return amt + " " + Words.plural(name, amt);
    }

    private static boolean isVowel(char charAt) {
        switch (charAt) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': 
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    public static String manaString(boolean picture) {
        if (picture) {
            return "[white][mana][cu]";
        }
        return "mana";
    }

    public static String manaString() {
        return Words.manaString(false);
    }

    public static String manaString(int amt) {
        return Words.manaString(amt, false);
    }

    public static String manaString(int amt, boolean picture) {
        if (amt < 0) {
            return "[pink]" + amt + "[cu][nbp][nbp][white][mana][cu]??";
        }
        if (amt == 0) {
            return "0 " + Words.manaString(picture);
        }
        if (amt > 3 || !picture) {
            return amt + " " + Words.manaString(picture);
        }
        return "[white]" + Tann.repeat(Words.manaString(true), "[nbp][nbp]", amt) + "[cu]";
    }

    public static String plusString(int bonus) {
        return Words.plusString(bonus >= 0);
    }

    public static String plusString(boolean positive) {
        return positive ? "[plus]" : "[purple][minus]";
    }

    public static String getMaybeInfinityString(int i) {
        if (i == 999) {
            return "\u221e";
        }
        return "" + i;
    }

    public static String plural(String word) {
        return Words.plural(word, true);
    }

    public static String plural(String word, int value) {
        return Words.plural(word, Math.abs(value) != 1);
    }

    public static String plural(String word, boolean plural) {
        if (!plural) {
            return word;
        }
        switch (word) {
            case "this": {
                return "these";
            }
            case "is": {
                return "are";
            }
            case "does": {
                return "do";
            }
        }
        if (word.endsWith("o")) {
            return word + "es";
        }
        if (word.endsWith("lf")) {
            return word.substring(0, word.length() - 1) + "ves";
        }
        if (word.endsWith("s") || word.endsWith("z")) {
            return word;
        }
        if (word.endsWith("ty")) {
            return word.substring(0, word.length() - 1) + "ies";
        }
        return word + "s";
    }

    public static String getTierString(int tier) {
        return Words.getTierString(tier, false);
    }

    public static String getTierString(int tier, boolean includeColour) {
        String result = "";
        if (includeColour) {
            result = tier > 0 ? "[green]" : (tier < 0 ? "[purple]" : "[grey]");
        }
        boolean roman = OptionLib.ROMAN_MODE.c();
        int maybeAbs = includeColour ? Math.abs(tier) : tier;
        String character = roman ? Words.getRomanNumerals(maybeAbs) : "" + maybeAbs;
        return result + character + (result.length() == 0 ? "" : "[cu]");
    }

    public static String getRomanNumerals(int i) {
        if (i < 0 && Math.abs(i) < numerals.length) {
            return "-" + numerals[Math.abs(i)];
        }
        if (i < numerals.length) {
            return numerals[i];
        }
        return "???";
    }

    public static boolean startsWithVowel(String str) {
        return "aeiouAEIOU".indexOf(str.charAt(0)) != -1;
    }

    public static String capitaliseFirst(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String capitaliseWords(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder converted = new StringBuilder();
        boolean convertNext = true;
        for (char ch : text.toCharArray()) {
            if (Character.isSpaceChar(ch)) {
                convertNext = true;
            } else if (convertNext) {
                ch = Character.toTitleCase(ch);
                convertNext = false;
            } else {
                ch = Character.toLowerCase(ch);
            }
            converted.append(ch);
        }
        return converted.toString();
    }

    public static String describePipDelta(int bonus) {
        return Tann.delta(bonus) + " " + Words.plural("pip", bonus);
    }

    public static String aOrAn(String str) {
        return (Words.startsWithVowel(str) ? "an " : "a ") + str;
    }

    public static String spabKeyword(boolean plural) {
        return Words.spab(plural, false);
    }

    public static String spab(boolean plural) {
        return Words.spab(plural, UnUtil.isLocked(Feature.TACTICS));
    }

    private static String spab(boolean plural, boolean locked) {
        return Words.plural("ability", plural);
    }

    public static String capitalsOnly(String s) {
        return s.replaceAll("[a-z]", "");
    }
}

