/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptJavaMonitor;
import com.ibm.dtfj.phd.PHDCorruptJavaThread;
import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.PHDImageProcess;
import com.ibm.dtfj.phd.PHDJavaClass;
import com.ibm.dtfj.phd.PHDJavaClassLoader;
import com.ibm.dtfj.phd.PHDJavaHeap;
import com.ibm.dtfj.phd.PHDJavaMethod;
import com.ibm.dtfj.phd.PHDJavaMonitor;
import com.ibm.dtfj.phd.PHDJavaObject;
import com.ibm.dtfj.phd.PHDJavaThread;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import com.ibm.dtfj.phd.parser.PortableHeapDumpListener;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

class PHDJavaRuntime
implements JavaRuntime {
    private final List<PHDJavaHeap> heaps = new ArrayList<PHDJavaHeap>();
    private final LinkedHashMap<JavaObject, PHDJavaClassLoader> loaders = new LinkedHashMap();
    private final LinkedHashMap<JavaThread, JavaThread> threads = new LinkedHashMap();
    private final ArrayList<JavaMonitor> monitors = new ArrayList();
    private final HashMap<Long, JavaClass> classIdCache = new HashMap();
    private final HashMap<String, JavaClass> classNameCache = new HashMap();
    private final HashMap<Long, JavaObject> extraObjectsCache = new HashMap();
    static final String[] arrayTypeName = new String[]{"[Z", "[C", "[F", "[D", "[B", "[S", "[I", "[J"};
    private final JavaClass[] arrayClasses = new JavaClass[arrayTypeName.length];
    private static final long[] NOREFS = new long[0];
    private final ImageAddressSpace space;
    private final JavaRuntime metaJavaRuntime;
    private final PHDImageProcess process;
    private String full_version;
    long minAddress;
    long maxAddress;
    long minClassAddress;
    long maxClassAddress;
    long maxObjClass;
    int maxObjLen;
    int minInstanceSize;
    private long compressAddressBase1;
    private long compressAddressTop1;
    private long compressAddressBase2;
    private int compressIndexBase1;
    private int compressIndexBase2;
    private int compressShift;
    private long nextClsAddr;

    PHDJavaRuntime(ImageInputStream imageInputStream, PHDImage pHDImage, ImageAddressSpace imageAddressSpace, PHDImageProcess pHDImageProcess, JavaRuntime javaRuntime) throws IOException {
        this.space = imageAddressSpace;
        this.process = pHDImageProcess;
        this.metaJavaRuntime = javaRuntime;
        HeapdumpReader heapdumpReader = new HeapdumpReader(imageInputStream, pHDImage);
        this.heaps.add(new PHDJavaHeap(imageInputStream, pHDImage, imageAddressSpace, this));
        PHDJavaClassLoader pHDJavaClassLoader = new PHDJavaClassLoader(imageInputStream, pHDImage, imageAddressSpace, this);
        this.processData(heapdumpReader, pHDImage, pHDJavaClassLoader);
        this.findLoaders(heapdumpReader);
        this.initClassCache();
        this.initMonitors();
        this.initThreads();
    }

    PHDJavaRuntime(File file, PHDImage pHDImage, ImageAddressSpace imageAddressSpace, PHDImageProcess pHDImageProcess, JavaRuntime javaRuntime) throws IOException {
        this.space = imageAddressSpace;
        this.process = pHDImageProcess;
        this.metaJavaRuntime = javaRuntime;
        HeapdumpReader heapdumpReader = new HeapdumpReader(file, pHDImage);
        this.heaps.add(new PHDJavaHeap(file, pHDImage, imageAddressSpace, this));
        PHDJavaClassLoader pHDJavaClassLoader = new PHDJavaClassLoader(file, pHDImage, imageAddressSpace, this);
        this.processData(heapdumpReader, pHDImage, pHDJavaClassLoader);
        this.findLoaders(heapdumpReader);
        this.initClassCache();
        this.initMonitors();
        this.initThreads();
    }

    private void processData(HeapdumpReader heapdumpReader, PHDImage pHDImage, PHDJavaClassLoader pHDJavaClassLoader) throws IOException {
        int n;
        this.full_version = heapdumpReader.full_version();
        heapdumpReader.close();
        heapdumpReader = null;
        this.minAddress = pHDJavaClassLoader.minAddress;
        this.maxAddress = pHDJavaClassLoader.maxAddress;
        this.minClassAddress = pHDJavaClassLoader.minClassAddress;
        this.maxClassAddress = pHDJavaClassLoader.maxClassAddress;
        this.minInstanceSize = pHDJavaClassLoader.minInstanceSize;
        this.maxObjClass = pHDJavaClassLoader.maxObjClass;
        this.maxObjLen = pHDJavaClassLoader.maxObjLen;
        this.compressAddressBase1 = Math.min(this.minAddress, this.minClassAddress);
        this.compressAddressTop1 = Math.min(this.maxAddress, this.maxClassAddress);
        long l = Math.max(this.minAddress, this.maxClassAddress);
        long l2 = Math.max(this.minClassAddress, this.maxAddress);
        this.compressAddressBase2 = Math.min(l, l2);
        for (n = 0; n < 10 && (1L << n & pHDJavaClassLoader.bitsAddress) == 0L; ++n) {
        }
        this.compressShift = n;
        this.compressIndexBase1 = Integer.MIN_VALUE;
        this.compressIndexBase2 = (int)(this.compressAddressTop1 - this.compressAddressBase1 >>> this.compressShift) + this.compressIndexBase1 + 1;
        this.loaders.put(null, pHDJavaClassLoader);
        for (int i = 0; i < arrayTypeName.length; ++i) {
            this.arrayClasses[i] = this.findClass(arrayTypeName[i]);
        }
        this.prepThreads();
        this.prepMonitors();
        this.prepClassLoaders();
    }

    @Override
    public Iterator<JavaMethod> getCompiledMethods() {
        return Collections.emptyList().iterator();
    }

    @Override
    public Iterator<? extends JavaHeap> getHeaps() {
        return this.heaps.iterator();
    }

    @Override
    public Iterator<? extends JavaClassLoader> getJavaClassLoaders() {
        return this.loaders.values().iterator();
    }

    @Override
    public ImagePointer getJavaVM() throws CorruptDataException {
        long l = 0L;
        if (this.metaJavaRuntime != null) {
            l = this.metaJavaRuntime.getJavaVM().getAddress();
        }
        return this.space.getPointer(l);
    }

    @Override
    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, CorruptDataException {
        if (this.metaJavaRuntime != null) {
            return this.metaJavaRuntime.getJavaVMInitArgs();
        }
        throw new DataUnavailable();
    }

    @Override
    public Iterator<JavaMonitor> getMonitors() {
        return this.monitors.iterator();
    }

    @Override
    public Iterator<? extends JavaThread> getThreads() {
        return this.threads.values().iterator();
    }

    @Override
    public Object getTraceBuffer(String string, boolean bl) throws CorruptDataException {
        throw new CorruptDataException(new PHDCorruptData("No trace data", null));
    }

    @Override
    public String getFullVersion() throws CorruptDataException {
        return this.full_version;
    }

    @Override
    public String getVersion() throws CorruptDataException {
        if (this.metaJavaRuntime != null) {
            return this.metaJavaRuntime.getVersion();
        }
        return this.getFullVersion();
    }

    @Override
    public Iterator<JavaReference> getHeapRoots() {
        return Collections.emptyList().iterator();
    }

    @Override
    public JavaObject getObjectAtAddress(ImagePointer imagePointer) throws CorruptDataException, IllegalArgumentException, MemoryAccessException, DataUnavailable {
        JavaObject javaObject;
        long l = imagePointer.getAddress();
        JavaClass javaClass = this.findClass(l);
        if (javaClass != null && (javaObject = javaClass.getObject()) != null && imagePointer.equals(javaObject.getID())) {
            return javaObject;
        }
        javaObject = this.extraObjectsCache.get(l);
        if (javaObject != null) {
            return javaObject;
        }
        for (PHDJavaHeap pHDJavaHeap : this.heaps) {
            try {
                javaObject = pHDJavaHeap.getCachedObjectAtAddress(imagePointer, false);
            }
            catch (IOException iOException) {
                throw new DataUnavailable("The requested object could not be read from the PHD file");
            }
            if (javaObject == null) continue;
            return javaObject;
        }
        javaObject = new PHDJavaObject.Builder(this.heaps.get(0), l, null, 4, -1).build();
        return javaObject;
    }

    private void initClassCache() {
        for (PHDJavaClassLoader pHDJavaClassLoader : this.loaders.values()) {
            Iterator<JavaClass> iterator = pHDJavaClassLoader.getDefinedClasses();
            while (iterator.hasNext()) {
                JavaClass javaClass = iterator.next();
                ImagePointer imagePointer = javaClass.getID();
                if (imagePointer != null) {
                    this.classIdCache.put(imagePointer.getAddress(), javaClass);
                    continue;
                }
                for (long i = 1L; i <= this.lastDummyClassAddr(); ++i) {
                    if (!javaClass.equals(pHDJavaClassLoader.findClass(i))) continue;
                    this.classIdCache.put(i, javaClass);
                }
            }
        }
    }

    JavaClass findClass(long l) {
        JavaClass javaClass = this.classIdCache.isEmpty() ? this.findClassUncached(l) : this.classIdCache.get(l);
        return javaClass;
    }

    private JavaClass findClassUncached(long l) {
        for (PHDJavaClassLoader pHDJavaClassLoader : this.loaders.values()) {
            JavaClass javaClass = pHDJavaClassLoader.findClass(l);
            if (javaClass == null) continue;
            return javaClass;
        }
        return null;
    }

    JavaClass findArrayOfClass(long l) {
        JavaClass javaClass = this.findClass(l);
        if (javaClass != null) {
            try {
                PHDJavaClassLoader pHDJavaClassLoader;
                JavaClass javaClass2;
                JavaClassLoader javaClassLoader = javaClass.getClassLoader();
                if (javaClassLoader instanceof PHDJavaClassLoader && (javaClass2 = (pHDJavaClassLoader = (PHDJavaClassLoader)javaClassLoader).findArrayOfClass(l)) != null) {
                    return javaClass2;
                }
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
        return this.findArrayOfClass2(l);
    }

    private JavaClass findArrayOfClass2(long l) {
        for (PHDJavaClassLoader pHDJavaClassLoader : this.loaders.values()) {
            JavaClass javaClass = pHDJavaClassLoader.findArrayOfClass(l);
            if (javaClass == null) continue;
            return javaClass;
        }
        return null;
    }

    JavaClass findArrayOfType(int n) {
        return this.arrayClasses[n];
    }

    JavaClass arrayOf(long l, long[] lArray, int n) throws CorruptDataException {
        JavaClass javaClass = n == 1 ? (lArray.length > 0 ? this.findClass(lArray[0]) : null) : this.findArrayOfClass(l);
        return javaClass;
    }

    JavaClass arrayOf(long l, LongEnumeration longEnumeration, int n) throws CorruptDataException {
        JavaClass javaClass = n == 1 ? (longEnumeration.hasMoreElements() ? this.findClass(longEnumeration.nextLong()) : null) : this.findArrayOfClass(l);
        return javaClass;
    }

    JavaClass findClass(String string) {
        JavaClass javaClass = this.classNameCache.get(string);
        if (javaClass == null && (javaClass = this.findClassUncached(string)) != null) {
            this.classNameCache.put(string, javaClass);
        }
        return javaClass;
    }

    JavaClass findClassUncached(String string) {
        for (PHDJavaClassLoader pHDJavaClassLoader : this.loaders.values()) {
            try {
                JavaClass javaClass = pHDJavaClassLoader.findClass(string);
                if (javaClass == null) continue;
                return javaClass;
            }
            catch (CorruptDataException corruptDataException) {
            }
        }
        return null;
    }

    Object convertRefs(LongEnumeration longEnumeration, int n) {
        int n2 = longEnumeration.numberOfElements() - n;
        int[] nArray = this.noCompress() ? null : new int[n2];
        long[] lArray = this.noCompress() ? new long[n2] : null;
        for (int i = 0; i < n2; ++i) {
            long l = longEnumeration.nextLong();
            if (nArray != null) {
                nArray[i] = this.compressAddress(l);
                if (this.expandAddress(nArray[i]) == l) continue;
                lArray = new long[nArray.length];
                for (int j = 0; j < i; ++j) {
                    lArray[j] = this.expandAddress(nArray[j]);
                }
                lArray[i] = l;
                nArray = null;
                continue;
            }
            lArray[i] = l;
        }
        if (nArray != null) {
            return nArray;
        }
        return lArray;
    }

    Object convertRefs(long[] lArray, int n) {
        int n2 = lArray.length - n;
        if (n2 <= 0) {
            return lArray;
        }
        int[] nArray = this.noCompress() ? null : new int[n2];
        long[] lArray2 = this.noCompress() ? new long[n2] : null;
        for (int i = 0; i < n2; ++i) {
            long l = lArray[n + i];
            if (nArray != null) {
                nArray[i] = this.compressAddress(l);
                if (this.expandAddress(nArray[i]) == l) continue;
                lArray2 = new long[nArray.length];
                for (int j = 0; j < i; ++j) {
                    lArray2[j] = this.expandAddress(nArray[j]);
                }
                lArray2[i] = l;
                nArray = null;
                continue;
            }
            lArray2[i] = l;
        }
        if (nArray != null) {
            return nArray;
        }
        return lArray2;
    }

    boolean noCompress() {
        return this.compressIndexBase1 == 0;
    }

    int compressAddress(long l) {
        int n = l <= this.compressAddressTop1 ? (int)((l - this.compressAddressBase1 >>> this.compressShift) + (long)this.compressIndexBase1) : (int)((l - this.compressAddressBase2 >>> this.compressShift) + (long)this.compressIndexBase2);
        return n;
    }

    long expandAddress(int n) {
        long l = n < this.compressIndexBase2 ? ((long)n - (long)this.compressIndexBase1 << this.compressShift) + this.compressAddressBase1 : ((long)n - (long)this.compressIndexBase2 << this.compressShift) + this.compressAddressBase2;
        return l;
    }

    boolean is64Bit() {
        return this.process.getPointerSize() == 64;
    }

    int pointerSize() {
        return this.is64Bit() && (this.minInstanceSize == 0 || this.minInstanceSize > 16) ? 8 : 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findLoaders(HeapdumpReader heapdumpReader) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object7;
        Cloneable cloneable;
        Object object8;
        PHDJavaClassLoader pHDJavaClassLoader = this.loaders.get(null);
        JavaClass javaClass = this.findClass("java/lang/Class");
        long l = javaClass == null || javaClass.getID() == null ? 0L : javaClass.getID().getAddress();
        JavaClass javaClass2 = this.findClass("java/lang/ClassLoader");
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        Object object9 = pHDJavaClassLoader.getDefinedClasses();
        while (object9.hasNext()) {
            object8 = object9.next();
            if (object8 instanceof CorruptData) continue;
            try {
                cloneable = new HashSet();
                for (Object object10 = object8; object10 != null && ((HashSet)cloneable).add(object10); object10 = object10.getSuperclass()) {
                    if (!object10.equals(javaClass2) && (object8.getSuperclass() != null || object10.isArray() || !object10.getName().endsWith("ClassLoader")) || (object7 = object8.getID()) == null) continue;
                    hashMap.put(object7.getAddress(), object8);
                }
            }
            catch (CorruptDataException corruptDataException) {
            }
        }
        object9 = new int[1];
        object8 = this.heaps.get(0);
        cloneable = new HashMap();
        int n = heapdumpReader.version() == 4 && heapdumpReader.isJ9() ? 1 : 0;
        try {
            heapdumpReader.parse(new PortableHeapDumpListener((PHDJavaHeap)object8, n, hashMap, l, pHDJavaClassLoader, (int[])object9, javaClass, (HashMap)cloneable){
                final /* synthetic */ PHDJavaHeap val$heap;
                final /* synthetic */ int val$adjustLen;
                final /* synthetic */ HashMap val$classLoaderClasses;
                final /* synthetic */ long val$jlcAddress;
                final /* synthetic */ PHDJavaClassLoader val$boot;
                final /* synthetic */ int[] val$onHeapClasses;
                final /* synthetic */ JavaClass val$jlc;
                final /* synthetic */ HashMap val$classObjects;
                {
                    this.val$heap = pHDJavaHeap;
                    this.val$adjustLen = n;
                    this.val$classLoaderClasses = hashMap;
                    this.val$jlcAddress = l;
                    this.val$boot = pHDJavaClassLoader;
                    this.val$onHeapClasses = nArray;
                    this.val$jlc = javaClass;
                    this.val$classObjects = hashMap2;
                }

                @Override
                public void classDump(long l, long l2, String string, int n, int n2, int n3, LongEnumeration longEnumeration) throws Exception {
                }

                @Override
                public void objectArrayDump(long l, long l2, int n, int n2, LongEnumeration longEnumeration, int n3, long l3) throws Exception {
                    if (PHDJavaRuntime.this.extraObjectsCache.containsKey(l)) {
                        PHDJavaObject pHDJavaObject = new PHDJavaObject.Builder(this.val$heap, l, PHDJavaRuntime.this.arrayOf(l2, longEnumeration, this.val$adjustLen), n, n2).length(n3 - this.val$adjustLen).instanceSize(l3).build();
                        PHDJavaRuntime.this.extraObjectsCache.put(l, pHDJavaObject);
                    }
                }

                @Override
                public void objectDump(long l, long l2, int n, int n2, LongEnumeration longEnumeration, long l3) throws Exception {
                    PHDJavaObject pHDJavaObject;
                    JavaClass javaClass = (JavaClass)this.val$classLoaderClasses.get(l2);
                    if (javaClass != null) {
                        pHDJavaObject = new PHDJavaObject.Builder(this.val$heap, l, javaClass, n, n2).refs(longEnumeration, 0).length(-1).instanceSize(l3).build();
                        PHDJavaClassLoader pHDJavaClassLoader = new PHDJavaClassLoader(pHDJavaObject);
                        PHDJavaRuntime.this.loaders.put(pHDJavaObject, pHDJavaClassLoader);
                    } else if (l2 == this.val$jlcAddress) {
                        if (this.val$boot.findClass(l) == null) {
                            this.val$onHeapClasses[0] = this.val$onHeapClasses[0] + 1;
                        }
                        pHDJavaObject = new PHDJavaObject.Builder(this.val$heap, l, this.val$jlc, n, n2).refs(longEnumeration, 0).length(-1).instanceSize(l3).build();
                        this.val$classObjects.put(l, pHDJavaObject);
                    } else {
                        pHDJavaObject = null;
                    }
                    if (PHDJavaRuntime.this.extraObjectsCache.containsKey(l)) {
                        if (pHDJavaObject == null) {
                            pHDJavaObject = new PHDJavaObject.Builder(this.val$heap, l, PHDJavaRuntime.this.findClass(l2), n, n2).refs(longEnumeration, 0).length(-1).build();
                        }
                        PHDJavaRuntime.this.extraObjectsCache.put(l, pHDJavaObject);
                    }
                }

                @Override
                public void primitiveArrayDump(long l, int n, int n2, int n3, int n4, long l2) throws Exception {
                    if (PHDJavaRuntime.this.extraObjectsCache.containsKey(l)) {
                        PHDJavaObject pHDJavaObject = new PHDJavaObject.Builder(this.val$heap, l, PHDJavaRuntime.this.findArrayOfType(n), n3, n4).refsAsArray(NOREFS, 0).length(n2).instanceSize(l2).build();
                        PHDJavaRuntime.this.extraObjectsCache.put(l, pHDJavaObject);
                    }
                }
            });
        }
        catch (Exception exception) {
        }
        finally {
            heapdumpReader.close();
            heapdumpReader = null;
        }
        object7 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = object9[0] == false;
        Iterator<Object> iterator = pHDJavaClassLoader.getDefinedClasses();
        while (iterator.hasNext()) {
            JavaClass object62 = iterator.next();
            object5 = null;
            object4 = object62.getReferences();
            while (object4.hasNext()) {
                JavaReference javaReference = (JavaReference)object4.next();
                try {
                    long l2;
                    if (!javaReference.isObjectReference()) continue;
                    object3 = (JavaObject)javaReference.getTarget();
                    object2 = this.loaders.get(object3);
                    if (object2 != null) {
                        if (object5 == null || !bl) {
                            object5 = object2;
                        }
                    } else if (object9[0] > 0 && (object = (JavaObject)((HashMap)cloneable).get(l2 = object3.getID().getAddress())) != null) {
                        ((PHDJavaClass)object62).setJavaObject((JavaObject)object);
                    }
                    if (object62.isArray() || !bl || object9[0] != false) continue;
                    break;
                }
                catch (CorruptDataException corruptDataException) {
                }
                catch (DataUnavailable dataUnavailable) {
                }
            }
            if (object5 != null) {
                ++n2;
                ((PHDJavaClassLoader)object5).prepareToMove(pHDJavaClassLoader, object62);
                try {
                    if (object7 == null && (object62.equals(javaClass) || object62.equals(((PHDJavaClassLoader)object5).getObject().getJavaClass()))) {
                        object7 = object5;
                    }
                    if (object7 == object5 && object62.getName().startsWith("java/lang/")) {
                        ++n4;
                    }
                }
                catch (CorruptDataException corruptDataException) {}
            } else {
                ++n3;
            }
            try {
                long l3;
                object4 = object62.getObject();
                if (object4 == null || (object2 = (JavaObject)((HashMap)cloneable).get(l3 = object4.getID().getAddress())) == null) continue;
                ((PHDJavaClass)object62).setJavaObject((JavaObject)object2);
            }
            catch (CorruptDataException corruptDataException) {}
        }
        if (n4 < 5) {
            object7 = null;
        }
        if (this.metaJavaRuntime != null) {
            iterator = this.metaJavaRuntime.getJavaClassLoaders();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof CorruptData) continue;
                object5 = (JavaClassLoader)e;
                try {
                    JavaClass javaClass3;
                    ImagePointer imagePointer;
                    object4 = object5.getObject();
                    if (object4 == null || (imagePointer = object4.getID()) == null) continue;
                    object3 = this.space.getPointer(imagePointer.getAddress());
                    object2 = this.getObjectAtAddress((ImagePointer)object3);
                    PHDJavaClassLoader pHDJavaClassLoader2 = this.loaders.get(object2);
                    if (pHDJavaClassLoader2 == null) {
                        try {
                            javaClass3 = object2.getJavaClass();
                        }
                        catch (CorruptDataException corruptDataException) {
                            javaClass3 = null;
                        }
                        try {
                            object = object4.getJavaClass();
                        }
                        catch (CorruptDataException corruptDataException) {
                            object = null;
                        }
                        if (javaClass3 == null || object == null || !javaClass3.isArray() && (javaClass3.getID() == null || object.getID() == null || javaClass3.getID().getAddress() == object.getID().getAddress())) {
                            pHDJavaClassLoader2 = new PHDJavaClassLoader((JavaObject)object2);
                            this.loaders.put((JavaObject)object2, pHDJavaClassLoader2);
                        }
                    } else {
                        object2 = pHDJavaClassLoader2.getObject();
                        javaClass3 = object2.getJavaClass();
                    }
                    if (pHDJavaClassLoader2 == null) continue;
                    object = object5.getDefinedClasses();
                    while (object.hasNext()) {
                        Object object6;
                        JavaClass javaClass4;
                        Object e2 = object.next();
                        if (e2 instanceof CorruptData) continue;
                        JavaClass javaClass5 = (JavaClass)e2;
                        ImagePointer imagePointer2 = javaClass5.getID();
                        if (imagePointer2 != null) {
                            long l4 = imagePointer2.getAddress();
                            javaClass4 = pHDJavaClassLoader.findClass(l4);
                            if (javaClass4 == null) {
                                javaClass4 = pHDJavaClassLoader.findClassUnique(javaClass5.getName());
                            } else {
                                try {
                                    javaClass4.getName();
                                }
                                catch (CorruptDataException corruptDataException) {
                                    try {
                                        object6 = javaClass5.getName();
                                        PHDJavaClass pHDJavaClass = (PHDJavaClass)javaClass4;
                                        pHDJavaClass.setName((String)object6);
                                    }
                                    catch (CorruptDataException corruptDataException2) {}
                                }
                            }
                        } else {
                            javaClass4 = pHDJavaClassLoader.findClassUnique(javaClass5.getName());
                        }
                        if (javaClass4 == null) continue;
                        pHDJavaClassLoader2.prepareToMove(pHDJavaClassLoader, javaClass4);
                        if (javaClass4.equals(javaClass3) || javaClass4.equals(javaClass)) {
                            object7 = pHDJavaClassLoader2;
                        }
                        Iterator iterator2 = javaClass5.getDeclaredMethods();
                        while (iterator2.hasNext()) {
                            Object e3 = iterator2.next();
                            if (e3 instanceof CorruptData) continue;
                            JavaMethod javaMethod = (JavaMethod)e3;
                            object6 = (PHDJavaClass)javaClass4;
                            ((PHDJavaClass)object6).addMethod(new PHDJavaMethod(this.space, (JavaClass)object6, javaMethod));
                        }
                    }
                }
                catch (CorruptDataException corruptDataException) {
                }
                catch (DataUnavailable dataUnavailable) {
                }
                catch (MemoryAccessException memoryAccessException) {
                }
            }
        }
        iterator = pHDJavaClassLoader.getDefinedClasses();
        while (iterator.hasNext()) {
            JavaClass javaClass6 = (JavaClass)iterator.next();
            try {
                object5 = javaClass6.getClassLoader();
                if (pHDJavaClassLoader.equals(object5) || !(object5 instanceof PHDJavaClassLoader)) continue;
                this.transferClass(pHDJavaClassLoader, (PHDJavaClassLoader)object5, javaClass6);
            }
            catch (CorruptDataException corruptDataException) {}
        }
        for (PHDJavaClassLoader pHDJavaClassLoader3 : this.loaders.values()) {
            pHDJavaClassLoader3.initCache();
        }
        if (object7 != null) {
            iterator = pHDJavaClassLoader.getDefinedClasses();
            while (iterator.hasNext()) {
                JavaClass javaClass7 = (JavaClass)iterator.next();
                ((PHDJavaClassLoader)object7).prepareToMove(pHDJavaClassLoader, javaClass7);
                this.transferClass(pHDJavaClassLoader, (PHDJavaClassLoader)object7, javaClass7);
            }
            ((PHDJavaClassLoader)object7).initCache();
            this.loaders.remove(null);
        } else {
            iterator = pHDJavaClassLoader.getDefinedClasses();
            while (iterator.hasNext()) {
                JavaClass javaClass8 = (JavaClass)iterator.next();
                object5 = pHDJavaClassLoader.setArrayType(this, pHDJavaClassLoader, javaClass8);
            }
            pHDJavaClassLoader.initCache();
        }
    }

    private void transferClass(PHDJavaClassLoader pHDJavaClassLoader, PHDJavaClassLoader pHDJavaClassLoader2, JavaClass javaClass) {
        pHDJavaClassLoader2.move(pHDJavaClassLoader, javaClass, this.lastDummyClassAddr());
        JavaClass javaClass2 = pHDJavaClassLoader2.setArrayType(this, pHDJavaClassLoader, javaClass);
        if (javaClass2 != null) {
            pHDJavaClassLoader2.prepareToMove(pHDJavaClassLoader, javaClass2);
            pHDJavaClassLoader2.move(pHDJavaClassLoader, javaClass2, this.lastDummyClassAddr());
        }
    }

    Iterator<JavaClass> getLoaderClasses(JavaObject javaObject) {
        PHDJavaClassLoader pHDJavaClassLoader = this.loaders.get(javaObject);
        if (pHDJavaClassLoader != null) {
            return pHDJavaClassLoader.getDefinedClasses();
        }
        return Collections.emptyList().iterator();
    }

    JavaThread getThread(JavaThread javaThread) {
        if (!this.threads.containsKey(javaThread)) {
            this.threads.put(javaThread, new PHDJavaThread(this.space, this.process, this, javaThread));
        }
        return this.threads.get(javaThread);
    }

    private void prepThreads() {
        if (this.metaJavaRuntime != null) {
            PHDJavaClassLoader pHDJavaClassLoader = this.loaders.get(null);
            Iterator iterator = this.metaJavaRuntime.getThreads();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof CorruptData) continue;
                JavaThread javaThread = (JavaThread)e;
                try {
                    JavaObject javaObject = javaThread.getObject();
                    this.saveExtraObject(pHDJavaClassLoader, javaObject);
                }
                catch (CorruptDataException corruptDataException) {}
            }
        }
    }

    private void saveExtraObject(PHDJavaClassLoader pHDJavaClassLoader, JavaObject javaObject) {
        if (javaObject != null) {
            JavaClass javaClass;
            long l = javaObject.getID().getAddress();
            try {
                javaClass = pHDJavaClassLoader.findClassUnique(javaObject.getJavaClass().getName());
            }
            catch (CorruptDataException corruptDataException) {
                javaClass = null;
            }
            PHDJavaObject pHDJavaObject = new PHDJavaObject.Builder(this.heaps.get(0), l, javaClass, 4, -1).refsAsArray(NOREFS, 0).length(-3).build();
            this.extraObjectsCache.put(l, pHDJavaObject);
        }
    }

    private void initThreads() {
        if (this.metaJavaRuntime != null) {
            Iterator iterator = this.metaJavaRuntime.getThreads();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof CorruptData) {
                    PHDCorruptJavaThread pHDCorruptJavaThread = new PHDCorruptJavaThread(this.space, (CorruptData)e);
                    this.threads.put(pHDCorruptJavaThread, pHDCorruptJavaThread);
                    continue;
                }
                this.getThread((JavaThread)e);
            }
        }
    }

    private void prepMonitors() {
        if (this.metaJavaRuntime != null) {
            PHDJavaClassLoader pHDJavaClassLoader = this.loaders.get(null);
            Iterator iterator = this.metaJavaRuntime.getMonitors();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof CorruptData) continue;
                JavaMonitor javaMonitor = (JavaMonitor)e;
                JavaObject javaObject = javaMonitor.getObject();
                this.saveExtraObject(pHDJavaClassLoader, javaObject);
            }
        }
    }

    private void initMonitors() {
        if (this.metaJavaRuntime != null) {
            Iterator iterator = this.metaJavaRuntime.getMonitors();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof CorruptData) {
                    this.monitors.add(new PHDCorruptJavaMonitor(this.space, (CorruptData)e));
                    continue;
                }
                this.monitors.add(new PHDJavaMonitor(this.space, this, (JavaMonitor)e));
            }
        }
    }

    private void prepClassLoaders() {
        if (this.metaJavaRuntime != null) {
            PHDJavaClassLoader pHDJavaClassLoader = this.loaders.get(null);
            Iterator iterator = this.metaJavaRuntime.getJavaClassLoaders();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof CorruptData) continue;
                JavaClassLoader javaClassLoader = (JavaClassLoader)e;
                try {
                    JavaObject javaObject = javaClassLoader.getObject();
                    this.saveExtraObject(pHDJavaClassLoader, javaObject);
                }
                catch (CorruptDataException corruptDataException) {}
            }
        }
    }

    long nextDummyClassAddr() {
        return ++this.nextClsAddr;
    }

    long lastDummyClassAddr() {
        return this.nextClsAddr;
    }

    @Override
    public Iterator getMemoryCategories() throws DataUnavailable {
        throw new DataUnavailable("This implementation of DTFJ does not support getMemoryCategories");
    }

    @Override
    public Iterator getMemorySections(boolean bl) throws DataUnavailable {
        throw new DataUnavailable("This implementation of DTFJ does not support getMemorySections");
    }

    @Override
    public boolean isJITEnabled() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("This implementation of DTFJ does not support isJITEnabled");
    }

    @Override
    public Properties getJITProperties() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("This implementation of DTFJ does not support getJITProperies");
    }

    @Override
    public long getStartTime() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable();
    }

    @Override
    public long getStartTimeNanos() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable();
    }
}

