/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.jvm.dtfjview.Session;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.spi.ICombinedContext;
import com.ibm.jvm.dtfjview.spi.ISession;
import com.ibm.jvm.dtfjview.spi.ISessionContextManager;
import java.io.PrintStream;

public class CloseCommand
extends BaseJdmpviewCommand {
    private static final String CMD_NAME = "close";

    public CloseCommand() {
        this.addCommand(CMD_NAME, "[context id]", "closes the connection to a core file");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        Object object = this.ctx.getProperties().get("session");
        if (object == null) {
            this.logger.fine("Could not close a new context as the session property has not been set");
            return;
        }
        if (!(object instanceof Session)) {
            this.logger.fine("Could not close an existing context as the session type was not recognised [" + object.getClass().getName() + "]");
            return;
        }
        ISessionContextManager iSessionContextManager = ((ISession)object).getContextManager();
        switch (stringArray.length) {
            case 0: {
                printStream.println("Closing all contexts");
                iSessionContextManager.removeAllContexts();
                printStream.println("All contexts have been closed");
                break;
            }
            case 1: {
                printStream.println("Closing all contexts sharing the same Image");
                int n = Integer.valueOf(stringArray[0]);
                ICombinedContext iCombinedContext = iSessionContextManager.getContext(n);
                if (iCombinedContext == null) {
                    printStream.println("The specified context id " + stringArray[0] + " was invalid");
                    return;
                }
                iSessionContextManager.removeContexts(iCombinedContext.getImage().getSource());
                printStream.println("Closed all contexts created from " + iCombinedContext.getImage().getSource());
                break;
            }
            default: {
                printStream.println("This command takes 0 or 1 parameters. Execute 'close help' for more information");
                return;
            }
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("Closes the connection to a image source. The connection to be closed is determined by the current context, which means that more than one context may be removed depending on how many were created against the original source.");
    }
}

