/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.CorruptCoreException;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemoryRange;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.memory.Symbol;
import com.ibm.j9ddr.corereaders.minidump.LateInitializedStream;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import com.ibm.j9ddr.corereaders.minidump.unwind.RuntimeFunction;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindModule;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class ModuleStream
extends LateInitializedStream {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");

    public ModuleStream(int n, int n2) {
        super(n, n2);
    }

    private String getModuleName(MiniDumpReader miniDumpReader, int n) throws IOException {
        miniDumpReader.seek(n);
        int n2 = miniDumpReader.readInt();
        if (n2 <= 0 || 512 <= n2) {
            n2 = 512;
        }
        byte[] byArray = miniDumpReader.readBytes(n2);
        return new String(byArray, "UTF-16LE");
    }

    @Override
    public void readFrom(MiniDumpReader miniDumpReader, IAddressSpace iAddressSpace, boolean bl) throws IOException, CorruptDataException {
        miniDumpReader.seek(this.getLocation());
        int n = miniDumpReader.readInt();
        if (n > 1024) {
            throw new CorruptDataException("Improbably high number of modules found: " + n + ", location = " + Long.toHexString(this.getLocation()));
        }
        class ModuleData {
            long imageBaseAddress;
            Properties properties;
            int nameAddress;

            ModuleData() {
            }
        }
        ModuleData[] moduleDataArray = new ModuleData[n];
        for (int i = 0; i < n; ++i) {
            moduleDataArray[i] = new ModuleData();
            moduleDataArray[i].imageBaseAddress = miniDumpReader.readLong();
            int n2 = miniDumpReader.readInt();
            int n3 = miniDumpReader.readInt();
            int n4 = miniDumpReader.readInt();
            moduleDataArray[i].nameAddress = miniDumpReader.readInt();
            moduleDataArray[i].properties = this.readProperties(miniDumpReader, n2, n3, n4);
        }
        for (ModuleData moduleData : moduleDataArray) {
            long l = moduleData.imageBaseAddress;
            String string = this.getModuleName(miniDumpReader, moduleData.nameAddress);
            Properties properties = moduleData.properties;
            try {
                short s = iAddressSpace.getShortAt(l);
                if (23117 != s) {
                    logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.minidump.ModuleStream", "readFrom", "Magic number was: " + Integer.toHexString(0xFFFF & s) + " expected 0x5A4D");
                }
            }
            catch (MemoryFault memoryFault) {
                logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.minidump.ModuleStream", "readFrom", "MemoryFault reading magic number", memoryFault);
            }
            long l2 = l + 60L;
            LinkedList<IMemoryRange> linkedList = new LinkedList<IMemoryRange>();
            try {
                long l3 = 0xFFFFFFFFL & (long)iAddressSpace.getIntAt(l2);
                long l4 = l3 + l;
                List<Object> list = null;
                if (0L != l3) {
                    this.loadModuleSections(iAddressSpace, l, l4, l3, linkedList);
                    list = this.buildSymbols(miniDumpReader, iAddressSpace, l);
                }
                if (list == null) {
                    list = new LinkedList();
                }
                List<RuntimeFunction> list2 = null;
                list2 = this.buildRuntimeFunctionList(miniDumpReader, iAddressSpace, l);
                Module module = list2 != null ? new UnwindModule(iAddressSpace.getProcesses().iterator().next(), string, list, linkedList, moduleData.imageBaseAddress, properties, list2) : new Module(iAddressSpace.getProcesses().iterator().next(), string, list, linkedList, moduleData.imageBaseAddress, properties);
                if (string.toLowerCase().endsWith(".exe")) {
                    miniDumpReader.setExecutable(module);
                    continue;
                }
                miniDumpReader.addLibrary(module);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.minidump.ModuleStream", "readFrom", "Problem reading symbols", exception);
            }
        }
    }

    private void loadModuleSections(IAddressSpace iAddressSpace, long l, long l2, long l3, Collection<IMemoryRange> collection) throws MemoryFault {
        int n = iAddressSpace.getIntAt(l2);
        l2 += 4L;
        if (17744 != n) {
            logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.minidump.ModuleStream", "loadModuleSections", "PE Magic is: \"" + Integer.toHexString(n));
        }
        int n2 = iAddressSpace.getShortAt(l2 += 2L);
        l2 += 2L;
        l2 += 4L;
        l2 += 4L;
        short s = iAddressSpace.getShortAt(l2 += 4L);
        l2 += 2L;
        l2 += 2L;
        l2 = l + l3 + 24L + (0xFFFFL & (long)s);
        for (int i = 0; i < n2; ++i) {
            String string;
            byte[] byArray = new byte[8];
            iAddressSpace.getBytesAt(l2, byArray);
            long l4 = iAddressSpace.getIntAt(l2 += 8L);
            long l5 = iAddressSpace.getIntAt(l2 += 4L);
            l2 += 4L;
            l2 += 4L;
            l2 += 4L;
            l2 += 4L;
            l2 += 4L;
            l2 += 2L;
            l2 += 2L;
            l2 += 4L;
            long l6 = l5 + l;
            try {
                string = new String(byArray, "ASCII");
                string = string.trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            MemoryRange memoryRange = new MemoryRange(iAddressSpace, l6, l4, string);
            collection.add(memoryRange);
        }
    }

    private Properties readProperties(MiniDumpReader miniDumpReader, int n, int n2, int n3) throws IOException {
        int n4 = miniDumpReader.readInt();
        int n5 = miniDumpReader.readInt();
        int n6 = miniDumpReader.readInt();
        int n7 = miniDumpReader.readInt();
        int n8 = miniDumpReader.readInt();
        int n9 = miniDumpReader.readInt();
        int n10 = miniDumpReader.readInt();
        int n11 = miniDumpReader.readInt();
        int n12 = miniDumpReader.readInt();
        int n13 = miniDumpReader.readInt();
        int n14 = miniDumpReader.readInt();
        int n15 = miniDumpReader.readInt();
        int n16 = miniDumpReader.readInt();
        miniDumpReader.readInt();
        miniDumpReader.readInt();
        miniDumpReader.readInt();
        miniDumpReader.readInt();
        miniDumpReader.readLong();
        miniDumpReader.readLong();
        Properties properties = new Properties();
        properties.setProperty("imageSize", Integer.toHexString(n));
        properties.setProperty("checksum", Integer.toHexString(n2));
        properties.setProperty("timeDateStamp", new Date(1000L * ((long)n3 + 28800L)).toString());
        properties.setProperty("versionInfoDwSignature", Integer.toHexString(n4));
        properties.setProperty("versionInfoDwStrucVersion", Integer.toHexString(n5));
        properties.setProperty("versionInfoDwFileVersionMS", Integer.toHexString(n6));
        properties.setProperty("versionInfoDwFileVersionLS", Integer.toHexString(n7));
        properties.setProperty("versionInfoDwProductVersionMS", Integer.toHexString(n8));
        properties.setProperty("versionInfoDwProductVersionLS", Integer.toHexString(n9));
        properties.setProperty("versionInfoDwFileFlagsMask", Integer.toHexString(n10));
        properties.setProperty("versionInfoDwFileFlags", Integer.toHexString(n11));
        properties.setProperty("versionInfoDwFileOS", Integer.toHexString(n12));
        properties.setProperty("versionInfoDwFileType", Integer.toHexString(n13));
        properties.setProperty("versionInfoDwFileSubtype", Integer.toHexString(n14));
        properties.setProperty("versionInfoDwFileDateMS", Integer.toHexString(n15));
        properties.setProperty("versionInfoDwFileDateLS", Integer.toHexString(n16));
        return properties;
    }

    private List<ISymbol> buildSymbols(MiniDumpReader miniDumpReader, IAddressSpace iAddressSpace, long l) throws CorruptDataException, CorruptCoreException {
        int n;
        int n2;
        int n3;
        long l2 = l;
        byte[] byArray = new byte[2];
        iAddressSpace.getBytesAt(l, byArray);
        String string = null;
        try {
            string = new String(byArray, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        if (!string.equals("MZ")) {
            throw new CorruptCoreException("Invalid image magic number: \"" + string + "\" @ " + Long.toHexString(l));
        }
        int n4 = iAddressSpace.getIntAt(l + 60L);
        long l3 = ((long)n4 & 0xFFFFFFFFL) + l;
        iAddressSpace.getBytesAt(l3, byArray);
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (!string.equals("PE")) {
            throw new CorruptCoreException("Invalid PE magic number: \"" + string + "\" @ " + Long.toHexString(l3));
        }
        long l4 = l3 + 4L;
        l4 += 2L;
        l4 += 2L;
        l4 += 4L;
        l4 += 4L;
        long l5 = l4 += 4L;
        short s = iAddressSpace.getShortAt(l5);
        l4 += 2L;
        l4 += 2L;
        if (224 == s) {
            n3 = iAddressSpace.getShortAt(l4);
            if (267 != n3) {
                throw new CorruptCoreException("Invalid IMAGE_OPTIONAL_HEADER magic number: \"0x" + Integer.toHexString(0xFFFF & n3) + "\" @ " + Long.toHexString(l4));
            }
            l4 += 2L;
            ++l4;
            ++l4;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 2L;
            l4 += 2L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
        } else if (240 == s) {
            n3 = iAddressSpace.getShortAt(l4);
            if (523 != n3) {
                throw new CorruptCoreException("Invalid IMAGE_OPTIONAL_HEADER64 magic number: \"0x" + Integer.toHexString(0xFFFF & n3) + "\" @ " + Long.toHexString(l4));
            }
            l4 += 2L;
            ++l4;
            ++l4;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 8L;
            l4 += 4L;
            l4 += 4L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 2L;
            l4 += 2L;
            l4 += 8L;
            l4 += 8L;
            l4 += 8L;
            l4 += 8L;
            l4 += 4L;
            l4 += 4L;
        } else {
            throw new CorruptCoreException("Invalid IMAGE_OPTIONAL_HEADER size: \"" + s + "\" bytes @ " + Long.toHexString(l5));
        }
        n3 = iAddressSpace.getIntAt(l4);
        l4 += 4L;
        if (0 == n3) {
            return Collections.emptyList();
        }
        l4 += 4L;
        l4 = l2 + ((long)n3 & 0xFFFFFFFFL);
        l4 += 4L;
        l4 += 4L;
        l4 += 2L;
        l4 += 2L;
        l4 += 4L;
        long l6 = l4 += 4L;
        int n5 = iAddressSpace.getIntAt(l6);
        int n6 = iAddressSpace.getIntAt(l4 += 4L);
        l4 += 4L;
        if (n5 < n6) {
            throw new CorruptCoreException("IMAGE_EXPORT_DIRECTORY NumberOfFunctions (" + n5 + ") < NumberOfNames (" + n6 + ") @ " + Long.toHexString(l6));
        }
        long l7 = (long)iAddressSpace.getIntAt(l4) & 0xFFFFFFFFL;
        long l8 = (long)iAddressSpace.getIntAt(l4 += 4L) & 0xFFFFFFFFL;
        long l9 = (long)iAddressSpace.getIntAt(l4 += 4L) & 0xFFFFFFFFL;
        l4 += 4L;
        int[] nArray = new int[n6];
        l4 = l8 + l2;
        for (int i = 0; i < n6; ++i) {
            nArray[i] = iAddressSpace.getIntAt(l4);
            l4 += 4L;
        }
        long[] lArray = new long[n5];
        l4 = l7 + l2;
        for (int i = 0; i < n5; ++i) {
            lArray[i] = iAddressSpace.getIntAt(l4);
            l4 += 4L;
        }
        int[] nArray2 = new int[n6];
        l4 = l9 + l2;
        for (int i = 0; i < n6; ++i) {
            nArray2[i] = 0xFFFF & iAddressSpace.getShortAt(l4);
            l4 += 2L;
        }
        String[] stringArray = new String[n6];
        byte[] byArray2 = new byte[2048];
        for (int i = 0; i < n6; ++i) {
            l4 = ((long)nArray[i] & 0xFFFFFFFFL) + l2;
            Arrays.fill(byArray2, (byte)0);
            n2 = 0;
            n = 0;
            do {
                n = iAddressSpace.getByteAt(l4);
                ++l4;
                byArray2[n2] = n;
            } while (0 != n && ++n2 < byArray2.length);
            try {
                stringArray[i] = new String(byArray2, 0, n2 - 1, "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        ArrayList<ISymbol> arrayList = new ArrayList<ISymbol>(n6);
        for (n2 = 0; n2 < n6; ++n2) {
            n = nArray2[n2];
            long l10 = lArray[n] + l2;
            String string2 = stringArray[n2];
            Symbol symbol = new Symbol(string2, l10);
            arrayList.add(symbol);
        }
        return arrayList;
    }

    private List<RuntimeFunction> buildRuntimeFunctionList(MiniDumpReader miniDumpReader, IAddressSpace iAddressSpace, long l) throws CorruptDataException, CorruptCoreException {
        int n;
        int n2;
        long l2 = l;
        byte[] byArray = new byte[2];
        iAddressSpace.getBytesAt(l, byArray);
        String string = null;
        try {
            string = new String(byArray, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CorruptCoreException("Unable to decode magic number");
        }
        if (!string.equals("MZ")) {
            throw new CorruptCoreException("Invalid image magic number: \"" + string + "\" @ " + Long.toHexString(l));
        }
        int n3 = iAddressSpace.getIntAt(l + 60L);
        long l3 = ((long)n3 & 0xFFFFFFFFL) + l;
        iAddressSpace.getBytesAt(l3, byArray);
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (!string.equals("PE")) {
            throw new CorruptCoreException("Invalid PE magic number: \"" + string + "\" @ " + Long.toHexString(l3));
        }
        long l4 = l3 + 4L;
        l4 += 2L;
        l4 += 2L;
        l4 += 4L;
        l4 += 4L;
        long l5 = l4 += 4L;
        short s = iAddressSpace.getShortAt(l5);
        l4 += 2L;
        l4 += 2L;
        if (224 == s) {
            return null;
        }
        if (240 == s) {
            n2 = iAddressSpace.getShortAt(l4);
            if (523 != n2) {
                throw new CorruptCoreException("Invalid IMAGE_OPTIONAL_HEADER64 magic number: \"0x" + Integer.toHexString(0xFFFF & n2) + "\" @ " + Long.toHexString(l4));
            }
            l4 += 2L;
            ++l4;
            ++l4;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 8L;
            l4 += 4L;
            l4 += 4L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 2L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 4L;
            l4 += 2L;
            l4 += 2L;
            l4 += 8L;
            l4 += 8L;
            l4 += 8L;
            l4 += 8L;
            l4 += 4L;
            l4 += 4L;
        } else {
            throw new CorruptCoreException("Invalid IMAGE_OPTIONAL_HEADER size: \"" + s + "\" bytes @ " + Long.toHexString(l5));
        }
        n2 = 3;
        for (n = 0; n < n2; ++n) {
            l4 += 4L;
            l4 += 4L;
        }
        n = iAddressSpace.getIntAt(l4);
        int n4 = iAddressSpace.getIntAt(l4);
        int n5 = n4 / 12;
        l4 = l2 + ((long)n & 0xFFFFFFFFL);
        LinkedList<RuntimeFunction> linkedList = new LinkedList<RuntimeFunction>();
        for (int i = 0; i < n5; ++i) {
            int n6 = iAddressSpace.getIntAt(l4);
            l4 += 4L;
            if (n6 == 0) break;
            int n7 = iAddressSpace.getIntAt(l4);
            int n8 = iAddressSpace.getIntAt(l4 += 4L);
            l4 += 4L;
            RuntimeFunction runtimeFunction = new RuntimeFunction(n6, n7, n8);
            linkedList.add(runtimeFunction);
        }
        return linkedList;
    }
}

