/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.DumpMemorySource;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.minidump.BaseWindowsOSThread;
import com.ibm.j9ddr.corereaders.minidump.LateInitializedStream;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.Register;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

class ThreadStream
extends LateInitializedStream {
    public ThreadStream(int n, int n2) {
        super(n, n2);
    }

    @Override
    public void readFrom(MiniDumpReader miniDumpReader, IAddressSpace iAddressSpace, boolean bl) throws CorruptDataException, IOException {
        miniDumpReader.seek(this.getLocation());
        int n = miniDumpReader.readInt();
        if (n > 100000) {
            throw new CorruptDataException("Unlikely number of threads found in dump: " + n + ". Suspect data corruption");
        }
        for (int i = 0; i < n; ++i) {
            miniDumpReader.seek(this.getLocation() + 4L + (long)(i * 48));
            int n2 = miniDumpReader.readInt();
            miniDumpReader.readInt();
            int n3 = miniDumpReader.readInt();
            int n4 = miniDumpReader.readInt();
            miniDumpReader.readLong();
            long l = miniDumpReader.readLong();
            long l2 = 0xFFFFFFFFL & (long)miniDumpReader.readInt();
            long l3 = 0xFFFFFFFFL & (long)miniDumpReader.readInt();
            miniDumpReader.readInt();
            long l4 = 0xFFFFFFFFL & (long)miniDumpReader.readInt();
            Properties properties = new Properties();
            properties.setProperty("priorityClass", String.valueOf(n3));
            properties.setProperty("priority", String.valueOf(n4));
            miniDumpReader.addThread(new WindowsOSThread(n2, l, l2, l3, l4, properties, miniDumpReader, (IProcess)((Object)iAddressSpace)));
        }
    }

    private static class WindowsOSThread
    extends BaseWindowsOSThread {
        private final long threadId;
        private final long stackStart;
        private final long stackSize;
        private final long stackRva;
        private final long contextRva;
        private final Properties properties;
        private final MiniDumpReader reader;
        private List<IRegister> registers;

        public WindowsOSThread(int n, long l, long l2, long l3, long l4, Properties properties, MiniDumpReader miniDumpReader, IProcess iProcess) {
            super(iProcess);
            this.threadId = n;
            this.stackStart = l;
            this.stackSize = l2;
            this.stackRva = l3;
            this.contextRva = l4;
            this.properties = properties;
            this.reader = miniDumpReader;
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            return Collections.singletonList(new DumpMemorySource(this.stackStart, this.stackSize, this.stackRva, 0, this.reader, "Stack"));
        }

        public List<IRegister> getRegisters() {
            if (null == this.registers) {
                this.registers = new ArrayList<IRegister>();
                try {
                    switch (this.reader.getProcessorArchitecture()) {
                        case 9: {
                            this.readAmd64Registers();
                            break;
                        }
                        case 0: {
                            this.readIntelRegisters();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown processor architecture: " + this.reader.getProcessorArchitecture());
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return Collections.unmodifiableList(this.registers);
        }

        private void readIntelRegisters() throws IOException {
            this.reader.seek(this.contextRva + 140L);
            this.registers.add(new Register("gs", this.reader.readInt()));
            this.registers.add(new Register("fs", this.reader.readInt()));
            this.registers.add(new Register("es", this.reader.readInt()));
            this.registers.add(new Register("ds", this.reader.readInt()));
            this.registers.add(new Register("edi", this.reader.readInt()));
            this.registers.add(new Register("esi", this.reader.readInt()));
            this.registers.add(new Register("ebx", this.reader.readInt()));
            this.registers.add(new Register("edx", this.reader.readInt()));
            this.registers.add(new Register("ecx", this.reader.readInt()));
            this.registers.add(new Register("eax", this.reader.readInt()));
            this.registers.add(new Register("ebp", this.reader.readInt()));
            this.registers.add(new Register("eip", this.reader.readInt()));
            this.registers.add(new Register("cs", this.reader.readInt()));
            this.registers.add(new Register("flags", this.reader.readInt()));
            this.registers.add(new Register("esp", this.reader.readInt()));
            this.registers.add(new Register("ss", this.reader.readInt()));
        }

        private void readAmd64Registers() throws IOException {
            this.reader.seek(this.contextRva + 56L);
            this.registers.add(new Register("cs", this.reader.readShort()));
            this.registers.add(new Register("ds", this.reader.readShort()));
            this.registers.add(new Register("es", this.reader.readShort()));
            this.registers.add(new Register("fs", this.reader.readShort()));
            this.registers.add(new Register("gs", this.reader.readShort()));
            this.registers.add(new Register("ss", this.reader.readShort()));
            this.registers.add(new Register("flags", this.reader.readInt()));
            this.reader.seek(this.contextRva + 120L);
            this.registers.add(new Register("rax", this.reader.readLong()));
            this.registers.add(new Register("rcx", this.reader.readLong()));
            this.registers.add(new Register("rdx", this.reader.readLong()));
            this.registers.add(new Register("rbx", this.reader.readLong()));
            this.registers.add(new Register("rsp", this.reader.readLong()));
            this.registers.add(new Register("rbp", this.reader.readLong()));
            this.registers.add(new Register("rsi", this.reader.readLong()));
            this.registers.add(new Register("rdi", this.reader.readLong()));
            this.registers.add(new Register("r8", this.reader.readLong()));
            this.registers.add(new Register("r9", this.reader.readLong()));
            this.registers.add(new Register("r10", this.reader.readLong()));
            this.registers.add(new Register("r11", this.reader.readLong()));
            this.registers.add(new Register("r12", this.reader.readLong()));
            this.registers.add(new Register("r13", this.reader.readLong()));
            this.registers.add(new Register("r14", this.reader.readLong()));
            this.registers.add(new Register("r15", this.reader.readLong()));
            this.registers.add(new Register("rip", this.reader.readLong()));
        }

        @Override
        public long getThreadId() {
            return this.threadId;
        }

        @Override
        protected long getStackEnd() {
            return this.stackStart + this.stackSize;
        }

        @Override
        protected long getStackStart() {
            return this.stackStart;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public long getInstructionPointer() {
            switch (this.reader.getProcessorArchitecture()) {
                case 9: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "rip");
                }
                case 0: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "eip");
                }
            }
            String string = "Unknow processor architecture: " + this.reader.getProcessorArchitecture();
            throw new RuntimeException(string);
        }

        @Override
        public long getBasePointer() {
            switch (this.reader.getProcessorArchitecture()) {
                case 9: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "rbp");
                }
                case 0: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "ebp");
                }
            }
            String string = "Unknow processor architecture: " + this.reader.getProcessorArchitecture();
            throw new RuntimeException(string);
        }

        @Override
        public long getStackPointer() {
            switch (this.reader.getProcessorArchitecture()) {
                case 9: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "rsp");
                }
                case 0: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "esp");
                }
            }
            String string = "Unknow processor architecture: " + this.reader.getProcessorArchitecture();
            throw new RuntimeException(string);
        }
    }
}

