/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.GpInfoCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.SnapFormatWrapperCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.SnapTraceCommand;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.DDRInteractiveClassLoader;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.PluginConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseJVMCommands {
    private final Logger logger = CommandUtils.getLogger();

    protected List<ICommand> getBaseJVMCommands() {
        LinkedList<ICommand> linkedList = new LinkedList<ICommand>();
        linkedList.add(new GpInfoCommand());
        linkedList.add(new SnapTraceCommand());
        linkedList.add(new SnapFormatWrapperCommand());
        return linkedList;
    }

    protected void loadPlugins(List<ICommand> list, Object object) {
        if (!(object instanceof DDRInteractiveClassLoader)) {
            this.logger.fine("Plugin classloader is not an instance of DRRInteractiveClassLoader. No plugins have been loaded");
            return;
        }
        DDRInteractiveClassLoader dDRInteractiveClassLoader = (DDRInteractiveClassLoader)object;
        for (PluginConfig pluginConfig : dDRInteractiveClassLoader.getPlugins()) {
            try {
                ICommand iCommand = pluginConfig.newInstance();
                list.add(iCommand);
            }
            catch (Throwable throwable) {
                this.logger.log(Level.WARNING, "Failed to create an instance of " + pluginConfig.getId(), throwable);
            }
        }
    }
}

