/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class I32Pointer
extends IDATAPointer {
    public static final int SIZEOF = 4;
    public static final I32Pointer NULL = new I32Pointer(0L);

    protected I32Pointer(long l) {
        super(l);
    }

    public static I32Pointer cast(AbstractPointer abstractPointer) {
        return I32Pointer.cast(abstractPointer.getAddress());
    }

    public static I32Pointer cast(UDATA uDATA) {
        return I32Pointer.cast(uDATA.longValue());
    }

    public static I32Pointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new I32Pointer(l);
    }

    @Override
    public I32 at(long l) throws CorruptDataException {
        return new I32(this.getIntAtOffset(l * 4L));
    }

    @Override
    public I32 at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public I32Pointer untag() {
        return this.untag(3L);
    }

    @Override
    public I32Pointer untag(long l) {
        return new I32Pointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public I32Pointer add(long l) {
        return new I32Pointer(this.address + 4L * l);
    }

    @Override
    public I32Pointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public I32Pointer addOffset(long l) {
        return new I32Pointer(this.address + l);
    }

    @Override
    public I32Pointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public I32Pointer sub(long l) {
        return new I32Pointer(this.address - 4L * l);
    }

    @Override
    public I32Pointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public I32Pointer subOffset(long l) {
        return new I32Pointer(this.address - l);
    }

    @Override
    public I32Pointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return 4L;
    }
}

