/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class I64Pointer
extends IDATAPointer {
    public static final int SIZEOF = 8;
    public static final I64Pointer NULL = new I64Pointer(0L);

    protected I64Pointer(long l) {
        super(l);
    }

    public static I64Pointer cast(AbstractPointer abstractPointer) {
        return I64Pointer.cast(abstractPointer.getAddress());
    }

    public static I64Pointer cast(UDATA uDATA) {
        return I64Pointer.cast(uDATA.longValue());
    }

    public static I64Pointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new I64Pointer(l);
    }

    @Override
    public I64 at(long l) throws CorruptDataException {
        return new I64(this.getLongAtOffset(l * 8L));
    }

    @Override
    public I64 at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public I64Pointer untag() {
        return this.untag(7L);
    }

    @Override
    public I64Pointer untag(long l) {
        return new I64Pointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public I64Pointer add(long l) {
        return new I64Pointer(this.address + 8L * l);
    }

    @Override
    public I64Pointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public I64Pointer addOffset(long l) {
        return new I64Pointer(this.address + l);
    }

    @Override
    public I64Pointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public I64Pointer sub(long l) {
        return new I64Pointer(this.address - 8L * l);
    }

    @Override
    public I64Pointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public I64Pointer subOffset(long l) {
        return new I64Pointer(this.address - l);
    }

    @Override
    public I64Pointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return 8L;
    }
}

