/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ITablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMClassRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMConstantRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMInterfaceMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMMethodHandleRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMMethodTypeRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMStaticFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMStaticMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMStringRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VTableHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.structure.J9Class;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9ITable;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9Method;
import com.ibm.j9ddr.vm29.structure.J9RAMClassRef;
import com.ibm.j9ddr.vm29.structure.J9RAMConstantPoolItem;
import com.ibm.j9ddr.vm29.structure.J9RAMConstantRef;
import com.ibm.j9ddr.vm29.structure.J9RAMFieldRef;
import com.ibm.j9ddr.vm29.structure.J9RAMInterfaceMethodRef;
import com.ibm.j9ddr.vm29.structure.J9RAMMethodHandleRef;
import com.ibm.j9ddr.vm29.structure.J9RAMMethodRef;
import com.ibm.j9ddr.vm29.structure.J9RAMMethodTypeRef;
import com.ibm.j9ddr.vm29.structure.J9RAMStaticMethodRef;
import com.ibm.j9ddr.vm29.structure.J9RAMStringRef;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.structure.J9VTableHeader;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ClassWalker;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.IClassWalkCallbacks;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.HashMap;
import java.util.Iterator;

public class RamClassWalker
extends ClassWalker {
    private final J9ClassPointer ramClass;
    private final Context context;

    public RamClassWalker(StructurePointer structurePointer, Context context) {
        this.clazz = structurePointer;
        this.context = context;
        this.ramClass = structurePointer instanceof J9ClassPointer ? (J9ClassPointer)structurePointer : J9ClassPointer.NULL;
        this.fillDebugExtMap();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void allSlotsInObjectDo(IClassWalkCallbacks iClassWalkCallbacks) throws CorruptDataException {
        this.classWalkerCallback = iClassWalkCallbacks;
        if (this.ramClass.isNull()) {
            throw new CorruptDataException("The StructurePointer clazz is not an instance of J9ClassPointer");
        }
        this.classWalkerCallback = iClassWalkCallbacks;
        this.allSlotsInJitVTablesDo();
        this.allSlotsInRAMHeaderDo();
        this.allSlotsInVTableDo();
        this.allSlotsInExtendedMethodBlockDo();
        this.allSlotsInRAMMethodsSectionDo();
        this.allSlotsInConstantPoolDo();
        this.allSlotsInRAMStaticsDo();
        this.allSlotsInRAMSuperClassesDo();
        this.allSlotsInInstanceDescriptionBitsDo();
        this.allSlotsIniTableDo();
        this.allSlotsInStaticSplitTableDo();
        this.allSlotsInSpecialSplitTableDo();
    }

    private void allSlotsInRAMSuperClassesDo() throws CorruptDataException {
        long l = J9ClassHelper.classDepth(this.ramClass).longValue();
        PointerPointer pointerPointer = this.ramClass.superclasses();
        int n = 0;
        while ((long)n < l) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, pointerPointer.add(n), "SuperClass address", "!j9class");
            ++n;
        }
        this.classWalkerCallback.addSection(this.clazz, pointerPointer, l * PointerPointer.SIZEOF, "Superclasses", false);
    }

    private void allSlotsInStaticSplitTableDo() throws CorruptDataException {
        int n = this.ramClass.romClass().staticSplitMethodRefCount().intValue();
        PointerPointer pointerPointer = this.ramClass.staticSplitMethodTable();
        for (int i = 0; i < n; ++i) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, pointerPointer.add(i), "J9Method address", "!j9method");
        }
        this.classWalkerCallback.addSection(this.clazz, pointerPointer, (long)n * PointerPointer.SIZEOF, "StaticSplitTable", false);
    }

    private void allSlotsInSpecialSplitTableDo() throws CorruptDataException {
        int n = this.ramClass.romClass().specialSplitMethodRefCount().intValue();
        PointerPointer pointerPointer = this.ramClass.specialSplitMethodTable();
        for (int i = 0; i < n; ++i) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, pointerPointer.add(i), "J9Method address", "!j9method");
        }
        this.classWalkerCallback.addSection(this.clazz, pointerPointer, (long)n * PointerPointer.SIZEOF, "SpecialSplitTable", false);
    }

    private void allSlotsIniTableDo() throws CorruptDataException {
        J9ITablePointer j9ITablePointer = J9ITablePointer.cast(this.ramClass.iTable());
        int n = 0;
        J9ClassPointer j9ClassPointer = J9ClassHelper.superclass(this.ramClass);
        J9ITablePointer j9ITablePointer2 = j9ClassPointer.isNull() ? J9ITablePointer.NULL : J9ITablePointer.cast(j9ClassPointer.iTable());
        while (!j9ITablePointer.eq(j9ITablePointer2)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, j9ITablePointer.interfaceClassEA(), "iTable->interfaceClass", "!j9class");
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, j9ITablePointer.nextEA(), "iTable->next", "!j9itable");
            if (!this.ramClass.romClass().modifiers().allBitsIn(J9JavaAccessFlags.J9AccInterface)) {
                int n2 = j9ITablePointer.interfaceClass().romClass().romMethodCount().intValue();
                for (int i = 0; i < n2; ++i) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_iTableMethod, j9ITablePointer.nextEA().add(i + 1), "method", "!j9method");
                    n += UDATA.SIZEOF;
                }
            }
            j9ITablePointer = j9ITablePointer.next();
            n = (int)((long)n + J9ITable.SIZEOF);
        }
        this.classWalkerCallback.addSection(this.clazz, this.ramClass.iTable(), n, "iTable", false);
    }

    private void allSlotsInInstanceDescriptionBitsDo() throws CorruptDataException {
        if (!this.ramClass.instanceDescription().allBitsIn(1L)) {
            int n = this.ramClass.totalInstanceSize().intValue();
            int n2 = J9ObjectHelper.compressObjectReferences ? 4 : UDATA.SIZEOF;
            long l = n / n2;
            long l2 = l + (long)(UDATA.SIZEOF * 8 - 1) & (long)(~(UDATA.SIZEOF * 8 - 1));
            l2 /= (long)(UDATA.SIZEOF * 8);
            int n3 = 0;
            while ((long)n3 < l2) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, this.ramClass.instanceDescription().add(n3), "instanceDescription");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, this.ramClass.instanceLeafDescription().add(n3), "instanceLeafDescription");
                ++n3;
            }
            this.classWalkerCallback.addSection(this.clazz, this.ramClass.instanceDescription(), l2 * 2L * (long)UDATA.SIZEOF, "InstanceDescription", false);
        }
    }

    private void allSlotsInConstantPoolDo() throws CorruptDataException {
        J9ROMClassPointer j9ROMClassPointer = this.ramClass.romClass();
        int n = j9ROMClassPointer.ramConstantPoolCount().intValue();
        J9ConstantPoolPointer j9ConstantPoolPointer = J9ConstantPoolPointer.cast(this.ramClass.ramConstantPool());
        U32Pointer u32Pointer = J9ROMClassHelper.cpShapeDescription(j9ROMClassPointer);
        PointerPointer pointerPointer = PointerPointer.cast(this.ramClass.ramConstantPool());
        long l = 0L;
        long l2 = this.ramClass.romClass().ramConstantPoolCount().longValue();
        long l3 = 0L;
        while (l2 > 0L) {
            StructurePointer structurePointer;
            StructurePointer structurePointer2;
            long l4;
            if (0L == l3) {
                l = u32Pointer.at(0L).longValue();
                u32Pointer = u32Pointer.add(1L);
                l3 = J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32;
            }
            if ((l4 = l & J9ConstantPool.J9_CP_DESCRIPTION_MASK) == J9ConstantPool.J9CPTYPE_STRING || l4 == J9ConstantPool.J9CPTYPE_ANNOTATION_UTF8) {
                structurePointer2 = J9RAMStringRefPointer.cast(pointerPointer);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_RAM_UTF8, ((J9RAMStringRefPointer)structurePointer2).stringObjectEA(), "stringObject");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMStringRefPointer)structurePointer2).unusedEA(), "unused");
                if (l4 == J9ConstantPool.J9CPTYPE_STRING) {
                    this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMStringRef.SIZEOF, "J9CPTYPE_STRING", false);
                } else {
                    this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMStringRef.SIZEOF, "J9CPTYPE_ANNOTATION_UTF8", false);
                }
            } else if (l4 == J9ConstantPool.J9CPTYPE_METHOD_TYPE) {
                structurePointer2 = J9RAMMethodTypeRefPointer.cast(pointerPointer);
                structurePointer = ((J9RAMMethodTypeRefPointer)structurePointer2).type();
                if (structurePointer.notNull()) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodTypeRefPointer)structurePointer2).typeEA(), "type", "!j9object");
                } else {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodTypeRefPointer)structurePointer2).typeEA(), "type");
                }
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodTypeRefPointer)structurePointer2).slotCountEA(), "slotCount");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMMethodTypeRef.SIZEOF, "J9CPTYPE_METHOD_TYPE", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_METHODHANDLE) {
                structurePointer2 = J9RAMMethodHandleRefPointer.cast(pointerPointer);
                structurePointer = ((J9RAMMethodHandleRefPointer)structurePointer2).methodHandle();
                if (structurePointer.notNull()) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodHandleRefPointer)structurePointer2).methodHandleEA(), "methodHandle", "!j9object");
                } else {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodHandleRefPointer)structurePointer2).methodHandleEA(), "methodHandle");
                }
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodHandleRefPointer)structurePointer2).unusedEA(), "unused");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMMethodHandleRef.SIZEOF, "J9CPTYPE_METHODHANDLE", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_CLASS) {
                structurePointer2 = J9RAMClassRefPointer.cast(pointerPointer);
                if (((J9RAMClassRefPointer)structurePointer2).value().notNull()) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMClassRefPointer)structurePointer2).valueEA(), "value", "!j9class");
                } else {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMClassRefPointer)structurePointer2).valueEA(), "value");
                }
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMClassRefPointer)structurePointer2).modifiersEA(), "modifiers");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMClassRef.SIZEOF, "J9CPTYPE_CLASS", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_INT) {
                structurePointer2 = J9RAMConstantRefPointer.cast(pointerPointer);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMConstantRefPointer)structurePointer2).slot1EA(), "cpFieldInt");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMConstantRefPointer)structurePointer2).slot2EA(), "cpFieldIntUnused");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMConstantRef.SIZEOF, "J9CPTYPE_INT", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_FLOAT) {
                structurePointer2 = J9RAMConstantRefPointer.cast(pointerPointer);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMConstantRefPointer)structurePointer2).slot1EA(), "cpFieldFloat");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMConstantRefPointer)structurePointer2).slot2EA(), "cpFieldIntUnused");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMConstantRef.SIZEOF, "J9CPTYPE_FLOAT", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_LONG) {
                structurePointer2 = J9RAMConstantRefPointer.cast(pointerPointer);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_I64, I64Pointer.cast(pointerPointer), "J9CPTYPE_LONG");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMConstantRef.SIZEOF, "J9CPTYPE_LONG", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_DOUBLE) {
                structurePointer2 = J9RAMConstantRefPointer.cast(pointerPointer);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_I64, I64Pointer.cast(pointerPointer), "J9CPTYPE_DOUBLE");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, 8L, "J9CPTYPE_DOUBLE", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_FIELD) {
                structurePointer2 = J9RAMFieldRefPointer.cast(pointerPointer);
                structurePointer = J9RAMStaticFieldRefPointer.cast(pointerPointer);
                if (((J9RAMStaticFieldRefPointer)structurePointer).flagsAndClass().longValue() > 0L && !((J9RAMStaticFieldRefPointer)structurePointer).valueOffset().eq(UDATA.MAX)) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_IDATA, ((J9RAMStaticFieldRefPointer)structurePointer).flagsAndClassEA(), "flagsAndClass");
                } else {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMFieldRefPointer)structurePointer2).flagsEA(), "flags");
                }
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMFieldRefPointer)structurePointer2).valueOffsetEA(), "valueOffset");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMFieldRef.SIZEOF, "J9CPTYPE_FIELD", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_INTERFACE_METHOD) {
                structurePointer2 = J9RAMInterfaceMethodRefPointer.cast(pointerPointer);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMInterfaceMethodRefPointer)structurePointer2).interfaceClassEA(), "interfaceClass", "!j9class");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMInterfaceMethodRefPointer)structurePointer2).methodIndexAndArgCountEA(), "methodIndexAndArgCount");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMInterfaceMethodRef.SIZEOF, "J9CPTYPE_INTERFACE_METHOD", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_STATIC_METHOD) {
                structurePointer2 = J9RAMStaticMethodRefPointer.cast(pointerPointer);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMStaticMethodRefPointer)structurePointer2).methodEA(), "method", "!j9method");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMStaticMethodRefPointer)structurePointer2).methodIndexAndArgCountEA(), "unused");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMStaticMethodRef.SIZEOF, "J9CPTYPE_STATIC_METHOD", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_UNUSED || l4 == J9ConstantPool.J9CPTYPE_UNUSED8) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, pointerPointer, "unused");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, pointerPointer.add(1L), "unused");
                this.classWalkerCallback.addSection(this.clazz, pointerPointer, 2 * UDATA.SIZEOF, "J9CPTYPE_UNUSED", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_INSTANCE_METHOD) {
                structurePointer2 = J9RAMMethodRefPointer.cast(pointerPointer);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodRefPointer)structurePointer2).methodIndexAndArgCountEA(), "methodIndexAndArgCount");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodRefPointer)structurePointer2).methodEA(), "method", "!j9method");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMMethodRef.SIZEOF, "J9CPTYPE_INSTANCE_METHOD", false);
            } else if (l4 == J9ConstantPool.J9CPTYPE_HANDLE_METHOD) {
                structurePointer2 = J9RAMMethodRefPointer.cast(pointerPointer);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodRefPointer)structurePointer2).methodIndexAndArgCountEA(), "methodTypeIndexAndArgCount");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodRefPointer)structurePointer2).methodEA(), "unused");
                this.classWalkerCallback.addSection(this.clazz, structurePointer2, J9RAMMethodRef.SIZEOF, "J9CPTYPE_HANDLE_METHOD", false);
            }
            pointerPointer = pointerPointer.addOffset(J9RAMConstantPoolItem.SIZEOF);
            --l2;
            l >>= (int)J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION;
            --l3;
        }
        this.classWalkerCallback.addSection(this.clazz, j9ConstantPoolPointer, n * 2 * UDATA.SIZEOF, "Constant Pool               ", false);
    }

    private void allSlotsInRAMStaticsDo() throws CorruptDataException {
        Object object;
        DataType dataType;
        if (this.ramClass.ramStatics().isNull()) {
            return;
        }
        Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(this.ramClass, J9ClassHelper.superclass(this.ramClass), new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC));
        J9ObjectFieldOffset j9ObjectFieldOffset = null;
        while (iterator.hasNext()) {
            String string;
            j9ObjectFieldOffset = iterator.next();
            dataType = j9ObjectFieldOffset.getField();
            object = j9ObjectFieldOffset.getName();
            UDATA uDATA = ((J9ROMFieldShapePointer)dataType).modifiers();
            UDATAPointer uDATAPointer = this.ramClass.ramStatics().addOffset(j9ObjectFieldOffset.getOffsetOrAddress());
            String string2 = string = uDATA.anyBitsIn(J9FieldFlags.J9FieldFlagObject) ? "!j9object" : "";
            if (uDATA.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_I64, I64Pointer.cast(uDATAPointer), (String)object, string);
                continue;
            }
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, uDATAPointer, (String)object, string);
        }
        dataType = this.ramClass.romClass().objectStaticCount().add(this.ramClass.romClass().singleScalarStaticCount());
        dataType = J9BuildFlags.env_data64 ? ((UDATA)dataType).add(this.ramClass.romClass().doubleScalarStaticCount()) : ((UDATA)dataType).add(1L).bitAnd(-2L).add(this.ramClass.romClass().doubleScalarStaticCount().mult(2));
        object = Scalar.convertSlotsToBytes(new UDATA((Scalar)dataType));
        this.classWalkerCallback.addSection(this.clazz, this.ramClass.ramStatics(), ((Scalar)object).longValue(), "Ram static", false);
    }

    private void allSlotsInRAMMethodsSectionDo() throws CorruptDataException {
        int n = this.ramClass.romClass().romMethodCount().intValue();
        if (n != 0) {
            J9MethodPointer j9MethodPointer = this.ramClass.ramMethods();
            for (int i = 0; i < n; ++i) {
                J9MethodPointer j9MethodPointer2 = j9MethodPointer.add(i);
                this.classWalkerCallback.addSection(this.clazz, j9MethodPointer2, J9Method.SIZEOF, "J9Method", false);
                this.addObjectsasSlot(j9MethodPointer2);
            }
            this.classWalkerCallback.addSection(this.clazz, this.ramClass.ramMethods(), (long)n * J9Method.SIZEOF, "RAM methods", false);
        }
    }

    private void allSlotsInExtendedMethodBlockDo() throws CorruptDataException {
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (j9JavaVMPointer.runtimeFlags().allBitsIn(J9Consts.J9_RUNTIME_EXTENDED_METHOD_BLOCK)) {
            long l = 0L;
            int n = this.ramClass.romClass().romMethodCount().intValue();
            l = n + (UDATA.SIZEOF - 1);
            U8Pointer u8Pointer = U8Pointer.cast(this.ramClass.ramMethods()).sub(l &= (long)(~(UDATA.SIZEOF - 1)));
            this.classWalkerCallback.addSection(this.clazz, u8Pointer, n, "Extended method block", false);
            while (n-- > 0) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, u8Pointer.add(n), "method flag", "!j9extendedmethodflaginfo");
            }
        }
    }

    private void allSlotsInVTableDo() throws CorruptDataException {
        if (AlgorithmVersion.getVersionOf("ALG_VM_VTABLE_VERSION").getAlgorithmVersion() >= 1) {
            J9VTableHeaderPointer j9VTableHeaderPointer = J9ClassHelper.vTableHeader(this.ramClass);
            long l = j9VTableHeaderPointer.size().longValue();
            long l2 = UDATA.SIZEOF;
            UDATAPointer uDATAPointer = J9ClassHelper.vTable(j9VTableHeaderPointer);
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, j9VTableHeaderPointer, "VTable size");
            if (l > 0L) {
                l2 = J9VTableHeader.SIZEOF + l * (long)UDATA.SIZEOF;
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, j9VTableHeaderPointer.initialVirtualMethod(), "magic method", "!j9method");
                int n = 0;
                while ((long)n < l) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, uDATAPointer.add(n), "method", "!j9method");
                    ++n;
                }
            }
            this.classWalkerCallback.addSection(this.clazz, j9VTableHeaderPointer, l2, "vTable", true);
        } else {
            UDATAPointer uDATAPointer = J9ClassHelper.oldVTable(this.ramClass);
            long l = Math.max(1L, uDATAPointer.at(0L).longValue());
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, uDATAPointer, "VTable size");
            int n = 1;
            while ((long)n <= l) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, uDATAPointer.add(n), (n == 1 ? "magic " : "") + "method", "!j9method");
                ++n;
            }
            this.classWalkerCallback.addSection(this.clazz, uDATAPointer, l * (long)UDATA.SIZEOF, "vTable", true);
        }
    }

    private void allSlotsInJitVTablesDo() throws CorruptDataException {
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (!j9JavaVMPointer.jitConfig().isNull()) {
            long l;
            long l2;
            if (AlgorithmVersion.getVersionOf("ALG_VM_VTABLE_VERSION").getAlgorithmVersion() >= 1) {
                l2 = J9ClassHelper.vTableHeader(this.ramClass).size().longValue();
                l = (l2 - 1L) * (long)UDATA.SIZEOF + J9VTableHeader.SIZEOF;
            } else {
                l2 = J9ClassHelper.oldVTable(this.ramClass).at(0L).longValue();
                l = l2 * (long)UDATA.SIZEOF;
            }
            int n = 0;
            while ((long)n < l2) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, UDATAPointer.cast(this.ramClass.subOffset(l)).add(n), "send target", "");
                ++n;
            }
            this.classWalkerCallback.addSection(this.clazz, this.ramClass.subOffset(l), l, "jitVTables", true);
        }
    }

    private void allSlotsInRAMHeaderDo() throws CorruptDataException {
        this.classWalkerCallback.addSection(this.clazz, this.clazz, J9Class.SIZEOF, "ramHeader", true);
        if (J9ClassHelper.isArrayClass(this.ramClass)) {
            this.addObjectsasSlot(J9ArrayClassPointer.cast(this.ramClass));
        } else {
            if (J9ClassHelper.isSwappedOut(this.ramClass)) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("arrayClass", "currentClass");
                this.addObjectsAsSlot(this.ramClass, hashMap);
            }
            this.addObjectsasSlot(this.ramClass);
        }
    }

    @Override
    protected void fillDebugExtMap() {
        this.debugExtMap.put("romClass", "!dumpromclasslinear");
        this.debugExtMap.put("classLoader", "!j9classloader");
        this.debugExtMap.put("classObject", "!j9vmjavalangclass");
        this.debugExtMap.put("ramMethods", "!j9method");
        this.debugExtMap.put("arrayClass", "!j9class");
        this.debugExtMap.put("initializerCache", "!j9method");
        this.debugExtMap.put("subclassTraversalLink", "!j9class");
        this.debugExtMap.put("replacedClass", "!j9class");
        this.debugExtMap.put("constantPool", "!j9constantpool");
        this.debugExtMap.put("bytecodes", "!bytecodes");
    }
}

