/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PackagePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ModularityHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class FindModulesCommand
extends Command {
    public FindModulesCommand() {
        this.addCommand("findmodules", "[all|name <moduleName>|requires <moduleName>|package <packageName>|help]", "Find a module or set of modules that are loaded by the runtime.");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        Subcommand subcommand;
        String string2 = null;
        ModularityHelper.ModuleIteratorFilter moduleIteratorFilter = null;
        ModularityHelper.ModuleOutput moduleOutput = ModularityHelper::printJ9Module;
        ModularityHelper.PackageIteratorFilter packageIteratorFilter = null;
        block1 : switch (stringArray.length) {
            case 0: {
                moduleIteratorFilter = ModularityHelper::moduleFilterMatchAll;
                subcommand = Subcommand.MODULE;
                break;
            }
            case 1: {
                switch (stringArray[0]) {
                    case "all": {
                        moduleIteratorFilter = ModularityHelper::moduleFilterMatchAll;
                        subcommand = Subcommand.MODULE;
                        break block1;
                    }
                    case "help": {
                        subcommand = Subcommand.HELP;
                        break block1;
                    }
                }
                subcommand = Subcommand.INVALID;
                break;
            }
            case 2: {
                string2 = stringArray[1];
                switch (stringArray[0]) {
                    case "name": {
                        moduleIteratorFilter = FindModulesCommand::filterModuleName;
                        subcommand = Subcommand.MODULE;
                        break block1;
                    }
                    case "requires": {
                        moduleIteratorFilter = FindModulesCommand::filterModuleName;
                        moduleOutput = FindModulesCommand::printModuleReads;
                        subcommand = Subcommand.MODULE;
                        break block1;
                    }
                    case "package": {
                        packageIteratorFilter = FindModulesCommand::filterPackageName;
                        subcommand = Subcommand.PACKAGE;
                        break block1;
                    }
                }
                subcommand = Subcommand.INVALID;
                break;
            }
            default: {
                subcommand = Subcommand.INVALID;
            }
        }
        try {
            switch (subcommand) {
                case MODULE: {
                    int n = ModularityHelper.iterateModules(printStream, moduleIteratorFilter, moduleOutput, string2);
                    printStream.printf("Found %d module%s%n", n, 1 == n ? "" : "s");
                    break;
                }
                case PACKAGE: {
                    ModularityHelper.PackageOutput packageOutput = ModularityHelper::printPackageJ9Module;
                    int n = ModularityHelper.iteratePackages(printStream, packageIteratorFilter, packageOutput, string2);
                    printStream.printf("Found %d module%s%n", n, 1 == n ? "" : "s");
                    break;
                }
                case HELP: {
                    FindModulesCommand.printHelp(printStream);
                    break;
                }
                default: {
                    printStream.println("Argument failed to parse or was parsed to an unhandled subcommand.");
                    FindModulesCommand.printHelp(printStream);
                    break;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private static void printModuleReads(J9ModulePointer j9ModulePointer, PrintStream printStream) throws CorruptDataException {
        J9HashTablePointer j9HashTablePointer = j9ModulePointer.readAccessHashTable();
        HashTable<J9ModulePointer> hashTable = ModuleHashTable.fromJ9HashTable(j9HashTablePointer);
        Iterator iterator = hashTable.iterator();
        while (iterator.hasNext()) {
            J9ModulePointer j9ModulePointer2 = (J9ModulePointer)iterator.next();
            ModularityHelper.printJ9Module(j9ModulePointer2, printStream);
        }
    }

    private static boolean filterModuleName(J9ModulePointer j9ModulePointer, String string) throws CorruptDataException {
        return J9ObjectHelper.stringValue(j9ModulePointer.moduleName()).equals(string);
    }

    private static boolean filterRequiresTargetModule(J9ModulePointer j9ModulePointer, String string) throws CorruptDataException {
        boolean bl = false;
        J9HashTablePointer j9HashTablePointer = j9ModulePointer.readAccessHashTable();
        HashTable<J9ModulePointer> hashTable = ModuleHashTable.fromJ9HashTable(j9HashTablePointer);
        Iterator iterator = hashTable.iterator();
        while (iterator.hasNext()) {
            J9ModulePointer j9ModulePointer2 = (J9ModulePointer)iterator.next();
            if (!J9ObjectHelper.stringValue(j9ModulePointer2.moduleName()).equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean filterPackageName(J9PackagePointer j9PackagePointer, String string) throws CorruptDataException {
        return J9UTF8Helper.stringValue(j9PackagePointer.packageName()).equals(string);
    }

    private static void printHelp(PrintStream printStream) {
        printStream.println("Usage:");
        printStream.println("  !findmodules");
        printStream.println("      Returns !findmodules all");
        printStream.println("  !findmodules all");
        printStream.println("      Returns all loaded modules");
        printStream.println("  !findmodules name <moduleName>");
        printStream.println("      Returns all loaded modules with the same name as provided");
        printStream.println("  !findmodules requires <moduleName>");
        printStream.println("      Returns all loaded modules which require the provided module");
        printStream.println("  !findmodules package <packageName>");
        printStream.println("      Returns the loaded module which owns the provided package");
        printStream.println("Output Format:");
        printStream.println("  <module name>                  !j9module <module hexaddress>");
        printStream.println("Output Example:");
        printStream.println("  java.base                      !j9module 0x00007FAC2008EAC8");
    }

    private static enum Subcommand {
        MODULE,
        PACKAGE,
        HELP,
        INVALID;

    }
}

