/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.structure.MM_HeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckElement;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckError;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckReporter;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class CheckReporterTTY
extends CheckReporter {
    private PrintStream out;
    private static String[] errorTypes = new String[]{"no error", "not aligned", "double array not aligned", "object not in an object region", "not in an object segment", "overlaps segment boundary", "heap object on stack", "class pointer is null", "class pointer not aligned", "class pointer not in a class segment", "class pointer overlaps segment boundary", "class pointer of class is not java.lang.Class", "class pointer on stack", "invalid flags", "in an old segment, old bit not set", "in a new segment, old or remembered bit set", "hole has size <= 0", "new pointer in old object without remembered bit set", "not in an old segment or class segment", "old bit or remembered bit not set", "not in remembered set, new object reference", "pool and puddle newstore flag mismatch", "puddle newstore flag invalid", "heap object has remembered bit set when cardtable active", "new pointer in old object without card dirtied", "dead object", "class header invalid", "class object not java.lang.Class", "scope internal pointer refers outside its scope", "class pointer is in an undead class segment", "class ramStatics field points to wrong object", "class ramStatics must be NULL for hot swapped class", "class ramStatics field points to object but out of GC scan range", "class ramStatics number of references not equal specified in ROM class", "obsolete code 34", "obsolete code 35", "obsolete code 36", "obsolete code 37", "class object not a subclass of java.util.concurrent.locks.AbstractOwnableSynchronizer", "array class can not be hot swapped", "replaced class has no hot swapped out flag set", "object slot appears to contain a J9Class pointer", "Ownable Synchronizer Object is not attached to the list", "Ownable Synchronizer List has a circular reference", "hole size is not aligned", "hole next is not a hole", "hole next is outside of current region", "hole next is pointed inside of the hole", "class is unloaded", "reversed forwarded pointed outside evacuate"};

    public CheckReporterTTY(PrintStream printStream) {
        this.out = printStream;
    }

    public CheckReporterTTY() {
        this(System.out);
    }

    @Override
    public void report(CheckError checkError) {
        if (!this.shouldReport(checkError)) {
            return;
        }
        try {
            if (checkError._slot != null && checkError._slot.notNull()) {
                UDATA uDATA;
                VoidPointer voidPointer = checkError._slot;
                switch (checkError._objectType) {
                    case 1: {
                        J9ObjectPointer j9ObjectPointer = ObjectReferencePointer.cast(voidPointer).at(0L);
                        uDATA = UDATA.cast(j9ObjectPointer);
                        break;
                    }
                    case 3: {
                        uDATA = UDATAPointer.cast(voidPointer).at(0L);
                        voidPointer = checkError._stackLocation;
                        break;
                    }
                    case 5: {
                        uDATA = UDATA.cast(voidPointer);
                        voidPointer = VoidPointer.NULL;
                        break;
                    }
                    default: {
                        uDATA = UDATAPointer.cast(voidPointer).at(0L);
                    }
                }
                this.out.println(String.format("  <gc check (%d): %s: %s: %sslot %x(%x) -> %x: %s>", checkError._errorNumber, "from debugger", checkError._check.getCheckName(), checkError._elementName, checkError._object.getAddress(), voidPointer.getAddress(), uDATA.longValue(), this.getErrorType(checkError._errorCode)));
            } else {
                this.out.println(String.format("  <gc check (%d): %s: %s: %s%x: %s>", checkError._errorNumber, "from debugger", checkError._check.getCheckName(), checkError._elementName, checkError._object.getAddress(), this.getErrorType(checkError._errorCode)));
                if (checkError._objectType == 1) {
                    this.reportObjectHeader(checkError, J9ObjectPointer.cast(checkError._object), "");
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            this.out.println(String.format("  <gc check (%d): %s: %s: %s%x: %s>", checkError._errorNumber, "from debugger", checkError._check.getCheckName(), checkError._elementName, checkError._object.getAddress(), this.getErrorType(checkError._errorCode)));
        }
    }

    private String getErrorType(int n) {
        if (n == Integer.MAX_VALUE) {
            return "corrupt data exception";
        }
        return errorTypes[n];
    }

    @Override
    public void reportClass(CheckError checkError, J9ClassPointer j9ClassPointer, String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string;
        if (!this.shouldReport(checkError)) {
            return;
        }
        this.out.println(String.format("  <gc check (%d): %sClass %x>", checkError._errorNumber, string2, j9ClassPointer.getAddress()));
    }

    @Override
    public void reportFatalError(CheckError checkError) {
        this.out.println(String.format("  <gc check (%d): Cannot resolve problem detected on heap, aborting check>", checkError._errorNumber));
    }

    @Override
    public void reportHeapWalkError(CheckError checkError, CheckElement checkElement, CheckElement checkElement2, CheckElement checkElement3) {
        this.reportFatalError(checkError);
        if (!checkElement.isNone()) {
            this.reportGenericType(checkError, checkElement, "Previous ");
            if (!checkElement2.isNone()) {
                this.reportGenericType(checkError, checkElement2, "Previous ");
                if (!checkElement3.isNone()) {
                    this.reportGenericType(checkError, checkElement3, "Previous ");
                }
            }
        } else {
            this.out.println(String.format("  <gc check (%d): %x was first object encountered on heap>", checkError._errorNumber, checkError._object.getAddress()));
        }
    }

    @Override
    public void reportObjectHeader(CheckError checkError, J9ObjectPointer j9ObjectPointer, String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string;
        if (!this.shouldReport(checkError)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = ObjectModel.isDeadObject(j9ObjectPointer);
            if (!bl2) {
                bl3 = ObjectModel.isIndexable(j9ObjectPointer);
            }
            bl = true;
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        if (bl) {
            if (bl3) {
                this.out.print(String.format("  <gc check (%d): %sIObject %x header:", checkError._errorNumber, string2, j9ObjectPointer.getAddress()));
            } else {
                String string4 = bl2 ? "Hole" : "Object";
                this.out.print(String.format("  <gc check (%d): %s%s %x header:", checkError._errorNumber, string2, string4, j9ObjectPointer.getAddress()));
            }
        } else {
            this.out.print(String.format("  <gc check (%d): %s%s %x header:", checkError._errorNumber, string2, "Corrupt", j9ObjectPointer.getAddress()));
        }
        int n = (int)J9ObjectHelper.headerSize();
        if (bl2) {
            n = (int)MM_HeapLinkedFreeHeader.SIZEOF;
        } else {
            try {
                n = ObjectModel.getHeaderSize(j9ObjectPointer).intValue();
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
        try {
            U32Pointer u32Pointer = U32Pointer.cast(j9ObjectPointer);
            for (int i = 0; i < n / 4; ++i) {
                this.out.print(String.format(" %08X", u32Pointer.at(i).longValue()));
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        this.out.println(">");
    }

    @Override
    public void println(String string) {
        this.out.println(string);
    }

    @Override
    public void print(String string) {
        this.out.print(string);
    }

    @Override
    public void reportForwardedObject(J9ObjectPointer j9ObjectPointer, J9ObjectPointer j9ObjectPointer2) {
        this.out.println(String.format("  <gc check: found forwarded pointer %x -> %x>", j9ObjectPointer.getAddress(), j9ObjectPointer2.getAddress()));
    }
}

