#ifdef GL_ES 
#define LOWP lowp
#define MED mediump
#define HIGH highp
precision highp float;
#else
#define MED
#define LOWP
#define HIGH
#endif

varying vec4 v_color;  
varying vec2 v_texCoords;  
uniform vec4 u_intersect;
uniform float u_cutAlpha;
uniform int u_cutSide;
uniform int u_disappear;

uniform sampler2D u_texture;  

float DistToLine( vec2 a, vec2 b, vec2 p )
{
   vec2 v = a, w = b;
    
    float l2 = pow(distance(w, v), 2.);
    if(l2 == 0.0) return distance(p, v);
    
    float t = clamp(dot(p - v, w - v) / l2, 0., 1.);
    vec2 j = v + t * (w - v);
    
    return distance(p, j);
}

void main(){              
	

  vec4 col = v_color * texture2D(u_texture, v_texCoords);

  //put frag coords in the worldspace of the line
  vec2 lineSpace = gl_FragCoord.xy - u_intersect.xy;
  vec2 v0 = lineSpace;
  vec2 v1 = u_intersect.zw;

  float lineXRatio = (gl_FragCoord.x-u_intersect.r)/(u_intersect.b-u_intersect.r);

  vec2 lineStart = u_intersect.xy;
  vec2 lineEnd = u_intersect.xy+(u_intersect.zw*u_cutAlpha);
  vec2 point = gl_FragCoord.xy;
  float dst = DistToLine(lineStart, lineEnd, point);

	float tmp = dst - (1.0 + float(u_disappear));

	if(tmp<0.0) {
		col.a = 0.0;
	} else if (tmp<1.0) {
		col.rgb = vec3(0.7);
	} else if (tmp<5.0) {
    col.r += (5.0-tmp)*0.1;
    col.g += (5.0-tmp)*0.01;
  }

  float dot = v0.x*v1.y - v0.y*v1.x;

  col.a=(dot*float(u_cutSide))<=0.0?col.a:0.0;
  
  gl_FragColor = col;
}

