/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet;

import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.physics.bullet.collision.btBvhTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btCompoundShape;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMath;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.util.Arrays;

public class Bullet {
    public static final int VERSION = 287;
    protected static boolean useRefCounting = false;
    protected static boolean enableLogging = true;
    private static final Pool<ShapePart> shapePartPool = new Pool<ShapePart>(){

        @Override
        protected ShapePart newObject() {
            return new ShapePart();
        }
    };
    private static final Array<ShapePart> shapePartArray = new Array();
    private static final Matrix4 idt = new Matrix4();
    private static final Matrix4 tmpM = new Matrix4();

    public static void init() {
        Bullet.init(false);
    }

    public static void init(boolean useRefCounting) {
        Bullet.init(useRefCounting, true);
    }

    public static void init(boolean useRefCounting, boolean logging) {
        Bullet.useRefCounting = useRefCounting;
        enableLogging = logging;
        new SharedLibraryLoader().load("gdx-bullet");
        int version = LinearMath.btGetVersion();
        if (version != 287) {
            throw new GdxRuntimeException("Bullet binaries version (" + version + ") does not match source version (" + 287 + ")");
        }
    }

    public static void getShapeParts(Node node, boolean applyTransform, Array<ShapePart> out, int offset, Pool<ShapePart> pool) {
        Matrix4 transform;
        Matrix4 matrix4 = transform = applyTransform ? node.localTransform : idt;
        if (node.parts.size > 0) {
            int i;
            ShapePart part = null;
            int n = out.size;
            for (i = offset; i < n; ++i) {
                ShapePart p = out.get(i);
                if (!Arrays.equals(p.transform.val, transform.val)) continue;
                part = p;
                break;
            }
            if (part == null) {
                part = pool.obtain();
                part.parts.clear();
                part.transform.set(transform);
                out.add(part);
            }
            n = node.parts.size;
            for (i = 0; i < n; ++i) {
                part.parts.add(node.parts.get((int)i).meshPart);
            }
        }
        if (node.hasChildren()) {
            boolean transformed = applyTransform && !Arrays.equals(transform.val, Bullet.idt.val);
            int o = transformed ? out.size : offset;
            Bullet.getShapeParts(node.getChildren(), out, o, pool);
            if (transformed) {
                int n = out.size;
                for (int i = o; i < n; ++i) {
                    ShapePart part = out.get(i);
                    tmpM.set(part.transform);
                    part.transform.set(transform).mul(tmpM);
                }
            }
        }
    }

    public static <T extends Node> void getShapeParts(Iterable<T> nodes, Array<ShapePart> out, int offset, Pool<ShapePart> pool) {
        for (Node node : nodes) {
            Bullet.getShapeParts(node, true, out, offset, pool);
        }
    }

    public static btCollisionShape obtainStaticNodeShape(Node node, boolean applyTransform) {
        Bullet.getShapeParts(node, applyTransform, shapePartArray, 0, shapePartPool);
        btCollisionShape result = Bullet.obtainStaticShape(shapePartArray);
        shapePartPool.freeAll(shapePartArray);
        shapePartArray.clear();
        return result;
    }

    public static btCollisionShape obtainStaticNodeShape(Array<Node> nodes) {
        Bullet.getShapeParts(nodes, shapePartArray, 0, shapePartPool);
        btCollisionShape result = Bullet.obtainStaticShape(shapePartArray);
        shapePartPool.freeAll(shapePartArray);
        shapePartArray.clear();
        return result;
    }

    public static btCollisionShape obtainStaticShape(Array<ShapePart> parts) {
        if (parts.size == 0) {
            return null;
        }
        if (parts.size == 1 && Arrays.equals(parts.get((int)0).transform.val, Bullet.idt.val)) {
            return btBvhTriangleMeshShape.obtain(parts.get((int)0).parts);
        }
        btCompoundShape result = new btCompoundShape();
        result.obtain();
        int n = parts.size;
        for (int i = 0; i < n; ++i) {
            btBvhTriangleMeshShape shape = btBvhTriangleMeshShape.obtain(parts.get((int)i).parts);
            result.addChildShape(parts.get((int)i).transform, shape);
            shape.release();
        }
        return result;
    }

    protected static class ShapePart {
        public Array<MeshPart> parts = new Array();
        public Matrix4 transform = new Matrix4();

        protected ShapePart() {
        }
    }
}

