/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.SWIGTYPE_p_size_t;
import java.nio.ByteBuffer;

public class btGenericMemoryPool
extends BulletBase {
    private long swigCPtr;

    protected btGenericMemoryPool(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btGenericMemoryPool(long cPtr, boolean cMemoryOwn) {
        this("btGenericMemoryPool", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btGenericMemoryPool obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btGenericMemoryPool(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setPool(ByteBuffer value) {
        assert (value.isDirect()) : "Buffer must be allocated direct.";
        CollisionJNI.btGenericMemoryPool_pool_set(this.swigCPtr, this, value);
    }

    public ByteBuffer getPool() {
        return CollisionJNI.btGenericMemoryPool_pool_get(this.swigCPtr, this);
    }

    public void setFree_nodes(SWIGTYPE_p_size_t value) {
        CollisionJNI.btGenericMemoryPool_free_nodes_set(this.swigCPtr, this, SWIGTYPE_p_size_t.getCPtr(value));
    }

    public SWIGTYPE_p_size_t getFree_nodes() {
        long cPtr = CollisionJNI.btGenericMemoryPool_free_nodes_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new SWIGTYPE_p_size_t(cPtr, false);
    }

    public void setAllocated_sizes(SWIGTYPE_p_size_t value) {
        CollisionJNI.btGenericMemoryPool_allocated_sizes_set(this.swigCPtr, this, SWIGTYPE_p_size_t.getCPtr(value));
    }

    public SWIGTYPE_p_size_t getAllocated_sizes() {
        long cPtr = CollisionJNI.btGenericMemoryPool_allocated_sizes_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new SWIGTYPE_p_size_t(cPtr, false);
    }

    public void setAllocated_count(long value) {
        CollisionJNI.btGenericMemoryPool_allocated_count_set(this.swigCPtr, this, value);
    }

    public long getAllocated_count() {
        return CollisionJNI.btGenericMemoryPool_allocated_count_get(this.swigCPtr, this);
    }

    public void setFree_nodes_count(long value) {
        CollisionJNI.btGenericMemoryPool_free_nodes_count_set(this.swigCPtr, this, value);
    }

    public long getFree_nodes_count() {
        return CollisionJNI.btGenericMemoryPool_free_nodes_count_get(this.swigCPtr, this);
    }

    public void init_pool(long element_size, long element_count) {
        CollisionJNI.btGenericMemoryPool_init_pool(this.swigCPtr, this, element_size, element_count);
    }

    public void end_pool() {
        CollisionJNI.btGenericMemoryPool_end_pool(this.swigCPtr, this);
    }

    public btGenericMemoryPool(long element_size, long element_count) {
        this(CollisionJNI.new_btGenericMemoryPool(element_size, element_count), true);
    }

    public long get_pool_capacity() {
        return CollisionJNI.btGenericMemoryPool_get_pool_capacity(this.swigCPtr, this);
    }

    public long gem_element_size() {
        return CollisionJNI.btGenericMemoryPool_gem_element_size(this.swigCPtr, this);
    }

    public long get_max_element_count() {
        return CollisionJNI.btGenericMemoryPool_get_max_element_count(this.swigCPtr, this);
    }

    public long get_allocated_count() {
        return CollisionJNI.btGenericMemoryPool_get_allocated_count(this.swigCPtr, this);
    }

    public long get_free_positions_count() {
        return CollisionJNI.btGenericMemoryPool_get_free_positions_count(this.swigCPtr, this);
    }

    public long get_element_data(long element_index) {
        return CollisionJNI.btGenericMemoryPool_get_element_data(this.swigCPtr, this, element_index);
    }

    public long allocate(long size_bytes) {
        return CollisionJNI.btGenericMemoryPool_allocate(this.swigCPtr, this, size_bytes);
    }

    public boolean freeMemory(long pointer) {
        return CollisionJNI.btGenericMemoryPool_freeMemory(this.swigCPtr, this, pointer);
    }
}

