/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.entity.hero;

import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNMid;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.targetable.ability.generation.SpellGeneration;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellBill;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.trigger.personal.spell.learn.LearnSpell;
import java.util.List;

public class PipeHeroAbility
extends PipeRegexNamed<HeroType> {
    static final PRNPart SEP = new PRNMid("abilitydata");

    public PipeHeroAbility() {
        super(HERO, SEP, HERO);
    }

    @Override
    public HeroType example() {
        return this.make(HeroTypeUtils.random(), HeroTypeUtils.byName("(whirl.i.pendulum)"));
    }

    @Override
    protected HeroType internalMake(String[] groups) {
        String src = groups[0];
        String data = groups[1];
        return this.make(HeroTypeLib.byName(src), HeroTypeLib.byName(data));
    }

    private HeroType make(HeroType src, HeroType data) {
        if (src.isMissingno() || data.isMissingno()) {
            return null;
        }
        String realHeroName = src.getName() + SEP + data.getName();
        SpellBill sb = new SpellBill();
        sb.title(data.getName(true, false));
        List<EntSideState> states = data.makeEnt().getBlankState().getAllSideStates();
        Eff base = states.get(2).getCalculatedEffect();
        if (!this.okForAbilityMaybe(base) && !this.okForAbilityMaybe(base)) {
            return null;
        }
        EffBill eb = new EffBill(base);
        Eff bonus = states.get(4).getCalculatedEffect();
        if (bonus.getType() != EffType.Blank) {
            if (bonus.needsTarget()) {
                return null;
            }
            if (!this.okForAbilityMaybe(bonus)) {
                return null;
            }
            eb.bonusUntargeted(bonus);
        }
        sb.eff(eb.bEff());
        sb.cost(states.get(3).getCalculatedEffect().getValue());
        sb.overrideImage(data.portrait);
        LearnSpell la = new LearnSpell(sb.bSpell());
        HeroType result = HeroTypeUtils.withPassive(src, realHeroName, la, "Custom spell");
        return result;
    }

    private boolean okForAbilityMaybe(Eff base) {
        if (base.getType() == EffType.Mana && base.getKeywords().isEmpty()) {
            return true;
        }
        return SpellGeneration.okForAbilityMaybe(base);
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

