/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.item;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.modifier.modBal.TierUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableUtils;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.util.Tann;
import java.util.List;

public class PipeItemCombined
extends PipeRegexNamed<Item> {
    public PipeItemCombined() {
        super(ITEM, PipeItemCombined.prnS("#"), ITEM);
    }

    public static Choosable glue(List<Item> toulouse) {
        if (toulouse.size() == 0) {
            return ItemLib.byName("iuedrghjiuehrg");
        }
        if (toulouse.size() == 1) {
            return toulouse.get(0);
        }
        return ItemLib.byName(Tann.join("#", ItemLib.names(toulouse)));
    }

    @Override
    protected Item internalMake(String[] groups) {
        String a = groups[0];
        String b = groups[1];
        if (PipeItemCombined.bad(a, b)) {
            return null;
        }
        return PipeItemCombined.make(ItemLib.byName(a), ItemLib.byName(b));
    }

    public static Item make(Item a, Item b) {
        if (a.isMissingno() || b.isMissingno()) {
            return null;
        }
        String name = a.getName(false) + "#" + b.getName(false);
        float totalModTier = TierUtils.itemModTier(a.getTier()) + TierUtils.itemModTier(b.getTier());
        int tier = TierUtils.fromModTier(ChoosableType.Item, totalModTier);
        if (!OptionLib.DISABLE_RUNTIME_TEXTURES.c()) {
            // empty if block
        }
        ItBill ib = ItBill.make(tier, name, a, b, "special/combined");
        ib.trigger(a.getPersonalTriggers());
        ib.trigger(b.getPersonalTriggers());
        return ib.bItem();
    }

    public static Item makeChecked(Item a, Item b) {
        if (ChoosableUtils.collides((Choosable)a, b) || PipeItemCombined.aBlankBAffect(a, b) || PipeItemCombined.aBlankBAffect(b, a)) {
            return null;
        }
        return PipeItemCombined.make(a, b);
    }

    private static boolean aBlankBAffect(Item a, Item b) {
        boolean has = false;
        for (Personal personalTrigger : b.getPersonalTriggers()) {
            has |= personalTrigger instanceof AffectSides;
        }
        has |= (b.getCollisionBits() & Collision.GENERIC_ALL_SIDES_HERO) != 0L;
        return (has |= (b.getCollisionBits() & Collision.ALL_SIDES_HERO_COMPOSITE) != 0L) && (a.getCollisionBits() & Collision.BLANK_SIDE) != 0L;
    }

    @Override
    public Item example() {
        return PipeItemCombined.makeChecked(ItemLib.random(), ItemLib.random());
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return true;
    }

    @Override
    protected Item generateInternal(boolean wild) {
        return this.example();
    }

    @Override
    public boolean showHigher() {
        return true;
    }
}

