/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.item;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.modifier.modBal.TierUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.util.Tann;
import com.tann.dice.util.bsRandom.Checker;
import com.tann.dice.util.bsRandom.RandomCheck;
import com.tann.dice.util.bsRandom.Supplier;
import com.tann.dice.util.ui.TextWriter;
import java.util.Arrays;
import java.util.List;

public class PipeItemKeyword
extends PipeRegexNamed<Item> {
    static final PRNPart PREF = new PRNPref("k");
    public static final List<Keyword> banned = Arrays.asList(Keyword.copycat, Keyword.cruel, Keyword.dispel, Keyword.dogma, Keyword.duplicate, Keyword.echo, Keyword.ego, Keyword.enduring, Keyword.engage, Keyword.fierce, Keyword.growth, Keyword.inspired, Keyword.repel, Keyword.rescue, Keyword.resilient, Keyword.sixth, Keyword.stasis, Keyword.steel, Keyword.underdog, Keyword.vigil, Keyword.zeroed, Keyword.eliminate, Keyword.chain, Keyword.fierce, Keyword.eliminate);

    public PipeItemKeyword() {
        super(PREF, KEYWORD);
    }

    @Override
    protected Item internalMake(String[] groups) {
        Keyword k = Keyword.byName(groups[0]);
        if (k != null) {
            return PipeItemKeyword.makeItem(k);
        }
        return null;
    }

    public static boolean isBanned(Keyword k) {
        return banned.contains((Object)k);
    }

    private static Item makeItem(Keyword k) {
        if (k.spellOnly()) {
            return null;
        }
        float tier = KUtils.getModTierAllHero(k) / 5.0f;
        tier = TierUtils.fromModTier(ChoosableType.Item, tier);
        tier = Math.max(0.0f, tier);
        tier *= 1.2f;
        if (PipeItemKeyword.isBanned(k)) {
            tier = 0.0f;
        }
        ItBill ib = new ItBill(Math.round(tier), PREF + k.name().toLowerCase(), "special/keyword/" + TextWriter.getNameForColour(k.getColour()));
        ib.trigger(new AffectSides(new AddKeyword(k)));
        return ib.bItem();
    }

    @Override
    public Item example() {
        return PipeItemKeyword.makeItem(RandomCheck.checkedRandom(new Supplier<Keyword>(){

            @Override
            public Keyword supply() {
                return Tann.random(Keyword.values());
            }
        }, new Checker<Keyword>(){

            @Override
            public boolean check(Keyword keyword) {
                return !keyword.spellOnly();
            }
        }, Keyword.pain));
    }

    public static Item makeRandomForEvent() {
        return PipeItemKeyword.makeRandomForEvent();
    }

    public static Item makeRandomForEvent(SpecificSidesType sst) {
        Keyword k = RandomCheck.checkedRandom(Arrays.asList(Keyword.values()), new Checker<Keyword>(){

            @Override
            public boolean check(Keyword keyword) {
                return !keyword.spellOnly();
            }
        }, Keyword.enduring);
        return ItemLib.byName(sst.getShortName() + ".k." + (Object)((Object)k));
    }

    @Override
    public float getRarity(boolean wild) {
        return 0.3f;
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return true;
    }

    @Override
    protected Item generateInternal(boolean wild) {
        int attempts = 5;
        for (int at = 0; at < attempts; ++at) {
            Item i = PipeItemKeyword.makeItem(Tann.random(Keyword.values()));
            if (i == null || i.getTier() == 0) continue;
            return i;
        }
        return null;
    }

    @Override
    public boolean showHigher() {
        return true;
    }
}

